/*
 * Decompiled with CFR 0.152.
 */
package com.sas.midtier.components.container.impl;

import com.sas.midtier.components.container.ContainerComposer;
import com.sas.midtier.components.container.ContainerCompositionException;
import com.sas.midtier.components.container.ContainerManager;
import com.sas.midtier.components.container.HotswapPicoContainer;
import com.sas.midtier.components.container.Lifecycle;
import com.sas.midtier.components.container.LifecycleException;
import com.sas.midtier.components.container.StorageContext;
import com.sas.midtier.components.container.impl.DefaultLifecycle;
import com.sas.midtier.components.container.impl.StorageContextImpl;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public class DefaultContainerManager
implements ContainerManager {
    private Lifecycle _lifecycle = new DefaultLifecycle();
    private StorageContext _context;
    private ContainerComposer _composer;

    public DefaultContainerManager(Object context, ContainerComposer composer) throws IllegalArgumentException {
        this._context = new StorageContextImpl(context);
        this._composer = composer;
    }

    public PicoContainer getContainer() {
        return (PicoContainer)this._context.getAttribute("sas.webapp.component.container");
    }

    public void initializeContainers(InputStream containerConfig, List keyCollector) throws IllegalArgumentException, ContainerCompositionException, LifecycleException {
        if (this._context.getAttribute("sas.webapp.component.container") != null) {
            throw new LifecycleException();
        }
        MutablePicoContainer container = this.setupContainers(this._context, containerConfig, keyCollector);
        HotswapPicoContainer hotswap = new HotswapPicoContainer();
        hotswap.setTarget(container);
        this._context.setAttribute("sas.webapp.component.container", (Object)hotswap);
    }

    public void initializeContainers(InputStream containerConfig) throws IllegalArgumentException, ContainerCompositionException, LifecycleException {
        this.initializeContainers(containerConfig, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitializeContainers(InputStream containerConfig, List keyCollector) throws IllegalArgumentException, ContainerCompositionException, LifecycleException {
        HotswapPicoContainer container = null;
        try {
            container = (HotswapPicoContainer)this._context.getAttribute("sas.webapp.component.container");
        }
        catch (ClassCastException e) {
            throw new LifecycleException((Throwable)e);
        }
        if (container == null) {
            throw new LifecycleException();
        }
        container.beginHotswap();
        try {
            MutablePicoContainer realContainer = container.getTarget();
            this._lifecycle.doShutdown(realContainer);
            MutablePicoContainer newContainer = this.setupContainers(this._context, containerConfig, keyCollector);
            container.setTarget(null);
            container.setTarget(newContainer);
        }
        finally {
            container.endHotswap();
        }
    }

    public void reinitializeContainers(InputStream containerConfig) throws IllegalArgumentException, ContainerCompositionException, LifecycleException {
        this.reinitializeContainers(containerConfig, null);
    }

    public void shutdownContainers() throws LifecycleException {
        MutablePicoContainer container = (MutablePicoContainer)this._context.getAttribute("sas.webapp.component.container");
        if (container == null) {
            throw new LifecycleException();
        }
        try {
            this._lifecycle.doShutdown(container);
        }
        finally {
            this._context.removeAttribute("sas.webapp.component.container");
        }
    }

    private MutablePicoContainer setupContainers(StorageContext context, InputStream containerConfig, List keyCollector) throws IllegalArgumentException, ContainerCompositionException, LifecycleException {
        MutablePicoContainer appContainer = null;
        appContainer = this.buildContainer(context, containerConfig, keyCollector);
        this._lifecycle.doStartup(appContainer);
        return appContainer;
    }

    private MutablePicoContainer buildContainer(StorageContext context, InputStream scriptStream, List keyCollector) throws ContainerCompositionException {
        InputStreamReader scriptReader = new InputStreamReader(scriptStream);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        MutablePicoContainer retval = this._composer.compose(context, (Reader)scriptReader, classLoader, keyCollector);
        return retval;
    }
}

