/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.jobexecution.client.impl;

import com.sas.prompts.PromptValuesInterface;
import com.sas.svcs.jobexecution.client.TaskInterface;
import com.sas.svcs.jobexecution.client.TaskType;
import com.sas.svcs.saslog.client.types.ReadSASLogListing;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Task
implements Cloneable,
Serializable,
TaskInterface {
    private static final Logger LOGGER = LogManager.getLogger(Task.class);
    private static final long serialVersionUID = 1L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private static final int DEFAULT_NUM_CONTROLS = 5;
    private static final int DEFAULT_NUM_INPUTS = 5;
    private static final int DEFAULT_NUM_KEYWORDS = 5;
    private String _name;
    private String _desc;
    private Set<String> _keywords = new HashSet<String>(5);
    private final TaskType _taskType;
    private Map<String, String[]> _controls = new HashMap<String, String[]>(5);
    private Map<String, String[]> _inputs = new HashMap<String, String[]>(5);
    private PromptValuesInterface _promptValues;
    private final Set<String> _outputParams = new HashSet<String>(5);
    private String _publicTaskID;
    private static final ReadSASLogListing DEFAULT_LOG_LISTING_REQUEST = new ReadSASLogListing();

    public Task(TaskType taskType, String name, String desc) {
        if (taskType == null) {
            throw new IllegalArgumentException("A task type must be specified.");
        }
        this._taskType = taskType;
        this.setName(name);
        this.setDescription(desc);
    }

    @Override
    public final String getDescription() {
        return this._desc;
    }

    @Override
    public final void setDescription(String description) {
        this._desc = description;
    }

    @Override
    public final String getName() {
        return this._name;
    }

    @Override
    public final void setName(String name) {
        if (name == null || 0 == name.trim().length()) {
            throw new IllegalArgumentException("A task name must be specified.");
        }
        this._name = name;
    }

    @Override
    public final Set<String> getKeywords() {
        return new HashSet<String>(this._keywords);
    }

    @Override
    public final void setKeywords(Set<String> keywords) {
        this._keywords.clear();
        if (keywords != null) {
            this._keywords.addAll(keywords);
        }
    }

    @Override
    public void addKeyword(String keyword) {
        this._keywords.add(keyword);
    }

    @Override
    public void removeKeyword(String keyword) {
        this._keywords.remove(keyword);
    }

    @Override
    public final TaskType getType() {
        return this._taskType;
    }

    @Override
    public String getServerContextName() {
        String serverContextName = null;
        for (Map.Entry<String, String[]> aControl : this._controls.entrySet()) {
            if (!"SERVERCONTEXTNAME".equals(aControl.getKey())) continue;
            if (aControl.getValue() == null) break;
            serverContextName = aControl.getValue()[0];
            break;
        }
        return serverContextName;
    }

    @Override
    public void setServerContextName(String serverContextName) {
        boolean isSet = false;
        for (Map.Entry<String, String[]> aControl : this._controls.entrySet()) {
            if (!"SERVERCONTEXTNAME".equals(aControl.getKey())) continue;
            aControl.setValue(new String[]{serverContextName});
            isSet = true;
            break;
        }
        if (!isSet) {
            this._controls.put("SERVERCONTEXTNAME", new String[]{serverContextName});
        }
    }

    @Override
    public boolean isRunAsClientIdentityOnServer() {
        boolean runAsClientIdentityOnServer = false;
        for (Map.Entry<String, String[]> aControl : this._controls.entrySet()) {
            if (!"RUNASCLIENTIDENTITYONSERVER".equals(aControl.getKey())) continue;
            if (aControl.getValue() == null) break;
            runAsClientIdentityOnServer = Boolean.parseBoolean(aControl.getValue()[0]);
            break;
        }
        return runAsClientIdentityOnServer;
    }

    @Override
    public Boolean isRunAsClientIdentity() {
        Boolean runAsClientIdentityOnServer = null;
        for (Map.Entry<String, String[]> aControl : this._controls.entrySet()) {
            if (!"RUNASCLIENTIDENTITYONSERVER".equals(aControl.getKey())) continue;
            if (aControl.getValue() == null) break;
            runAsClientIdentityOnServer = Boolean.valueOf(aControl.getValue()[0]);
            break;
        }
        return runAsClientIdentityOnServer;
    }

    @Override
    public void setRunAsClientIdentityOnServer(boolean runAsClientIdentityOnServer) {
        boolean isSet = false;
        for (Map.Entry<String, String[]> aControl : this._controls.entrySet()) {
            if (!"RUNASCLIENTIDENTITYONSERVER".equals(aControl.getKey())) continue;
            aControl.setValue(new String[]{String.valueOf(runAsClientIdentityOnServer)});
            isSet = true;
            break;
        }
        if (!isSet) {
            this._controls.put("RUNASCLIENTIDENTITYONSERVER", new String[]{String.valueOf(runAsClientIdentityOnServer)});
        }
    }

    @Override
    public boolean isPersistingResultPackage() {
        return this.getBooleanControl("PERSISTINGRESULTPACKAGE");
    }

    @Override
    public void setPersistingResultPackage(boolean persistingResultPackage) {
        this.setBooleanControl("PERSISTINGRESULTPACKAGE", persistingResultPackage);
    }

    @Override
    public ReadSASLogListing getReadSASLogListingFromServer() {
        ReadSASLogListing readLogListing = new ReadSASLogListing();
        readLogListing.setReadListing(this.isReadingSASListingFromServer());
        readLogListing.setReadLog(this.isReadingSASLogFromServer());
        return readLogListing;
    }

    @Override
    public void setReadSASLogListingFromServer(ReadSASLogListing readLogListing) {
        this.setControl("IS_READING_SAS_LOG", Boolean.toString(readLogListing.isReadLog()));
        this.setControl("IS_READING_SAS_LISTING", Boolean.toString(readLogListing.isReadListing()));
    }

    @Override
    public long getMaxQueuedTime() {
        long maxQueuedTime = 0L;
        for (Map.Entry<String, String[]> aControl : this._controls.entrySet()) {
            if (!"MAXQUEUEDTIME".equals(aControl.getKey())) continue;
            if (aControl.getValue() == null) break;
            try {
                String value = aControl.getValue()[0];
                if (null == value) break;
                maxQueuedTime = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Unable to parse a long value from task control property MAXQUEUEDTIME", (Throwable)e);
            }
            break;
        }
        return maxQueuedTime;
    }

    @Override
    public void setMaxQueuedTime(long maxQueuedTime) {
        if (maxQueuedTime < 0L) {
            throw new IllegalArgumentException("Invalid time duration was specified.");
        }
        boolean isSet = false;
        for (Map.Entry<String, String[]> aControl : this._controls.entrySet()) {
            if (!"MAXQUEUEDTIME".equals(aControl.getKey())) continue;
            aControl.setValue(new String[]{String.valueOf(maxQueuedTime)});
            isSet = true;
            break;
        }
        if (!isSet) {
            this._controls.put("MAXQUEUEDTIME", new String[]{String.valueOf(maxQueuedTime)});
        }
    }

    @Override
    public long getMaxExecutionTime() {
        long maxExecutionTime = 0L;
        for (Map.Entry<String, String[]> aControl : this._controls.entrySet()) {
            if (!"MAXEXECUTIONTIME".equals(aControl.getKey())) continue;
            if (aControl.getValue() == null) break;
            try {
                String value = aControl.getValue()[0];
                if (null == value) break;
                maxExecutionTime = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Unable to parse a long value from task control property MAXEXECUTIONTIME", (Throwable)e);
            }
            break;
        }
        return maxExecutionTime;
    }

    @Override
    public void setMaxExecutionTime(long maxExecutionTime) {
        if (maxExecutionTime < 0L) {
            throw new IllegalArgumentException("Invalid time duration was specified.");
        }
        boolean isSet = false;
        for (Map.Entry<String, String[]> aControl : this._controls.entrySet()) {
            if (!"MAXEXECUTIONTIME".equals(aControl.getKey())) continue;
            aControl.setValue(new String[]{String.valueOf(maxExecutionTime)});
            isSet = true;
            break;
        }
        if (!isSet) {
            this._controls.put("MAXEXECUTIONTIME", new String[]{String.valueOf(maxExecutionTime)});
        }
    }

    @Override
    public List<String> getResources() {
        String[] resourcesCopy = new String[]{};
        for (Map.Entry<String, String[]> aControl : this._controls.entrySet()) {
            if (!"RESOURCES".equals(aControl.getKey())) continue;
            String[] resources = aControl.getValue();
            resourcesCopy = new String[resources.length];
            System.arraycopy(resources, 0, resourcesCopy, 0, resources.length);
            break;
        }
        return Arrays.asList(resourcesCopy);
    }

    @Override
    public void setResources(List<String> resources) {
        String[] resourcesCopy = new String[resources.size()];
        System.arraycopy(resources.toArray(new String[resources.size()]), 0, resourcesCopy, 0, resources.size());
        boolean isSet = false;
        for (Map.Entry<String, String[]> aControl : this._controls.entrySet()) {
            if (!"RESOURCES".equals(aControl.getKey())) continue;
            aControl.setValue(resourcesCopy);
            isSet = true;
            break;
        }
        if (!isSet) {
            this._controls.put("RESOURCES", resourcesCopy);
        }
    }

    @Override
    public String getControlValue(String controlName) {
        String controlValue = null;
        List<String> controlValues = this.getControlValuesInternal(controlName);
        if (controlValues != null && !controlValues.isEmpty()) {
            controlValue = controlValues.get(0);
        }
        return controlValue;
    }

    @Override
    public List<String> getControlValues(String controlName) {
        return this.getControlValuesInternal(controlName);
    }

    private List<String> getControlValuesInternal(String controlName) {
        String[] controlValues = new String[]{};
        for (Map.Entry<String, String[]> aControl : this._controls.entrySet()) {
            if (!aControl.getKey().equals(controlName)) continue;
            controlValues = aControl.getValue();
            break;
        }
        return Arrays.asList(controlValues);
    }

    @Override
    public final Map<String, List<String>> getControls() {
        HashMap<String, List<String>> controls = new HashMap<String, List<String>>();
        for (Map.Entry<String, String[]> entry : this._controls.entrySet()) {
            List<String> values = Arrays.asList(entry.getValue());
            controls.put(entry.getKey(), values);
        }
        return controls;
    }

    @Override
    public void setControl(String controlName, String controlValue) {
        this.setControl(controlName, Arrays.asList(controlValue));
    }

    @Override
    public void setControl(String controlName, List<String> controlValues) {
        if (controlValues == null) {
            this._controls.remove(controlName);
        } else {
            String[] controlValuesCopy = new String[controlValues.size()];
            System.arraycopy(controlValues.toArray(new String[controlValues.size()]), 0, controlValuesCopy, 0, controlValues.size());
            boolean isSet = false;
            for (Map.Entry<String, String[]> aControl : this._controls.entrySet()) {
                if (!aControl.getKey().equals(controlName)) continue;
                aControl.setValue(controlValuesCopy);
                isSet = true;
                break;
            }
            if (!isSet) {
                this._controls.put(controlName, controlValuesCopy);
            }
        }
    }

    @Override
    public final void setControls(Map<String, List<String>> controls) {
        this._controls.clear();
        if (null != controls) {
            for (Map.Entry<String, List<String>> entry : controls.entrySet()) {
                this._controls.put(entry.getKey(), entry.getValue().toArray(new String[0]));
            }
        }
    }

    @Override
    public final String getParameterValue(String paramName) {
        String[] values = this._inputs.get(paramName);
        return values == null || values.length == 0 ? null : values[0];
    }

    @Override
    public final List<String> getParameterValues(String paramName) {
        String[] values = this._inputs.get(paramName);
        if (values == null) {
            values = new String[]{};
        }
        return Arrays.asList(values);
    }

    @Override
    public final Map<String, List<String>> getParameters() {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        for (Map.Entry<String, String[]> entry : this._inputs.entrySet()) {
            List<String> values = Arrays.asList(entry.getValue());
            parameters.put(entry.getKey(), values);
        }
        return parameters;
    }

    @Override
    public void setParameter(String paramName, String paramValue) {
        this.setParameter(paramName, Arrays.asList(paramValue));
    }

    @Override
    public void setParameter(String paramName, List<String> paramValues) {
        if (paramValues == null) {
            this._inputs.remove(paramName);
        } else {
            String[] paramValuesCopy = new String[paramValues.size()];
            System.arraycopy(paramValues.toArray(new String[paramValues.size()]), 0, paramValuesCopy, 0, paramValues.size());
            boolean isSet = false;
            for (Map.Entry<String, String[]> aParam : this._inputs.entrySet()) {
                if (!aParam.getKey().equals(paramName)) continue;
                aParam.setValue(paramValuesCopy);
                isSet = true;
                break;
            }
            if (!isSet) {
                this._inputs.put(paramName, paramValuesCopy);
            }
        }
    }

    @Override
    public final void setParameters(Map<String, List<String>> parameters) {
        this._inputs.clear();
        if (null != parameters) {
            for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
                this._inputs.put(entry.getKey(), entry.getValue().toArray(new String[0]));
            }
        }
    }

    @Override
    public Set<String> getOutputParameters() {
        return new HashSet<String>(this._outputParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addOutputParameter(String outputParamerName) {
        boolean wasAdded = false;
        Set<String> set = this._outputParams;
        synchronized (set) {
            if (!this._outputParams.contains(outputParamerName)) {
                wasAdded = this._outputParams.add(outputParamerName);
            }
        }
        return wasAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeOutputParameter(String outputParameterName) {
        boolean wasRemoved = false;
        Set<String> set = this._outputParams;
        synchronized (set) {
            wasRemoved = this._outputParams.remove(outputParameterName);
        }
        return wasRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOutputParameters(Set<String> outputParamerNames) {
        Set<String> set = this._outputParams;
        synchronized (set) {
            this._outputParams.clear();
            if (outputParamerNames != null) {
                this._outputParams.addAll(outputParamerNames);
            }
        }
    }

    @Override
    public PromptValuesInterface getPromptValues() {
        return this._promptValues;
    }

    @Override
    public void setPromptValues(PromptValuesInterface promptValues) {
        this._promptValues = promptValues;
    }

    public Object clone() throws CloneNotSupportedException {
        String[] valuesCopy;
        int length;
        String[] values;
        Task task = (Task)super.clone();
        task._inputs = new HashMap<String, String[]>(this._inputs.size());
        HashMap<String, String[]> inputs = new HashMap<String, String[]>(this._inputs);
        for (Map.Entry entry : inputs.entrySet()) {
            values = (String[])entry.getValue();
            length = values.length;
            valuesCopy = new String[length];
            System.arraycopy(values, 0, valuesCopy, 0, length);
            task.setParameter((String)entry.getKey(), Arrays.asList(valuesCopy));
        }
        task._keywords = new HashSet<String>(this._keywords.size());
        task._keywords.addAll(this.getKeywords());
        task._controls = new HashMap<String, String[]>(this._controls.size());
        Map<String, String[]> controls = this._controls;
        for (Map.Entry<String, String[]> entry : controls.entrySet()) {
            values = entry.getValue();
            length = values.length;
            valuesCopy = new String[length];
            System.arraycopy(values, 0, valuesCopy, 0, length);
            task.setControl(entry.getKey(), Arrays.asList(valuesCopy));
        }
        return task;
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (object != null) {
            if (object == this) {
                isEqual = true;
            } else if (object instanceof Task) {
                Task other = (Task)object;
                boolean bl = isEqual = Strings.equal((String)this._name, (String)other.getName(), (boolean)false, (boolean)false) && Strings.equal((String)this._desc, (String)other.getDescription(), (boolean)false, (boolean)false) && Strings.equal((String)this._publicTaskID, (String)other.getPublicName(), (boolean)false, (boolean)false) && this._taskType.equals((Object)other.getType()) && this._outputParams.equals(other._outputParams) && this._keywords.equals(other._keywords);
                if (isEqual && (isEqual = this.equalMaps(this._inputs, other._inputs))) {
                    isEqual = this.equalMaps(this._controls, other._controls);
                }
                if (isEqual) {
                    if (null == this._promptValues && null != other._promptValues) {
                        isEqual = false;
                    } else if (null != this._promptValues && null == other._promptValues) {
                        isEqual = false;
                    } else if (null != this._promptValues) {
                        isEqual = this._promptValues.equals((Object)other._promptValues);
                    }
                }
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int primeNumber = 17;
        int hashCode = 17;
        hashCode ^= this._name.hashCode();
        if (null != this._desc) {
            hashCode ^= this._desc.hashCode();
        }
        if (null != this._publicTaskID) {
            hashCode ^= this._publicTaskID.hashCode();
        }
        hashCode ^= this._taskType.hashCode();
        hashCode ^= this._inputs.hashCode();
        hashCode ^= this._controls.hashCode();
        hashCode ^= this._outputParams.hashCode();
        hashCode ^= this._keywords.hashCode();
        if (null != this._promptValues) {
            hashCode ^= this._promptValues.hashCode();
        }
        return hashCode;
    }

    public final String getPublicName() {
        return this._publicTaskID;
    }

    public final void setPublicName(String publicTaskID) {
        this._publicTaskID = publicTaskID;
    }

    @Override
    public boolean isPersistingConnection() {
        return this.getBooleanControl("PERSISTINGCONNECTION");
    }

    @Override
    public void setPersistingConnection(boolean persistingConnection) {
        this.setBooleanControl("PERSISTINGCONNECTION", persistingConnection);
    }

    private boolean isReadingSASLogFromServer() {
        Boolean value = this.getValueOfBooleanControl("IS_READING_SAS_LOG");
        return null == value ? DEFAULT_LOG_LISTING_REQUEST.isReadLog() : value.booleanValue();
    }

    private boolean isReadingSASListingFromServer() {
        Boolean value = this.getValueOfBooleanControl("IS_READING_SAS_LISTING");
        return null == value ? DEFAULT_LOG_LISTING_REQUEST.isReadListing() : value.booleanValue();
    }

    private Boolean getValueOfBooleanControl(String controlName) {
        Boolean value = null;
        String[] values = this._controls.get(controlName);
        if (null != values && values.length > 0) {
            value = Boolean.valueOf(values[0]);
        }
        return value;
    }

    private boolean equalMaps(Map<String, String[]> map1, Map<String, String[]> map2) {
        if (map1 == map2) {
            return true;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        if (map1.isEmpty()) {
            return true;
        }
        boolean isEqual = false;
        for (Map.Entry<String, String[]> entry : map1.entrySet()) {
            isEqual = false;
            isEqual = Arrays.equals(entry.getValue(), map2.get(entry.getKey()));
            if (isEqual) continue;
            break;
        }
        return isEqual;
    }

    private boolean getBooleanControl(String controlName) {
        boolean value = false;
        for (Map.Entry<String, String[]> aControl : this._controls.entrySet()) {
            if (!controlName.equals(aControl.getKey())) continue;
            if (aControl.getValue() == null) break;
            value = Boolean.parseBoolean(aControl.getValue()[0]);
            break;
        }
        return value;
    }

    private void setBooleanControl(String controlName, boolean value) {
        boolean isSet = false;
        for (Map.Entry<String, String[]> aControl : this._controls.entrySet()) {
            if (!controlName.equals(aControl.getKey())) continue;
            aControl.setValue(new String[]{String.valueOf(value)});
            isSet = true;
            break;
        }
        if (!isSet) {
            this._controls.put(controlName, new String[]{String.valueOf(value)});
        }
    }

    static {
        DEFAULT_LOG_LISTING_REQUEST.setReadListing(true);
        DEFAULT_LOG_LISTING_REQUEST.setReadLog(true);
    }
}

