/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.jobexecution.client.impl;

import com.sas.svcs.jobexecution.client.SASTaskInterface;
import com.sas.svcs.jobexecution.client.TaskType;
import com.sas.svcs.jobexecution.client.impl.Task;
import com.sas.svcs.jobexecution.client.impl.i18n.RB;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SASTask
extends Task
implements Cloneable,
SASTaskInterface {
    private static final long serialVersionUID = 1L;
    private final List<String> _sasCode = new ArrayList<String>();

    public SASTask() {
        this(RB.getStringResource("SASTask.defaultName.txt"), null);
    }

    public SASTask(String name, String desc) {
        super(TaskType.SAS_CODE, name, desc);
    }

    @Override
    public List<String> getSASCode() {
        return new ArrayList<String>(this._sasCode);
    }

    @Override
    public void setSASCode(String sasCode, String lineSeparatorRegex) {
        this.setSASCode(null == sasCode ? new ArrayList(0) : Arrays.asList(sasCode.split(lineSeparatorRegex)));
    }

    @Override
    public void setSASCode(List<String> sasCode) {
        if (null == sasCode || sasCode.isEmpty()) {
            throw new IllegalArgumentException("SAS code must be specified for a SAS task.");
        }
        this._sasCode.clear();
        this._sasCode.addAll(sasCode);
    }

    @Override
    public boolean equals(Object object) {
        boolean isEqual;
        boolean bl = isEqual = this == object;
        if (!isEqual && (isEqual = super.equals(object))) {
            isEqual = false;
            if (object instanceof SASTaskInterface) {
                SASTaskInterface other = (SASTaskInterface)object;
                isEqual = this.getSASCode().equals(other.getSASCode());
            }
        }
        return isEqual;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this._sasCode.hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

