/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.jobexecution.client;

import com.sas.svcs.saslog.client.types.SASLogSummary;
import com.sas.svcs.workspace.common.client.SASOutputVariables;
import com.sas.util.Strings;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class TaskResults
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @Deprecated
    public static final String SAS_SYSCC = "SYSCC";
    @Deprecated
    public static final String SAS_SYSERR = "SYSERR";
    @Deprecated
    public static final String SAS_SYSMSG = "SYSMSG";
    @Deprecated
    public static final String SAS_SYSRC = "SYSRC";
    @Deprecated
    public static final String SAS_SYSDATE9 = "SYSDATE9";
    @Deprecated
    public static final String SAS_SYSTIME = "SYSTIME";
    @Deprecated
    public static final String SAS_SYSDSN = "SYSDSN";
    @Deprecated
    public static final String SAS_SYSLAST = "SYSLAST";
    @Deprecated
    public static final String SAS_SYSVER = "SYSVER";
    @Deprecated
    public static final String SAS_SYSVLONG = "SYSVLONG";
    public static final String EXEC_SERVERCONTEXT_NAME = "sas.servercontext.name";
    public static final String EXEC_LOGICALSERVER_NAME = "sas.logicalserver.name";
    public static final String DROPBOX_KEY_NAME = "sas.dropbox.key";
    public static final String CONNECTION_DROPBOX_KEY_NAME = "sas.connection.dropbox.key";
    private String _taskID;
    private String _taskName;
    private Map<String, String> _outputs = new HashMap<String, String>();
    private SASLogSummary _sasLogSummary;

    public TaskResults(String taskID, String taskName) {
        if (taskID == null) {
            throw new IllegalArgumentException("A task ID must be specified.");
        }
        if (taskName == null) {
            throw new IllegalArgumentException("A task name must be specified.");
        }
        this.setTaskID(taskID);
        this.setTaskName(taskName);
    }

    public String getTaskID() {
        return this._taskID;
    }

    public void setTaskID(String taskID) {
        this._taskID = taskID;
    }

    public String getTaskName() {
        return this._taskName;
    }

    public void setTaskName(String taskName) {
        this._taskName = taskName;
    }

    public Map<String, String> getOutputParameters() {
        return new HashMap<String, String>(this._outputs);
    }

    public void setOutputParameters(Map<String, String> outputParameters) {
        this._outputs.clear();
        if (null != outputParameters) {
            this._outputs.putAll(outputParameters);
        }
    }

    public void setOutputParameter(String paramName, String paramValue) {
        if (paramName != null) {
            if (paramValue == null) {
                this._outputs.remove(paramName);
            } else {
                this._outputs.put(paramName, paramValue);
            }
        }
    }

    public static Set<String> getStandardOutputParameters() {
        return new HashSet<String>(SASOutputVariables.SAS_STANDARD_OUTPUT_VARS);
    }

    public SASLogSummary getSASLogSummary() {
        return this._sasLogSummary;
    }

    public void setSASLogSummary(SASLogSummary saslog) {
        this._sasLogSummary = saslog;
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (object != null) {
            if (object == this) {
                isEqual = true;
            } else {
                try {
                    TaskResults other = (TaskResults)object;
                    boolean bl = isEqual = Strings.equal((String)this._taskID, (String)other.getTaskID(), (boolean)false, (boolean)false) && Strings.equal((String)this._taskName, (String)other.getTaskName(), (boolean)false, (boolean)false) && this._outputs.equals(other._outputs);
                    if (isEqual) {
                        isEqual = this._sasLogSummary == null ? other._sasLogSummary == null : this._sasLogSummary.equals((Object)other._sasLogSummary);
                    }
                }
                catch (ClassCastException e) {
                    isEqual = false;
                }
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int primeNumber = 17;
        int hashCode = 17;
        hashCode ^= this._taskID.hashCode();
        hashCode ^= this._taskName.hashCode();
        hashCode ^= this._outputs.hashCode();
        if (this._sasLogSummary != null) {
            hashCode ^= this._sasLogSummary.hashCode();
        }
        return hashCode;
    }

    public Object clone() throws CloneNotSupportedException {
        TaskResults taskResults = (TaskResults)super.clone();
        taskResults._outputs = new HashMap<String, String>(taskResults._outputs.size());
        for (Map.Entry<String, String> outputEntry : this._outputs.entrySet()) {
            taskResults.setOutputParameter(outputEntry.getKey(), outputEntry.getValue());
        }
        return taskResults;
    }
}

