/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.jobexecution.client;

import com.sas.svcs.jobexecution.client.JobException;
import com.sas.svcs.jobexecution.client.JobExecutionException;
import com.sas.svcs.jobexecution.client.JobExecutionServiceInterface;
import com.sas.svcs.jobexecution.client.JobStatus;
import com.sas.svcs.jobexecution.client.TaskStatus;
import java.util.concurrent.TimeUnit;

public class JobStatusPoller {
    private static final long DEFAULT_POLL_INTERVAL_MSEC = TimeUnit.SECONDS.toMillis(30L);
    private JobExecutionServiceInterface _jobExecutionService;
    private final String _jobID;
    private JobStatus _jobStatus;
    private long _pollIntervalMsec = DEFAULT_POLL_INTERVAL_MSEC;
    private boolean _isStopped;

    public JobStatusPoller(JobExecutionServiceInterface jobExecutionService, String jobID) {
        if (jobID == null) {
            throw new IllegalArgumentException("A job ID must be specified.");
        }
        this._jobID = jobID;
        this.setJobExecutionService(jobExecutionService);
    }

    private void setJobExecutionService(JobExecutionServiceInterface jobExecutionService) {
        this._jobExecutionService = jobExecutionService;
    }

    public void setPollInterval(long pollIntervalMsec) {
        if (pollIntervalMsec < 1L) {
            throw new IllegalArgumentException("The polling interval must be greater than 0 milliseconds.");
        }
        this._pollIntervalMsec = pollIntervalMsec;
    }

    public JobStatus waitForJobToComplete() throws JobException {
        JobExecutionException exception = null;
        while (!this._isStopped) {
            try {
                Thread.sleep(this._pollIntervalMsec);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this._jobStatus = this._jobExecutionService.getJobStatus(this._jobID);
            }
            catch (JobExecutionException e) {
                exception = e;
            }
            finally {
                if (exception == null && !this.hasJobCompleted()) continue;
                this.stop();
            }
        }
        if (exception != null) {
            throw exception;
        }
        return this._jobStatus;
    }

    public void stop() {
        this._isStopped = true;
    }

    public JobStatus getJobStatus() {
        return this._jobStatus;
    }

    private boolean hasJobCompleted() {
        boolean hasCompleted;
        boolean bl = hasCompleted = this._jobStatus != null && this._jobStatus.isCompleted();
        if (hasCompleted) {
            for (TaskStatus taskStatus : this._jobStatus.getTaskStatus()) {
                if (taskStatus.isCompleted()) continue;
                hasCompleted = false;
                break;
            }
        }
        return hasCompleted;
    }
}

