/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.jobexecution.client;

import com.sas.svcs.jobexecution.client.ExecutionState;
import com.sas.svcs.jobexecution.client.ExecutionStatus;
import com.sas.svcs.jobexecution.client.TaskStatus;
import java.util.ArrayList;
import java.util.List;

public class JobStatus
extends ExecutionStatus {
    private static final long serialVersionUID = 1L;
    private List<TaskStatus> _taskStatus;

    public JobStatus(String jobID, String jobName, List<TaskStatus> taskStatus) {
        this(jobID, jobName, taskStatus, ExecutionState.SUBMITTED);
    }

    public JobStatus(String jobID, String jobName, List<TaskStatus> taskStatus, ExecutionState executionState) {
        super(jobID, jobName, executionState);
        this.setTaskStatus(new ArrayList<TaskStatus>(taskStatus));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaskStatus> getTaskStatus() {
        ArrayList<TaskStatus> taskStatus = null;
        List<TaskStatus> list = this._taskStatus;
        synchronized (list) {
            taskStatus = new ArrayList<TaskStatus>(this._taskStatus);
        }
        return taskStatus;
    }

    public final void setTaskStatus(List<TaskStatus> taskStatus) {
        this._taskStatus = taskStatus;
    }

    public TaskStatus getStatusForTask(String taskName) {
        TaskStatus taskStatus = null;
        for (TaskStatus aTaskStatus : this.getTaskStatus()) {
            if (!aTaskStatus.getName().equals(taskName)) continue;
            taskStatus = aTaskStatus;
            break;
        }
        return taskStatus;
    }

    public List<TaskStatus> getTaskStatusForExecutionState(ExecutionState executionState) {
        ArrayList<TaskStatus> matchingTaskStatus = new ArrayList<TaskStatus>(0);
        for (TaskStatus aTaskStatus : this.getTaskStatus()) {
            if (!aTaskStatus.getExecutionState().equals((Object)executionState)) continue;
            matchingTaskStatus.add(aTaskStatus);
        }
        return matchingTaskStatus;
    }

    @Override
    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        int numTasks = null == this._taskStatus ? 0 : this._taskStatus.size();
        int numCharsPerTask = 256;
        int numCharsExtra = 256;
        int stringLength = 256 + numTasks * 256;
        StringBuilder stringBuilder = new StringBuilder(stringLength).append(super.toString());
        if (null != this._taskStatus) {
            for (TaskStatus taskStatus : this._taskStatus) {
                stringBuilder.append(lineSeparator).append(taskStatus.toString());
            }
        }
        return stringBuilder.toString();
    }
}

