/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.jobexecution.client;

import com.sas.svcs.jobexecution.client.TaskResults;
import com.sas.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class JobResults
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String _jobID;
    private String _jobName;
    private List<TaskResults> _taskResults;

    public JobResults(String jobID, String jobName, List<TaskResults> taskResults) {
        if (jobID == null) {
            throw new IllegalArgumentException("A job ID must be specified.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("A job name must be specified.");
        }
        if (taskResults == null) {
            throw new IllegalArgumentException("Task results must be specified.");
        }
        this.setJobID(jobID);
        this.setJobName(jobName);
        this.setTaskResults(taskResults);
    }

    public String getJobID() {
        return this._jobID;
    }

    public final void setJobID(String id) {
        this._jobID = id;
    }

    public String getJobName() {
        return this._jobName;
    }

    public final void setJobName(String name) {
        this._jobName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaskResults> getTaskResults() {
        ArrayList<TaskResults> taskResults = null;
        List<TaskResults> list = this._taskResults;
        synchronized (list) {
            taskResults = new ArrayList<TaskResults>(this._taskResults);
        }
        return taskResults;
    }

    public final void setTaskResults(List<TaskResults> taskResults) {
        this._taskResults = taskResults;
    }

    public TaskResults getResultsForTask(String taskName) {
        TaskResults taskResults = null;
        for (TaskResults aTaskResults : this.getTaskResults()) {
            if (!aTaskResults.getTaskName().equals(taskName)) continue;
            taskResults = aTaskResults;
            break;
        }
        return taskResults;
    }

    public Object clone() throws CloneNotSupportedException {
        JobResults jobResults = (JobResults)super.clone();
        jobResults._taskResults = new ArrayList<TaskResults>(jobResults._taskResults);
        for (int i = 0; i < jobResults._taskResults.size(); ++i) {
            jobResults._taskResults.set(i, (TaskResults)jobResults._taskResults.get(i).clone());
        }
        return jobResults;
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (object != null) {
            if (object == this) {
                isEqual = true;
            } else {
                try {
                    JobResults other = (JobResults)object;
                    boolean bl = isEqual = Strings.equal((String)this._jobID, (String)other.getJobID(), (boolean)false, (boolean)false) && Strings.equal((String)this._jobName, (String)other.getJobName(), (boolean)false, (boolean)false) && this._taskResults.size() == other.getTaskResults().size();
                    if (isEqual) {
                        for (int i = 0; i < this._taskResults.size() && (isEqual = this._taskResults.get(i).equals(other.getTaskResults().get(i))); ++i) {
                        }
                    }
                }
                catch (ClassCastException e) {
                    isEqual = false;
                }
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int primeNumber = 17;
        int hashCode = 17;
        if (null != this._jobID) {
            hashCode ^= this._jobID.hashCode();
        }
        if (null != this._jobName) {
            hashCode ^= this._jobName.hashCode();
        }
        if (null != this._taskResults) {
            hashCode ^= this._taskResults.hashCode();
        }
        return hashCode;
    }
}

