/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.jobexecution.client;

import com.sas.svcs.jobexecution.client.ExecutionState;
import java.io.Serializable;
import java.util.Date;

public class ExecutionStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _id;
    private String _name;
    private ExecutionState _executionState;
    private Date _submittedTime;
    private Date _queuedTime;
    private Date _startedTime;
    private Date _completedTime;
    private boolean _isRestarted;
    private int _completedExecutions;

    public ExecutionStatus(String id, String name, ExecutionState executionState) {
        this.setID(id);
        this.setName(name);
        this.setExecutionState(executionState);
    }

    public String getID() {
        return this._id;
    }

    public final void setID(String id) {
        if (id == null || id.trim().length() == 0) {
            throw new IllegalArgumentException("An ID must be specified.");
        }
        this._id = id;
    }

    public final String getName() {
        return this._name;
    }

    public final void setName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("A name must be specified.");
        }
        this._name = name;
    }

    public ExecutionState getExecutionState() {
        return this._executionState;
    }

    public boolean isSubmitted() {
        return ExecutionState.SUBMITTED.equals((Object)this._executionState);
    }

    public boolean isQueued() {
        return ExecutionState.QUEUED.equals((Object)this._executionState);
    }

    public boolean isRunning() {
        return ExecutionState.RUNNING.equals((Object)this._executionState);
    }

    public boolean isCompleted() {
        return ExecutionState.COMPLETED.equals((Object)this._executionState);
    }

    public void setRestarted(boolean isRestarted) {
        this._isRestarted = isRestarted;
    }

    public boolean isRestarted() {
        return this._isRestarted;
    }

    public final void setExecutionState(ExecutionState executionState) {
        if (executionState == null) {
            throw new IllegalArgumentException("An execution state must be specified.");
        }
        this._executionState = executionState;
    }

    public Date getSubmittedTime() {
        return this._submittedTime;
    }

    public final void setSubmittedTime(Date submittedTime) {
        this._submittedTime = submittedTime;
    }

    public Date getQueuedTime() {
        return this._queuedTime;
    }

    public final void setQueuedTime(Date queuedTime) {
        this._queuedTime = queuedTime;
    }

    public Date getStartedTime() {
        return this._startedTime;
    }

    public final void setStartedTime(Date startedTime) {
        this._startedTime = startedTime;
    }

    public Date getCompletedTime() {
        return this._completedTime;
    }

    public final void setCompletedTime(Date completedTime) {
        this._completedTime = completedTime;
    }

    public int getCompletedExecutions() {
        return this._completedExecutions;
    }

    public final void setCompletedExecutions(int completedExecutions) {
        this._completedExecutions = completedExecutions;
    }

    public final void incrementCompletedExecutions() {
        ++this._completedExecutions;
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(super.toString());
        stringBuilder.append("[ID=");
        stringBuilder.append(this._id);
        stringBuilder.append("][name=");
        stringBuilder.append(this._name);
        stringBuilder.append("][completedExecutions=");
        stringBuilder.append(this._completedExecutions);
        stringBuilder.append("][executionState=");
        stringBuilder.append((Object)this._executionState);
        stringBuilder.append("][isRestarted=");
        stringBuilder.append(this._isRestarted);
        stringBuilder.append(']');
        stringBuilder.append(lineSeparator);
        stringBuilder.append("[submittedTime=");
        stringBuilder.append(this._submittedTime);
        stringBuilder.append(']');
        stringBuilder.append(lineSeparator);
        stringBuilder.append("[   queuedTime=");
        stringBuilder.append(this._queuedTime);
        stringBuilder.append(']');
        stringBuilder.append(lineSeparator);
        stringBuilder.append("[  startedTime=");
        stringBuilder.append(this._startedTime);
        stringBuilder.append(']');
        stringBuilder.append(lineSeparator);
        stringBuilder.append("[completedTime=");
        stringBuilder.append(this._completedTime);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

