/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.Util;
import java.io.IOException;
import java.io.InputStream;

class SDSPreSizedInputStream
extends InputStream {
    private final InputStream m_in;
    private final boolean m_mustConsume;
    private long m_size;

    public SDSPreSizedInputStream(InputStream in, long size, boolean mustConsume) {
        if (in == null) {
            throw Util.illegalNull("in");
        }
        if (size < 0L) {
            throw Util.illegalArgument("size", new Long(size));
        }
        this.m_in = in;
        this.m_size = size;
        this.m_mustConsume = mustConsume;
    }

    @Override
    public int read() throws IOException {
        if (this.m_size == 0L) {
            return -1;
        }
        --this.m_size;
        return this.m_in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.m_size <= 0L) {
            return -1;
        }
        if (this.m_size < (long)len) {
            len = (int)this.m_size;
        }
        len = this.m_in.read(b, off, len);
        this.m_size -= (long)len;
        return len;
    }

    @Override
    public void close() {
        if (!this.m_mustConsume || this.m_size <= 0L) {
            return;
        }
        byte[] buffer = new byte[8192];
        try {
            while (this.m_size > 0L && this.read(buffer, 0, buffer.length) >= 0) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

