/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.app;

import com.sas.graphics.app.RB;
import com.sas.graphics.applets.statgraph.DataParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.StatGraphPanel;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisPlot;
import com.sas.graphics.applets.statgraph.sgchart.mapProvider.AbstractMapProvider;
import com.sas.graphics.applets.statgraph.sgchart.ui.ImageMap;
import com.sas.graphics.util.BMPWriter;
import com.sas.graphics.util.attrmap.RangeAttributeMap;
import com.sas.graphics.vgf.VGFGraphics2D;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.text.Message;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;

public class StatGraphSSR {
    public static final String RB_KEY = "StatGraphSSR.";
    public static final byte BMP = 1;
    public static final byte PNG = 2;
    public static final byte VGF = 3;
    private String xmlFile = null;
    private String xmlDataFile = null;
    private String outFile = null;
    private String mapFile = null;
    private Dimension size = new Dimension(640, 480);
    private int dpi = -1;
    private int maxobs = 0;
    private byte type = 1;
    private boolean timing = false;
    private boolean birdRenderer = false;
    StatGraphPanel panel = null;
    private int numPages = -1;
    private static BufferedImage bi = null;
    private static int maxCachedImageSize = 480000;
    private static int imageSizeThreshold = 6786025;
    private String backupStyleName = null;
    private File imageFile = null;
    private FileOutputStream imageOutStream = null;
    private BufferedOutputStream imageBOS = null;
    private File imagemapFile = null;
    private FileOutputStream mapOutStream = null;
    private PrintStream mapPrintStream = null;

    public StatGraphSSR() {
    }

    public String getXmlDataFile() {
        return this.xmlDataFile;
    }

    public void setXmlDataFile(String file) {
        this.xmlDataFile = file;
    }

    public String getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(String file) {
        this.xmlFile = file;
    }

    public String getOutFile() {
        return this.outFile;
    }

    public void setOutFile(String fileName) {
        this.outFile = fileName;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public int getMaxObs() {
        return this.maxobs;
    }

    public void setMaxObs(int obs) {
        this.maxobs = obs;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public String getMapFile() {
        return this.mapFile;
    }

    public void setMapFile(String fileName) {
        this.mapFile = fileName;
    }

    public boolean getTiming() {
        return this.timing;
    }

    public void setTiming(boolean timing) {
        this.timing = timing;
    }

    public int getDPI() {
        return this.dpi;
    }

    public void setDPI(int aInt) {
        this.dpi = aInt;
    }

    public String getBackupStyleName() {
        return this.backupStyleName;
    }

    public void setBackupStyleName(String styleName) {
        this.backupStyleName = styleName;
    }

    private double getScale() {
        double mx = 1.0;
        if (this.dpi > 0) {
            mx = (double)this.dpi / 100.0;
        }
        return mx;
    }

    private boolean isScaled() {
        return this.dpi > 0;
    }

    private int getScaledWidth() {
        return (int)((double)this.size.width * this.getScale() + 0.5);
    }

    private int getScaledHeight() {
        return (int)((double)this.size.height * this.getScale() + 0.5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render() {
        boolean bl = this.panel.graph.imagemapEnabled = this.getMapFile() != null;
        if (this.backupStyleName != null) {
            this.panel.backupStyle = this.backupStyleName;
        }
        if (this.type == 3) {
            StatGraph cfr_ignored_0 = this.panel.graph;
            StatGraph.VGF = true;
            this.saveToVGF();
            return;
        }
        StatGraph cfr_ignored_1 = this.panel.graph;
        StatGraph.VGF = false;
        String xmlEncoding = null;
        Graphics2D g = null;
        this.numPages = -1;
        if (this.getTiming()) {
            StatGraphPanel.dumpTiming = true;
            StatGraphPanel.dumpTimeStamp((String)"Begin client:RENDER");
        }
        RepaintManager repaintM = RepaintManager.currentManager((JComponent)this.panel);
        boolean doubleBufferingEnabled = repaintM.isDoubleBufferingEnabled();
        repaintM.setDoubleBufferingEnabled(false);
        try {
            Graphics2D g2d;
            Document doc;
            if (StatGraphPanel.dumpTiming) {
                StatGraphPanel.dumpTimeStamp((String)"Begin client:process graph_spec");
            }
            if (this.xmlDataFile != null) {
                this.parseData();
            }
            if ((doc = this.parseXML()) == null) {
                System.out.println("Problem reading XML");
            } else {
                xmlEncoding = doc.getXmlEncoding();
            }
            StatGraph cfr_ignored_2 = this.panel.graph;
            StatGraph.xmlEncoding = xmlEncoding;
            StatGraph cfr_ignored_3 = this.panel.graph;
            StatGraph.sessionLocale = StatGraph.getSessionLocale((Document)doc);
            StatGraph.setSessionLocale();
            if (StatGraphPanel.dumpTiming) {
                StatGraphPanel.dumpTimeStamp((String)"End client:process graph_spec");
                StatGraphPanel.dumpTimeStamp((String)"Begin client:build graph");
            }
            this.panel.addNotify();
            this.panel.setSize(this.size);
            this.panel.load(doc);
            if (this.type == 1) {
                this.panel.graph.setTransparentBackground(false);
            }
            this.numPages = this.panel.graph.getNumPages();
            boolean plot3D = this.is3DPlot(doc);
            doc = null;
            this.panel.invalidate();
            this.panel.validate();
            if (StatGraph.textWrapped) {
                if (this.panel.getComponent(0) instanceof TrellisPlot) {
                    this.panel.getComponent(0).invalidate();
                }
                this.panel.invalidate();
                this.panel.validate();
            }
            if (StatGraphPanel.dumpTiming) {
                StatGraphPanel.dumpTimeStamp((String)"End client:build graph");
                StatGraphPanel.dumpTimeStamp((String)"Begin client:create bufferedImage");
            }
            int sw = this.getScaledWidth();
            int sh = this.getScaledHeight();
            int size = sw * sh;
            if (plot3D) {
                size *= 5;
            }
            if (size < 0 || size > imageSizeThreshold) {
                Message msg = plot3D ? new Message(RB.getStringResource(RB_KEY, "3dmemory.fmt.txt")) : new Message(RB.getStringResource(RB_KEY, "memory.fmt.txt"));
                StatGraph.printWarning((String)msg.toString((Object)Integer.toString(sw), (Object)Integer.toString(sh)), (boolean)false);
            }
            if (bi != null) {
                if (bi.getWidth() != sw || bi.getHeight() != sh) {
                    bi = new BufferedImage(sw, sh, 2);
                }
            } else {
                bi = new BufferedImage(sw, sh, 2);
            }
            g = bi.createGraphics();
            if (StatGraphPanel.dumpTiming) {
                StatGraphPanel.dumpTimeStamp((String)"End client:create bufferedImage");
                StatGraphPanel.dumpTimeStamp((String)"Begin client:paint graph");
            }
            if (this.isScaled()) {
                g2d = g;
                AffineTransform oldXfm = g2d.getTransform();
                AffineTransform xfm = new AffineTransform(oldXfm);
                xfm.scale(this.getScale(), this.getScale());
                g2d.setTransform(xfm);
            }
            if (this.panel.graph.isTransparentBackground()) {
                g2d = g;
                Composite saved = g2d.getComposite();
                g2d.setComposite(AlphaComposite.getInstance(1, 0.0f));
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, sw, sh);
                g2d.fill(rect);
                g2d.setComposite(saved);
            }
            this.panel.paint((Graphics)g);
            g.dispose();
            if (this.getMapFile() == null) {
                this.panel = null;
            }
            if (StatGraphPanel.dumpTiming) {
                StatGraphPanel.dumpTimeStamp((String)"End client:paint graph");
                StatGraphPanel.dumpTimeStamp((String)"Begin client:encode image");
            }
            if (this.outFile.length() == 0) {
                if (StatGraphPanel.dumpTiming) {
                    StatGraphPanel.dumpTimeStamp((String)"End client:encode image");
                    StatGraphPanel.dumpTimeStamp((String)"End client:RENDER");
                }
                StatGraph.setSystemLocale();
                repaintM.setDoubleBufferingEnabled(doubleBufferingEnabled);
                return;
            }
            this.imageFile = new File(this.outFile);
            this.imageOutStream = new FileOutputStream(this.imageFile);
            this.imageBOS = new BufferedOutputStream(this.imageOutStream);
            if (this.type == 1) {
                BMPWriter bmpWriter = new BMPWriter();
                bmpWriter.saveBitmap(this.imageBOS, (Image)bi, sw, sh);
            } else if (this.type == 2) {
                this.saveToPNG();
            }
            if (sw * sh > maxCachedImageSize) {
                bi = null;
            }
            if (StatGraphPanel.dumpTiming) {
                StatGraphPanel.dumpTimeStamp((String)"End client:encode image");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.toString());
        }
        finally {
            ArrayList maps;
            if (this.getMapFile() != null && this.panel.graph.isImagemapEnabled() && (maps = this.panel.getImageMap()).size() > 0) {
                this.imagemapFile = new File(this.mapFile);
                try {
                    this.mapOutStream = new FileOutputStream(this.imagemapFile);
                    this.mapPrintStream = xmlEncoding == null ? new PrintStream(this.mapOutStream, false) : new PrintStream((OutputStream)this.mapOutStream, false, xmlEncoding);
                    this.writeImageMap(maps, this.mapPrintStream, this.getScaledWidth(), this.getScaledHeight(), this.panel.graph.getDrillTarget());
                    this.mapPrintStream.flush();
                    this.mapPrintStream.close();
                    this.mapOutStream.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            if (this.imageOutStream != null) {
                try {
                    this.imageBOS.close();
                    this.imageOutStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (StatGraphPanel.dumpTiming) {
            StatGraphPanel.dumpTimeStamp((String)"End client:RENDER");
        }
        StatGraph.setSystemLocale();
        repaintM.setDoubleBufferingEnabled(doubleBufferingEnabled);
    }

    private void saveToPNG() {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("png");
        ImageWriter writer = null;
        while (writers.hasNext()) {
            writer = writers.next();
        }
        if (writer == null) {
            return;
        }
        MemoryCacheImageOutputStream mcios = new MemoryCacheImageOutputStream(this.imageBOS);
        writer.setOutput(mcios);
        ImageWriteParam writeParam = writer.getDefaultWriteParam();
        ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
        IIOMetadata meta = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
        IIOMetadataNode root = (IIOMetadataNode)meta.getAsTree("javax_imageio_png_1.0");
        IIOMetadataNode pHYS_node = new IIOMetadataNode("pHYS");
        root.appendChild(pHYS_node);
        int dpi2meter = (int)(StatGraph.dataDPIScaleFactor * 96.0 / 0.0254);
        pHYS_node.setAttribute("pixelsPerUnitXAxis", String.valueOf(dpi2meter));
        pHYS_node.setAttribute("pixelsPerUnitYAxis", String.valueOf(dpi2meter));
        pHYS_node.setAttribute("unitSpecifier", "meter");
        try {
            meta.setFromTree("javax_imageio_png_1.0", root);
        }
        catch (Exception e) {
            root.removeChild(pHYS_node);
            pHYS_node = new IIOMetadataNode("pHYs");
            root.appendChild(pHYS_node);
            pHYS_node.setAttribute("pixelsPerUnitXAxis", String.valueOf(dpi2meter));
            pHYS_node.setAttribute("pixelsPerUnitYAxis", String.valueOf(dpi2meter));
            pHYS_node.setAttribute("unitSpecifier", "meter");
            try {
                meta.setFromTree("javax_imageio_png_1.0", root);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            writer.write(null, new IIOImage(bi, null, meta), writeParam);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.toString());
        }
    }

    public int getNumPages() {
        return this.numPages;
    }

    private void abort() {
        if (this.imageFile != null) {
            try {
                this.imageBOS.close();
                this.imageOutStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.imageFile.delete();
        }
        if (this.imagemapFile != null) {
            try {
                this.mapPrintStream.close();
                this.mapOutStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.imagemapFile.delete();
        }
    }

    private void parseData() {
        SAXParserFactory dpf = SAXParserFactory.newInstance();
        try {
            dpf.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        dpf.setValidating(false);
        dpf.setNamespaceAware(false);
        DataParser handler = null;
        try {
            SAXParser parser = dpf.newSAXParser();
            ParserAdapter pa = new ParserAdapter(parser.getParser());
            handler = new DataParser(this.panel.graph);
            InputSource src = new InputSource(new BufferedInputStream(new FileInputStream(this.xmlDataFile)));
            pa.setContentHandler((ContentHandler)handler);
            parser.parse(src, (DefaultHandler)handler);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        handler = null;
    }

    private Document parseXML() {
        DocumentBuilder parser = null;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilderFactory.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            parser = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            System.out.println("pce=" + pce);
            return null;
        }
        Document document = null;
        try {
            FileInputStream fis = new FileInputStream(this.xmlFile);
            InputSource src = new InputSource(new BufferedInputStream(fis));
            document = parser.parse(src);
        }
        catch (Exception e) {
            String msg = "Internal Exception:" + e;
            if (e instanceof FileNotFoundException) {
                msg = "XML file '" + this.xmlFile + "' not found.";
            }
            System.out.println(msg);
            e.printStackTrace();
            return null;
        }
        return document;
    }

    private boolean is3DPlot(Document doc) {
        if (doc.getElementsByTagName("LayoutOverlay3D").getLength() > 0) {
            return true;
        }
        NodeList nl = doc.getElementsByTagName("ContourPlotParm");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element elem = (Element)nl.item(i);
            String contourType = elem.getAttribute("contourType").toUpperCase();
            if (contourType.indexOf("GRADIENT") < 0) continue;
            return true;
        }
        return false;
    }

    private void writeImageMap(ArrayList maps, PrintStream p, int width, int height, String drillTarget) {
        try {
            for (int cnt = 0; cnt < maps.size(); ++cnt) {
                ImageMap imageMap = (ImageMap)maps.get(cnt);
                if (imageMap == null) continue;
                ImageMap.Region[] regions = imageMap.getRegions();
                for (int i = 0; i < regions.length; ++i) {
                    int j;
                    String href;
                    p.print("<Area shape=\"poly\" ");
                    if (regions[i].getALT() != null) {
                        p.print("alt=\"" + regions[i].getALT() + "\" ");
                        p.print("title=\"" + regions[i].getALT() + "\" ");
                    }
                    if ((href = regions[i].getHREF()) != null && href.trim().length() > 0) {
                        p.print("href=\"" + href + "\" ");
                        p.print("target=\"" + drillTarget + "\" ");
                    }
                    p.print("coords=\"");
                    Shape shape = regions[i].getCoords();
                    if (shape instanceof Polygon) {
                        Polygon polygon = (Polygon)shape;
                        for (j = 0; j < polygon.npoints; ++j) {
                            p.print(polygon.xpoints[j] + "," + polygon.ypoints[j]);
                            if (j > polygon.npoints) continue;
                            p.print(",");
                        }
                    } else {
                        PathIterator pi = shape.getPathIterator(null, 2.0);
                        j = 0;
                        double[] coord = new double[6];
                        double firstX = 0.0;
                        double firstY = 0.0;
                        while (!pi.isDone()) {
                            int type = pi.currentSegment(coord);
                            switch (type) {
                                default: {
                                    break;
                                }
                                case 0: {
                                    p.print(coord[0] + "," + coord[1]);
                                    p.print(",");
                                    firstX = coord[0];
                                    firstY = coord[1];
                                    break;
                                }
                                case 1: {
                                    p.print(coord[0] + "," + coord[1]);
                                    p.print(",");
                                    break;
                                }
                                case 4: {
                                    p.print(firstX + "," + firstY);
                                }
                            }
                            pi.next();
                        }
                    }
                    p.print("\"");
                    p.print("/>");
                    p.println();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void removeAntialiasing(Document doc) {
        NodeList nl = doc.getElementsByTagName("StatGraph");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e = (Element)nl.item(i);
            e.setAttribute("antiAlias", "test");
        }
    }

    private void saveToVGF() {
        VGFGraphics2D g;
        Document doc;
        String xmlEncoding = null;
        this.numPages = -1;
        if (this.getTiming()) {
            StatGraphPanel.dumpTiming = true;
            StatGraphPanel.dumpTimeStamp((String)"Begin client:RENDER");
        }
        RepaintManager repaintM = RepaintManager.currentManager((JComponent)this.panel);
        boolean doubleBufferingEnabled = repaintM.isDoubleBufferingEnabled();
        repaintM.setDoubleBufferingEnabled(false);
        if (StatGraphPanel.dumpTiming) {
            StatGraphPanel.dumpTimeStamp((String)"Begin client:process graph_spec");
        }
        if (this.xmlDataFile != null) {
            this.parseData();
        }
        if ((doc = this.parseXML()) == null) {
            System.out.println("Problem reading XML");
        } else {
            xmlEncoding = doc.getXmlEncoding();
        }
        StatGraph cfr_ignored_0 = this.panel.graph;
        StatGraph.sessionLocale = StatGraph.getSessionLocale((Document)doc);
        StatGraph.setSessionLocale();
        if (StatGraphPanel.dumpTiming) {
            StatGraphPanel.dumpTimeStamp((String)"End client:process graph_spec");
            StatGraphPanel.dumpTimeStamp((String)"Begin client:build graph");
        }
        this.panel.addNotify();
        this.panel.setSize(this.size);
        this.removeAntialiasing(doc);
        this.panel.load(doc);
        this.numPages = this.panel.graph.getNumPages();
        doc = null;
        this.panel.invalidate();
        this.panel.validate();
        if (StatGraph.textWrapped) {
            if (this.panel.getComponent(0) instanceof TrellisPlot) {
                this.panel.getComponent(0).invalidate();
            }
            this.panel.invalidate();
            this.panel.validate();
        }
        if (StatGraphPanel.dumpTiming) {
            StatGraphPanel.dumpTimeStamp((String)"End client:build graph");
            StatGraphPanel.dumpTimeStamp((String)"Begin client:create VectorGraphics2D");
        }
        if (this.outFile.length() > 0) {
            this.imageFile = new File(this.outFile);
            g = new VGFGraphics2D((Component)this.panel, this.imageFile.getAbsolutePath());
        } else {
            g = new VGFGraphics2D((Component)this.panel, (String)null);
        }
        StatGraph cfr_ignored_1 = this.panel.graph;
        if (StatGraph.SVG) {
            VGFGraphics2D.SVG_destination = true;
        }
        g.begin(false, true);
        this.panel.paint((Graphics)g);
        if (this.panel.graph.isImagemapEnabled()) {
            this.panel.setSVGSelectionMode(true);
            g.setSelectionMode(true);
            VGFGraphics2D.selectionMode = true;
            this.panel.paint((Graphics)g);
            this.panel.setSVGSelectionMode(false);
            VGFGraphics2D.selectionMode = false;
            g.setSelectionMode(false);
        }
        g.end();
        StatGraph cfr_ignored_2 = this.panel.graph;
        if (StatGraph.SVG) {
            VGFGraphics2D.SVG_destination = false;
        }
        this.panel = null;
        if (StatGraphPanel.dumpTiming) {
            StatGraphPanel.dumpTimeStamp((String)"End client:encode image");
        }
        if (StatGraphPanel.dumpTiming) {
            StatGraphPanel.dumpTimeStamp((String)"End client:RENDER");
        }
        StatGraph.setSystemLocale();
        repaintM.setDoubleBufferingEnabled(doubleBufferingEnabled);
    }

    public StatGraphSSR(String[] args) {
        this.setXmlFile(args[0]);
        this.setOutFile(args[1]);
        this.setSize(new Dimension(Integer.parseInt(args[2].trim()), Integer.parseInt(args[3].trim())));
        boolean svg = false;
        for (int i = 4; i < args.length; ++i) {
            if (args[i].equals("-timing")) {
                this.setTiming(true);
                continue;
            }
            if (args[i].equals("-svg")) {
                svg = true;
                continue;
            }
            if (args[i].equals("-imagetype")) {
                String imagetype;
                if ((imagetype = args[++i]).equalsIgnoreCase("BMP")) {
                    this.setType((byte)1);
                    continue;
                }
                if (imagetype.equalsIgnoreCase("PNG")) {
                    this.setType((byte)2);
                    continue;
                }
                if (!imagetype.equalsIgnoreCase("VGF")) continue;
                this.setType((byte)3);
                continue;
            }
            if (args[i].equals("-mapfile")) {
                this.setMapFile(args[++i]);
                continue;
            }
            if (args[i].equals("-dpi")) {
                this.setDPI(Integer.parseInt(args[++i].trim()));
                continue;
            }
            if (args[i].equals("-datafile")) {
                this.setXmlDataFile(args[++i]);
                continue;
            }
            if (args[i].equals("-backupstyle")) {
                this.setBackupStyleName(args[++i]);
                continue;
            }
            if (!args[i].equals("-BIRD")) continue;
            this.birdRenderer = true;
        }
        this.panel = new StatGraphPanel();
        this.panel.setServer(true);
        this.panel.separateData = true;
        StatGraph cfr_ignored_0 = this.panel.graph;
        StatGraph.systemLocale = Locale.getDefault();
        StatGraph cfr_ignored_1 = this.panel.graph;
        StatGraph.SVG = svg;
        StatGraph.setBirdRenderer((boolean)this.birdRenderer);
    }

    public DataModel addChartModel(String name) {
        DataModel chartModel = new DataModel();
        chartModel.name = name;
        this.panel.addData(chartModel);
        return chartModel;
    }

    public void addChartModel(DataModel model) {
        this.panel.addData(model);
    }

    public void addOLAPData(String name, OLAPDataSetInterface olap) {
        this.panel.addOLAPData(name, olap);
    }

    public void addMapProvider(AbstractMapProvider provider) {
        this.panel.addMapProvider(provider);
    }

    public void addRangeAttrMap(String name, RangeAttributeMap ram) {
        this.panel.addRangeAttrMap(name, ram);
    }

    public void setProxy(Proxy proxy) {
        this.panel.setProxy(proxy);
    }
}

