/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.app;

import com.sas.graphics.applets.ganttchart.GanttChart;
import com.sas.graphics.applets.ganttchart.RB;
import com.sas.graphics.components.CompoundTimeAxisModel;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.components.TableAxisColumn;
import com.sas.graphics.components.ganttchart.GanttChartModel;
import com.sas.graphics.util.cell.ChartContainer;
import com.sas.graphics.util.cell.CompoundTimeAxisCell;
import com.sas.graphics.util.cell.LegendCell;
import com.sas.graphics.util.cell.ganttchart.GanttChartCell;
import com.sas.graphics.util.cell.ganttchart.GanttTreeTable;
import com.sas.measures.BaseLength;
import com.sas.swing.visuals.treetable.TreeTable;
import com.sas.swing.visuals.treetable.TreeTableHeader;
import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GanttChartApp
extends GanttChart {
    private static final String configDir = "config";
    private static final String propsFile = "isv.properties";
    private static String[] app_argv = null;
    com.sas.graphics.components.ganttchart.GanttChart ganttComponent;
    private Properties configuredProperties = null;
    private boolean useDefaultConfig;
    private static final String PARAMETER_FILE_PREFIX = "(file)";
    private static final String[] DEFAULT_PARAMETER_VALUES = new String[]{"SHOW_SPLASHSCREEN=NO", "SHOW_DATA_READ_BAR=NO", "PROMPT_FOR_PASSWORD=NO"};
    private static String dangerousKeys = ":username:password:";
    private static String colon = ":";

    public static void main(String[] argv) {
        BufferedImage buf;
        app_argv = GanttChartApp._preprocessArgs(argv);
        GanttChartApp app = null;
        JPanel c = null;
        Dimension bufSize = null;
        app = new GanttChartApp();
        c = app.getFullView();
        bufSize = c.getPreferredSize();
        if (bufSize.width < 0) {
            System.out.println("width = " + bufSize.width);
            System.exit(1);
        }
        if ((buf = new BufferedImage(bufSize.width, bufSize.height, 1)) == null) {
            System.out.println("BufferedImage failed");
            System.exit(1);
        }
        Graphics2D bufg = buf.createGraphics();
        c.paint(bufg);
        bufg.dispose();
        String filename = app.getParameter("SAVEAS_PNG_FILENAME");
        if (filename == null) {
            filename = "GanttChart" + System.currentTimeMillis() / 1000L % 100000L;
        }
        if (filename.length() < 4 || !filename.substring(filename.length() - 4).equalsIgnoreCase(".png")) {
            filename = filename + ".png";
        }
        try {
            ImageIO.write((RenderedImage)buf, "png", new File(filename));
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        System.exit(0);
    }

    public GanttChartApp() {
        String showGrid;
        String filename = this.getParameter("CONFIGURATION_FILE");
        if (filename == null) {
            this.useDefaultConfig = true;
            filename = "config/isv.properties";
        } else {
            this.useDefaultConfig = false;
        }
        File propsFile = new File(filename);
        if (propsFile.exists() && propsFile.canRead()) {
            this.configuredProperties = new Properties();
            try {
                URL propsUrl = propsFile.toURL();
                InputStream propsStream = propsUrl.openStream();
                this.configuredProperties.load(propsStream);
                propsStream.close();
            }
            catch (Exception x) {
                x.printStackTrace();
                System.exit(1);
            }
        } else if (!this.useDefaultConfig) {
            String nsf = MessageFormat.format(RB.getStringResource((String)"ProblemReadingFile.txt"), filename);
            this._showMessage(nsf, "", 0);
            System.exit(1);
        }
        if (this.configuredProperties != null) {
            String[] e = this.configuredProperties.keys();
            while (e.hasMoreElements()) {
                String key;
                Object keyObj = e.nextElement();
                if (!(keyObj instanceof String) || !GanttChartApp._keyIsDangerous(key = (String)keyObj)) continue;
                System.out.println(key + " is no longer supported due to security concerns.");
            }
        }
        if (app_argv != null) {
            for (String arg : app_argv) {
                String key;
                int eqIndex = arg.indexOf("=");
                if (eqIndex < 0) {
                    eqIndex = arg.length();
                }
                if (!GanttChartApp._keyIsDangerous(key = arg.substring(0, eqIndex))) continue;
                System.out.println(key + " is no longer supported due to security concerns.");
            }
        }
        this.init();
        while (this.ganttComponent == null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.ganttComponent = this.getGanttChartComponent();
        }
        this.ganttComponent.setAutoRepaintEnabled(false);
        int columnWidth = 100;
        String tcw = this.getParameter("TABLE_COLUMN_WIDTH");
        try {
            columnWidth = Integer.parseInt(tcw);
        }
        catch (Exception key) {
            // empty catch block
        }
        TableAxisColumn[] columns = this.ganttComponent.getGraphModel().getTableAxisModel().getColumns();
        if (columns == null) {
            System.exit(1);
        }
        for (int i = 0; i < columns.length; ++i) {
            columns[i].setWidth(new BaseLength((double)columnWidth, "px"));
        }
        String sts1 = this.getParameter("SHOW_TIMESCALE_UPPER");
        String sts2 = this.getParameter("SHOW_TIMESCALE_MIDDLE");
        String sts3 = this.getParameter("SHOW_TIMESCALE_LOWER");
        CompoundTimeAxisModel ctam = this.ganttComponent.getGraphModel().getDateAxisModel();
        ctam.getTimePeriodModel1().setVisible(sts1 == null || GanttChartApp._stringIsYes(sts1));
        ctam.getTimePeriodModel2().setVisible(sts2 == null || GanttChartApp._stringIsYes(sts2));
        ctam.getTimePeriodModel3().setVisible(sts3 == null || GanttChartApp._stringIsYes(sts3));
        String gsname = this.getParameter("GRAPH_STYLE");
        if (gsname != null && gsname.length() > 0) {
            int gs = -1;
            try {
                gs = GraphStyle.STYLE.valueOfName(gsname);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                gs = GraphStyle.STYLE.valueOfJSPAttribute(gsname);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (gs >= 0) {
                this.ganttComponent.applyGraphStyle(new GraphStyle(gs));
            } else {
                System.out.println("No such graph style: " + gsname);
            }
        }
        int vis = GanttChartApp._stringIsYes(showGrid = this.getParameter("SHOW_GRIDLINES")) ? 10201 : 10202;
        GanttChartModel m = this.ganttComponent.getGraphModel();
        m.getDateAxisModel().getGridLineStyle().setVisibilityPolicy(vis);
        m.getTableAxisModel().getGridLineStyle().setVisibilityPolicy(vis);
        Container c = this.ganttComponent.getParent();
        if (c != null) {
            c.remove((Component)this.ganttComponent);
        }
    }

    private JPanel getFullView() {
        return new FullView(this.ganttComponent);
    }

    protected void _showMessage(Object msg, String title, int messageType) {
        String mt;
        String string = messageType == 2 ? RB.getStringResource((String)"Warning.txt") + ": " : (mt = messageType == 0 ? RB.getStringResource((String)"Error.txt") + ": " : null);
        if (msg instanceof JComponent) {
            JComponent c = (JComponent)msg;
            if (mt != null) {
                System.err.println(mt);
            }
            for (int i = 0; i < c.getComponentCount(); ++i) {
                Component ci = c.getComponent(i);
                if (!(ci instanceof JLabel)) continue;
                System.err.println(((JLabel)ci).getText());
            }
        } else if (msg instanceof String) {
            System.err.println((mt != null ? mt : "") + (String)msg);
        }
    }

    public String getParameter(String s) {
        String value;
        if (app_argv == null) {
            return super.getParameter(s);
        }
        if (GanttChartApp._keyIsDangerous(s)) {
            return null;
        }
        for (String arg_i : app_argv) {
            if (!arg_i.startsWith(s + "=")) continue;
            String value2 = arg_i.substring(s.length() + 1);
            if (value2.startsWith(PARAMETER_FILE_PREFIX)) {
                String filename = value2.substring(PARAMETER_FILE_PREFIX.length());
                File f = new File(filename);
                int len = (int)f.length();
                char[] content = new char[len];
                try {
                    FileReader r = new FileReader(f);
                    len = r.read(content, 0, content.length);
                    r.close();
                }
                catch (IOException x) {
                    x.printStackTrace();
                    len = 0;
                }
                value2 = new String(content, 0, len);
            }
            return value2;
        }
        if (this.configuredProperties != null && (value = this.configuredProperties.getProperty(s)) != null) {
            return value.trim();
        }
        for (String arg_i : DEFAULT_PARAMETER_VALUES) {
            if (!arg_i.startsWith(s + "=")) continue;
            return arg_i.substring(s.length() + 1);
        }
        return null;
    }

    public URL getDocumentBase() {
        return app_argv == null ? super.getDocumentBase() : null;
    }

    public URL getCodeBase() {
        return app_argv == null ? super.getCodeBase() : null;
    }

    public AppletContext getAppletContext() {
        return app_argv == null ? super.getAppletContext() : null;
    }

    private static String[] _preprocessArgs(String[] argv) {
        Vector<String> newArgv = new Vector<String>();
        StringBuffer buf = new StringBuffer();
        char quote = 'x';
        int quotedArgBeginningIndex = -1;
        for (int i = 0; i < argv.length; ++i) {
            int eq;
            String arg_i = argv[i];
            if (quotedArgBeginningIndex > 0) {
                buf.append(' ');
                buf.append(arg_i);
                if (arg_i.charAt(arg_i.length() - 1) != quote) continue;
                eq = buf.indexOf("=");
                newArgv.add(buf.substring(0, eq + 1) + buf.substring(eq + 2, buf.length() - 2));
                buf.setLength(0);
                quotedArgBeginningIndex = -1;
                continue;
            }
            eq = arg_i.indexOf("=");
            if (eq < 0 || eq >= arg_i.length()) continue;
            char firstch = arg_i.charAt(eq + 1);
            char lastch = arg_i.charAt(arg_i.length() - 1);
            if (firstch == '\"' || firstch == '\'') {
                if (lastch == firstch && arg_i.length() - 1 > eq + 1) {
                    newArgv.add(arg_i.substring(0, eq + 1) + arg_i.substring(eq + 2, arg_i.length() - 1));
                    continue;
                }
                quote = firstch;
                quotedArgBeginningIndex = i;
                buf.append(arg_i);
                continue;
            }
            newArgv.add(arg_i);
        }
        if (quotedArgBeginningIndex >= 0) {
            System.out.println("warning: last arg has no ending quote: " + buf.toString());
            newArgv.add(buf.toString());
            buf.setLength(0);
            quotedArgBeginningIndex = -1;
        }
        return newArgv.toArray(new String[0]);
    }

    private static boolean _stringIsYes(String s) {
        if (s == null) {
            return false;
        }
        return s.compareToIgnoreCase("yes") == 0 || s.compareToIgnoreCase("y") == 0;
    }

    private static int max(int a, int b, int c, int d) {
        return GanttChartApp.max(GanttChartApp.max(a, b), GanttChartApp.max(c, d));
    }

    private static int max(int a, int b) {
        return a >= b ? a : b;
    }

    private static boolean _keyIsDangerous(Object keyObj) {
        boolean keyContainsColon = false;
        boolean keyAppearsInDangerList = false;
        if (keyObj != null && keyObj instanceof String) {
            String key = (String)keyObj;
            keyContainsColon = key.indexOf(colon) >= 0;
            keyAppearsInDangerList = dangerousKeys.indexOf(colon + key.toLowerCase() + colon) >= 0;
        }
        return !keyContainsColon && keyAppearsInDangerList;
    }

    class FullView
    extends JPanel {
        BufferedImage iii;
        JComponent gch;
        JComponent gc;
        JComponent tth;
        JComponent tt;
        JComponent header;
        JComponent footer;
        JComponent legend;
        int aw;
        int ah;
        int cw;
        int ch;
        int hw;
        int hh;
        int fw;
        int fh;
        int lw;
        int lh;
        int sideMargin;
        int totalWidth;
        int totalHeight;

        public FullView(com.sas.graphics.components.ganttchart.GanttChart c) {
            c.setAutoRepaintEnabled(false);
            c.addNotify();
            c.getPreferredSize();
            c.setBounds(0, 0, 600, 480);
            c.prepareToPaint();
            this.iii = new BufferedImage(40, 40, 1);
            if (this.iii == null) {
                System.out.println("BufferedImage failed");
                System.exit(1);
            }
            Graphics2D ig = this.iii.createGraphics();
            c.paintAll((Graphics)ig);
            ig.dispose();
            this.totalWidth = 640;
            this.totalHeight = 480;
            ChartContainer cc = (ChartContainer)this.findSubcomponent((Container)c, ChartContainer.class);
            this.tt = this.findSubcomponent((Container)c, GanttTreeTable.class);
            this.tth = this.findSubcomponent((Container)c, TreeTableHeader.class);
            if (this.tth == null && this.tt != null) {
                this.tth = ((TreeTable)this.tt).getTableHeader();
            }
            this.gc = this.findSubcomponent((Container)c, GanttChartCell.class);
            this.gch = this.findSubcomponent((Container)c, CompoundTimeAxisCell.class);
            this.header = this.unwrapComponent(cc.getTitle());
            this.footer = this.unwrapComponent(cc.getFootnote());
            this.legend = this.unwrapComponent(this.findSubcomponent((Container)c, LegendCell.class));
            int n = this.aw = this.tt != null ? this.tt.getWidth() : 0;
            this.ah = this.gch != null ? this.gch.getHeight() : (this.tth != null ? this.tth.getHeight() : 0);
            int n2 = this.cw = this.gc != null ? this.gc.getWidth() : 0;
            this.ch = this.gc != null ? this.gc.getHeight() : (this.tt != null ? this.tt.getHeight() : 0);
            this.hw = this.header != null ? this.header.getWidth() : 0;
            this.hh = this.header != null ? this.header.getHeight() : 0;
            this.fw = this.footer != null ? this.footer.getWidth() : 0;
            this.fh = this.footer != null ? this.footer.getHeight() : 0;
            this.lw = this.legend != null ? this.legend.getWidth() : 0;
            this.lh = this.legend != null ? this.legend.getHeight() : 0;
            this.sideMargin = 20;
            this.totalWidth = GanttChartApp.max(this.aw + this.cw, this.hw, this.fw, this.lw) + 2 * this.sideMargin;
            this.totalHeight = 3 * this.hh / 2 + this.ah + this.ch + 3 * this.fh / 2 + 3 * this.lh / 2 + 2 * this.sideMargin;
        }

        private JComponent findSubcomponent(Container p, Class cc) {
            int i1 = p.getComponentCount();
            for (int i = 0; i < i1; ++i) {
                JComponent jc;
                Component c = p.getComponent(i);
                if (c.getClass().equals(cc)) {
                    return (JComponent)c;
                }
                if (!(c instanceof Container) || (jc = this.findSubcomponent((Container)c, cc)) == null) continue;
                return jc;
            }
            return null;
        }

        private JComponent unwrapComponent(JComponent jc0) {
            JComponent jc1;
            for (jc1 = jc0; jc1 != null && jc1.getComponentCount() == 1 && jc1.getComponent(0) instanceof JComponent; jc1 = (JComponent)jc1.getComponent(0)) {
            }
            return jc1;
        }

        @Override
        public void paint(Graphics g) {
            GanttChartApp.this.ganttComponent.paintBackground(g, new Rectangle(this.totalWidth, this.totalHeight), new Insets(0, 0, 0, 0));
            int y = this.sideMargin;
            this.paintElement(this.header, g, (this.totalWidth - this.hw) / 2, y, this.hw, this.hh);
            this.paintElement(this.tth, g, this.sideMargin, y += this.hh + this.hh / 2, this.aw, this.ah);
            this.paintElement(this.gch, g, this.sideMargin + this.aw, y, this.cw, this.ah);
            y += this.ah;
            GanttChartCell gcc = (GanttChartCell)this.gc;
            boolean opt = false;
            if (gcc != null) {
                opt = gcc.isRenderingOptimized();
            }
            if (gcc != null) {
                gcc.setRenderingOptimized(false);
            }
            this.paintElement(this.tt, g, this.sideMargin, y, this.aw, this.ch);
            this.paintElement(this.gc, g, this.sideMargin + this.aw, y, this.cw, this.ch);
            y += this.ch;
            if (gcc != null) {
                gcc.setRenderingOptimized(opt);
            }
            this.paintElement(this.footer, g, (this.totalWidth - this.fw) / 2, y, this.fw, this.fh);
            this.paintElement(this.legend, g, (this.totalWidth - this.lw) / 2, y += this.fh + this.fh / 2, this.lw, this.lh);
            y += this.lh + this.lh / 2;
        }

        private synchronized void paintElement(JComponent j, Graphics g, int x, int y, int w, int h) {
            if (j == null) {
                return;
            }
            boolean db = j.isDoubleBuffered();
            j.setDoubleBuffered(false);
            g.setClip(x - 1, y - 1, w + 2, h + 2);
            g.translate(x, y);
            j.paint(g);
            g.translate(-x, -y);
            j.setDoubleBuffered(db);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.totalWidth, this.totalHeight);
        }

        @Override
        public Rectangle getBounds() {
            return new Rectangle(0, 0, this.totalWidth, this.totalHeight);
        }
    }
}

