/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.app;

import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.StatGraphPanel;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.styles.PredefinedStyles;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GTLRenderInitializer {
    public GTLRenderInitializer(String outputFile) {
        StatGraphPanel panel = new StatGraphPanel();
        panel.setServer(true);
        panel.separateData = true;
        StatGraph cfr_ignored_0 = panel.graph;
        StatGraph.systemLocale = Locale.getDefault();
        panel.graph.style = new GraphStyle();
        panel.graph.style.setGraphStyle(PredefinedStyles.getPredefinedStyle((String)"Default"));
        DataModel dm = new DataModel();
        dm.name = "DUMMY";
        panel.addData(dm);
        dm.addDoubleColumn("X", "X", null, 0.0, 1.0, 0, new double[]{0.0, 1.0});
        dm.addDoubleColumn("Y", "Y", null, 0.0, 1.0, 0, new double[]{0.0, 1.0});
        RepaintManager repaintM = RepaintManager.currentManager((JComponent)panel);
        boolean doubleBufferingEnabled = repaintM.isDoubleBufferingEnabled();
        repaintM.setDoubleBufferingEnabled(false);
        panel.addNotify();
        BufferedImage bi = new BufferedImage(100, 75, 1);
        int width = bi.getWidth();
        int height = bi.getHeight();
        panel.setSize(new Dimension(width, height));
        Document doc = this.createDummyDOMDocument();
        panel.load(doc);
        doc = null;
        panel.invalidate();
        panel.validate();
        Graphics2D g = bi.createGraphics();
        panel.paint((Graphics)g);
        g.dispose();
        panel = null;
        dm = null;
        repaintM.setDoubleBufferingEnabled(doubleBufferingEnabled);
        if (outputFile != null && outputFile.trim().length() > 0) {
            File out = new File(outputFile);
            try {
                FileOutputStream fos = new FileOutputStream(out);
                ImageIO.setUseCache(false);
                ImageIO.write((RenderedImage)bi, "png", fos);
                fos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Document createDummyDOMDocument() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
            Element root = doc.createElement("SASReport");
            root.setAttribute("version", "9.3");
            doc.appendChild(root);
            Element view = doc.createElement("View");
            root.appendChild(view);
            Element graph = doc.createElement("StatGraph");
            graph.setAttribute("pad", "0");
            graph.setAttribute("dataSizeScalingFactor", "0.25");
            view.appendChild(graph);
            Element lattice = doc.createElement("LayoutLattice");
            graph.appendChild(lattice);
            Element overlay = doc.createElement("LayoutOverlay");
            lattice.appendChild(overlay);
            Element xo = doc.createElement("XAxisOpts");
            xo.setAttribute("display", "LABEL TICKS");
            overlay.appendChild(xo);
            Element yo = doc.createElement("YAxisOpts");
            yo.setAttribute("display", "LABEL TICKS");
            overlay.appendChild(yo);
            Element scatter = doc.createElement("ScatterPlot");
            scatter.setAttribute("x", "DUMMY#X");
            scatter.setAttribute("y", "DUMMY#Y");
            overlay.appendChild(scatter);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return doc;
    }
}

