/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.app;

import com.sas.graphics.app.BirdGTMLResolver;
import com.sas.graphics.app.StatGraphSSR;
import com.sas.graphics.applets.statgraph.StatGraphPanel;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class BirdSSR
extends StatGraphSSR {
    private String _styleFile = null;
    private Boolean _debug = false;
    private int gtmlDpi = -1;
    private Document _document = null;

    public int getGtmlDPI() {
        return this.gtmlDpi;
    }

    public void setGtmlDPI(int aInt) {
        this.gtmlDpi = aInt;
    }

    public String getStyleFile() {
        return this._styleFile;
    }

    public void setStyleFile(String styleFile) {
        this._styleFile = styleFile;
    }

    public BirdSSR(String[] args) {
        super(args);
        int i;
        if (this.getTiming()) {
            StatGraphPanel.dumpTiming = true;
            StatGraphPanel.dumpTimeStamp((String)"Start BirdSSR");
        }
        for (i = 4; i < args.length; ++i) {
            if (args[i].equals("-style")) {
                this.setStyleFile(args[++i]);
                continue;
            }
            if (!args[i].equals("-dpi")) continue;
            this.setDPI(-1);
            this.setGtmlDPI(Integer.parseInt(args[++i].trim()));
        }
        if (StatGraphPanel.dumpTiming) {
            for (i = 0; i < args.length; ++i) {
                System.out.println(i + ":" + args[i]);
            }
        }
        try {
            try {
                InputSource src = new InputSource(new FileInputStream(this.getXmlFile()));
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                this._document = parser.parse(src);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String gtml = new BirdGTMLResolver(this._document, this.getXmlDataFile() != null, this.getGtmlDPI()).getResolvedGTML();
            this.writeResolvedViewXml(gtml);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StatGraphPanel.dumpTiming) {
            StatGraphPanel.dumpTimeStamp((String)"End BirdSSR");
        }
    }

    public void writeResolvedViewXml(String resolvedGTML) {
        this.setXmlFile(this.getXmlFile() + ".tmp");
        StringBuffer styleSb = null;
        try {
            BufferedInputStream styleBis = new BufferedInputStream(new FileInputStream(this.getStyleFile()));
            styleSb = new StringBuffer();
            while (styleBis.available() > 0) {
                styleSb.append((char)styleBis.read());
            }
            styleBis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringBuffer xmlHeader = new StringBuffer();
        xmlHeader.append("<?xml version=\"" + this._document.getXmlVersion() + "\"");
        if (this._document.getInputEncoding() != null) {
            xmlHeader.append(" encoding=\"" + this._document.getInputEncoding() + "\"");
        }
        xmlHeader.append(" ?>");
        String gtmlString = xmlHeader.toString() + "<SASReport version=\"1.2\" xmlns:style=\"http://www.sas.com/sasreportmodel/styles\">" + styleSb + "<View>" + resolvedGTML + "</View></SASReport>";
        try {
            FileOutputStream fos = new FileOutputStream(new File(this.getXmlFile()));
            fos.write(gtmlString.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        new BirdSSR(args);
    }
}

