/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.appmeta;

import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.tools.appmeta.AppMetaException;
import com.sas.metadata.tools.appmeta.Application2;
import com.sas.metadata.tools.appmeta.Service2;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Services2
implements LocalizableProperties {
    private Application2 _application = null;
    private List<Service2> _services = new ArrayList<Service2>();
    private Tree _servicesTree = null;

    private Services2() {
    }

    static Services2 create(Application2 application) {
        Services2 services = new Services2();
        services._application = application;
        return services;
    }

    Application2 getApplication() {
        return this._application;
    }

    void loadFromXML(Element xml) throws AppMetaException {
        NodeList nodes = xml.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element;
            String tagName;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(tagName = (element = (Element)node).getTagName()).equals("Service2")) continue;
            Service2 service = Service2.create(this);
            service.loadFromXML(element);
            this._services.add(service);
        }
    }

    void mergeToMetadata() throws MdException {
        for (Service2 service : this._services) {
            service.mergeToMetadata();
        }
    }

    void loadFromMetadata(SoftwareComponent sc, Element parent) throws MdException {
        try {
            Element services = null;
            for (Object item : sc.getDeployedComponents()) {
                DeployedComponent comp = (DeployedComponent)item;
                if ("Registered SAS Application2".equals(comp.getName())) continue;
                if (services == null) {
                    services = parent.getOwnerDocument().createElement("Services");
                    parent.appendChild(services);
                }
                Service2 service = Service2.create(this);
                service.loadFromMetadata(comp, services);
                this._services.add(service);
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    Tree getServicesTree(boolean create) throws MdException {
        if (this._servicesTree == null) {
            try {
                MdObjectStore store = (MdObjectStore)this._application.getJomaObject().getObjectStore();
                MdOMIUtil omiUtil = store.getFactory().getOMIUtil();
                List objects = omiUtil.getMetadataObjectsSubset((MdStore)store, omiUtil.getFoundationReposID(), "Tree", 8584, "<XMLSelect search=\"Tree[@Name='Registered SAS Services']\"/>");
                if (objects.size() >= 1) {
                    this._servicesTree = (Tree)objects.get(0);
                } else if (create) {
                    this._servicesTree = (Tree)store.getFactory().createComplexMetadataObject(store, "Registered SAS Services", "Tree", omiUtil.getFoundationReposID().substring(9));
                    this._servicesTree.setDesc("Service2 definitions");
                }
            }
            catch (RemoteException e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        return this._servicesTree;
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        for (Service2 service : this._services) {
            list.addProperty(service.getName(), service.getLocalizableProperties());
        }
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        for (Service2 service : this._services) {
            String propertyName = service.getName();
            if (!map.containsNestedProperty(propertyName)) continue;
            service.setLocalizableProperties(map.getNestedProperties(propertyName));
        }
    }
}

