/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.appmeta;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.tools.appmeta.Directives2;
import com.sas.metadata.tools.appmeta.MetadataBase2;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.w3c.dom.Element;

abstract class Directive2
extends MetadataBase2
implements LocalizableProperties {
    protected Directives2 _directives = null;
    protected boolean _public = false;
    protected boolean _logonTarget = false;
    protected boolean _admin = false;
    protected String _action = null;
    protected Property _typeProperty = null;
    protected PropertySet _directivePropertySet = null;

    protected Directive2(Directives2 parent) {
        super(parent.getApplication().getContext());
    }

    Directives2 getDirectives() {
        return this._directives;
    }

    boolean isPublic() {
        return this._public;
    }

    boolean isLogonTarget() {
        return this._logonTarget;
    }

    boolean isAdmin() {
        return this._admin;
    }

    protected void getCommonAttributes(Element xml) {
        String isAdmin;
        String isLogonTarget;
        this._action = xml.getAttribute("_Action");
        this._desc = xml.getAttribute("Desc");
        String isPublic = xml.getAttribute("Public");
        if (isPublic.equalsIgnoreCase("true")) {
            this._public = true;
        }
        if ((isLogonTarget = xml.getAttribute("LogonTarget")).equalsIgnoreCase("true")) {
            this._logonTarget = true;
        }
        if ((isAdmin = xml.getAttribute("Admin")).equalsIgnoreCase("true")) {
            this._admin = true;
        }
        this.loadKeywordsFromXML(xml);
    }

    abstract void loadFromMetadata(ServiceComponent var1, Element var2) throws MdException;

    abstract void mergeToMetadata() throws MdException;

    protected void getCommonObjectAttributes() throws MdException {
        try {
            this._name = this._jomaObject.getName();
            this._desc = this._jomaObject.getDesc();
            for (Object item : this._jomaObject.getProperties()) {
                Property property = (Property)item;
                if (property.getName().equals("Public") && property.getDefaultValue().equalsIgnoreCase("true")) {
                    this._public = true;
                    continue;
                }
                if (property.getName().equals("LogonTarget") && property.getDefaultValue().equalsIgnoreCase("true")) {
                    this._logonTarget = true;
                    continue;
                }
                if (!property.getName().equals("Admin") || !property.getDefaultValue().equalsIgnoreCase("true")) continue;
                this._admin = true;
            }
            for (Object item : this._jomaObject.getPropertySets()) {
                PropertySet propertySet = (PropertySet)item;
                if (!propertySet.getName().equals("Directive")) continue;
                this._directivePropertySet = propertySet;
                break;
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    protected void setCommonObjectAttributes(Element directive) {
        directive.setAttribute("Name", this._name);
        if (this._desc != null && this._desc.length() > 0) {
            directive.setAttribute("Desc", this._desc);
        }
        if (this._public) {
            directive.setAttribute("Public", "true");
        }
        if (this._logonTarget) {
            directive.setAttribute("LogonTarget", "true");
        }
        if (this._admin) {
            directive.setAttribute("Admin", "true");
        }
    }

    boolean mergeToMetadataBase() throws MdException {
        try {
            Property property;
            ServiceComponent directive;
            Tree directivesObject = this._directives.getJomaObject();
            for (Object item : directivesObject.getMembers()) {
                if (!(item instanceof ServiceComponent) || !(directive = (ServiceComponent)item).getName().equals(this._name) || !directive.getClassIdentifier().equals("com.sas.framework.directives.client.Directive")) continue;
                this._jomaObject = directive;
                break;
            }
            MdObjectStore store = (MdObjectStore)directivesObject.getObjectStore();
            String reposId = directivesObject.getId().substring(0, 8);
            directive = (ServiceComponent)this._jomaObject;
            if ("Delete".equals(this._action)) {
                if (directive != null) {
                    this.deleteContainedObjects();
                    directive.delete();
                }
                return true;
            }
            if (directive == null) {
                directive = (ServiceComponent)store.getFactory().createComplexMetadataObject(store, this._name, "ServiceComponent", reposId);
                directive.getTrees().add((Object)directivesObject);
                this._jomaObject = directive;
            } else {
                if ("Create".equals(this._action)) {
                    return true;
                }
                this.deleteContainedObjects();
            }
            directive.setDesc(this._desc);
            directive.setClassIdentifier("com.sas.framework.directives.client.Directive");
            this._typeProperty = (Property)store.getFactory().createComplexMetadataObject(store, "Type", "Property", reposId);
            this._typeProperty.setPropertyName("Type");
            this._typeProperty.setSQLType(12);
            this._typeProperty.setAssociatedObject((Root)directive);
            if (this._public) {
                property = (Property)store.getFactory().createComplexMetadataObject(store, "Public", "Property", reposId);
                property.setPropertyName("Public");
                property.setSQLType(12);
                property.setDefaultValue("true");
                property.setAssociatedObject((Root)directive);
            }
            if (this._logonTarget) {
                property = (Property)store.getFactory().createComplexMetadataObject(store, "LogonTarget", "Property", reposId);
                property.setPropertyName("LogonTarget");
                property.setSQLType(12);
                property.setDefaultValue("true");
                property.setAssociatedObject((Root)directive);
            }
            if (this._admin) {
                property = (Property)store.getFactory().createComplexMetadataObject(store, "Admin", "Property", reposId);
                property.setPropertyName("Admin");
                property.setSQLType(12);
                property.setDefaultValue("true");
                property.setAssociatedObject((Root)directive);
            }
            if (this._directivePropertySet == null) {
                this._directivePropertySet = (PropertySet)store.getFactory().createComplexMetadataObject(store, "Directive", "PropertySet", reposId);
                this._directivePropertySet.setPropertySetName("Directive");
                this._directivePropertySet.setOwningObject((Root)directive);
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        this.mergeKeywordMetadata();
        return false;
    }

    private void deleteContainedObjects() throws MdException {
        try {
            ArrayList properties = new ArrayList(this._jomaObject.getProperties());
            for (Property property : properties) {
                property.delete();
            }
            ArrayList propertySets = new ArrayList(this._jomaObject.getPropertySets());
            for (PropertySet propertySet : propertySets) {
                ArrayList setProperties = new ArrayList(propertySet.getSetProperties());
                for (Property property : setProperties) {
                    property.delete();
                }
                propertySet.delete();
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        list.addProperty("Desc", this._desc);
        this.addLocalizableKeywordProperties(list);
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        if (map.containsProperty("Desc")) {
            this._desc = map.getProperty("Desc");
        }
        this.setLocalizableKeywordProperties(map);
    }
}

