/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.appmeta;

import com.sas.metadata.remote.AbstractPrompt;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PromptGroup;
import com.sas.metadata.remote.Root;
import com.sas.metadata.tools.appmeta.AppMetaException;
import com.sas.metadata.tools.appmeta.Configuration2;
import com.sas.metadata.tools.appmeta.MetadataBase2;
import com.sas.metadata.tools.appmeta.RB;
import com.sas.prompts.PromptUtil;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

final class ConfigurationPrompts2
extends MetadataBase2
implements MultiLocaleProperties {
    private static final String PROPERTY_BUNDLE_ATTR = "PropertyBundle";
    private static final String NAME_ATTR = "Name";
    private static final String DESC_ATTR = "Desc";
    static final String CONFIG_PROMPTS_NAME = "Application Configuration2";
    private static final String CONFIG_PROMPTS_DESC = "Prompt definitions for application configuration properties.";
    static final String PREF_PROMPTS_NAME = "Application Preferences";
    private static final String PREF_PROMPTS_DESC = "Preference definitions for application configuration properties.";
    String _promptDef = null;
    MultiLocaleProperties _localizablePrompts = null;
    String _propertyBundle = null;
    Configuration2 _parent = null;

    ConfigurationPrompts2(Configuration2 parent) {
        super(parent.getContext());
        this._parent = parent;
    }

    static ConfigurationPrompts2 create(Configuration2 parent) {
        ConfigurationPrompts2 prompt = new ConfigurationPrompts2(parent);
        return prompt;
    }

    void loadFromXML(Element xml) {
        try {
            Element pg = null;
            if (xml.getTagName().equals("PromptGroup")) {
                if (xml.hasAttribute(NAME_ATTR)) {
                    this._name = xml.getAttribute(NAME_ATTR);
                    xml.removeAttribute(NAME_ATTR);
                } else {
                    this._name = CONFIG_PROMPTS_NAME;
                }
                if (xml.hasAttribute(DESC_ATTR)) {
                    this._desc = xml.getAttribute(DESC_ATTR);
                    xml.removeAttribute(DESC_ATTR);
                } else {
                    this._desc = CONFIG_PROMPTS_DESC;
                }
                if (xml.hasAttribute(PROPERTY_BUNDLE_ATTR)) {
                    this._propertyBundle = xml.getAttribute(PROPERTY_BUNDLE_ATTR);
                    xml.removeAttribute(PROPERTY_BUNDLE_ATTR);
                }
                pg = xml;
            } else if (xml.getTagName().equals("Prompts")) {
                NodeList nodes = xml.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element element;
                    Node node = nodes.item(i);
                    if (node.getNodeType() != 1 || !(element = (Element)node).getTagName().equals("PromptGroup")) continue;
                    pg = element;
                    break;
                }
                if (pg == null) {
                    throw new AppMetaException("No PromptGroup found for Prompts element.");
                }
                this._name = CONFIG_PROMPTS_NAME;
                this._desc = xml.hasAttribute(DESC_ATTR) ? xml.getAttribute(DESC_ATTR) : CONFIG_PROMPTS_DESC;
                if (xml.hasAttribute(PROPERTY_BUNDLE_ATTR)) {
                    this._propertyBundle = xml.getAttribute(PROPERTY_BUNDLE_ATTR);
                }
            } else if (xml.getTagName().equals("Preferences")) {
                NodeList nodes = xml.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element element;
                    Node node = nodes.item(i);
                    if (node.getNodeType() != 1 || !(element = (Element)node).getTagName().equals("PromptGroup")) continue;
                    pg = element;
                    break;
                }
                if (pg == null) {
                    throw new AppMetaException("No PromptGroup found for Preferences element.");
                }
                this._name = PREF_PROMPTS_NAME;
                this._desc = xml.hasAttribute(DESC_ATTR) ? xml.getAttribute(DESC_ATTR) : PREF_PROMPTS_DESC;
            } else {
                throw new AppMetaException("Unexpected element for Configuration prompt: " + xml.getTagName());
            }
            this._promptDef = this._context.getEmbeddedXML(pg);
        }
        catch (Exception e) {
            this._context.getLogger().warn(RB.getStringResource("ConfigurationPrompts.ParseError.log"));
            this._context.getLogger().warn(e.getLocalizedMessage());
            this._context.declareWarning();
        }
    }

    void loadFromMetadata(PromptGroup pg, Element parent) throws MdException {
        try {
            this._name = pg.getName();
            this._desc = pg.getDesc();
            this._promptDef = pg.getGroupInfo();
            AssociationList extensions = pg.getExtensions();
            for (Object item : extensions) {
                Extension extension = (Extension)item;
                if (!extension.getName().equals(PROPERTY_BUNDLE_ATTR)) continue;
                this._propertyBundle = extension.getValue();
                break;
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        String promptElement = "Prompts";
        if (this._name.equals(PREF_PROMPTS_NAME)) {
            promptElement = "Preferences";
        }
        Element prompts = parent.getOwnerDocument().createElement(promptElement);
        if (promptElement.equals("Preferences") && !this._desc.equals("") && !this._desc.equals(PREF_PROMPTS_DESC)) {
            prompts.setAttribute(DESC_ATTR, this._desc);
        } else if (!this._desc.equals("") && !this._desc.equals(CONFIG_PROMPTS_DESC)) {
            prompts.setAttribute(DESC_ATTR, this._desc);
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            SAXSource source = new SAXSource(new NamespaceFilter("http://www.sas.com/xml/schema/namespace/ApplicationMetadata-9.4"), new InputSource(new StringReader(this._promptDef)));
            DOMResult result = new DOMResult(prompts);
            transformer.transform(source, result);
            if (this._propertyBundle != null) {
                prompts.setAttribute(PROPERTY_BUNDLE_ATTR, this._propertyBundle);
            }
        }
        catch (Exception e) {
            this._context.getLogger().warn(RB.getStringResource("ConfigurationPrompts.TransformError.log"));
            this._context.getLogger().warn(e.getLocalizedMessage());
            this._context.declareWarning();
        }
        parent.appendChild(prompts);
    }

    void mergeToMetadata() throws MdException {
        try {
            Root parentObject = this._parent.getParent().getJomaObject();
            ArrayList prompts = new ArrayList(parentObject.getPrompts());
            for (AbstractPrompt prompt : prompts) {
                if (!prompt.getName().startsWith(this._name) || !(prompt instanceof PromptGroup)) continue;
                prompt.delete();
            }
            MdObjectStore store = (MdObjectStore)parentObject.getObjectStore();
            String reposId = parentObject.getId().substring(0, 8);
            PromptGroup promptGroup = (PromptGroup)store.getFactory().createComplexMetadataObject(store, this._name, "PromptGroup", reposId);
            promptGroup.setPromptEnabledObject(parentObject);
            promptGroup.setDesc(this._desc);
            promptGroup.setPublicType("Embedded:PromptGroup");
            promptGroup.setUsageVersion(1000000.0);
            promptGroup.setGroupInfo(this._promptDef);
            promptGroup.setGroupType(2);
            this._jomaObject = promptGroup;
            if (this._propertyBundle != null) {
                MdOMIUtil omiUtil = store.getFactory().getOMIUtil();
                Extension propertyBundle = (Extension)store.getFactory().createComplexMetadataObject(store, PROPERTY_BUNDLE_ATTR, "Extension", omiUtil.getFoundationReposID().substring(9));
                propertyBundle.setOwningObject(this._jomaObject);
                propertyBundle.setValue(this._propertyBundle);
                propertyBundle.setExtensionType(PROPERTY_BUNDLE_ATTR);
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        if (this._localizablePrompts != null) {
            return this._localizablePrompts.getLocalizableProperties();
        }
        if (this._promptDef != null) {
            return this.getPromptsForLocalization().getLocalizableProperties();
        }
        return null;
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        MultiLocaleProperties localizablePrompts = this._localizablePrompts;
        if (localizablePrompts == null && (localizablePrompts = this.getPromptsForLocalization()) == null) {
            return;
        }
        localizablePrompts.setLocalizableProperties(map);
        if (this._localizablePrompts == null) {
            this.setPromptsForLocalization(localizablePrompts);
        }
    }

    public void beginLocalization() throws UnexpectedLocalizationException {
        this._localizablePrompts = this.getPromptsForLocalization();
    }

    public void endLocalization() throws UnexpectedLocalizationException {
        if (this._localizablePrompts != null) {
            this.setPromptsForLocalization(this._localizablePrompts);
            this._localizablePrompts = null;
        }
    }

    public Collection<Locale> getLocales() throws UnexpectedLocalizationException {
        MultiLocaleProperties localizablePrompts = this._localizablePrompts;
        if (localizablePrompts == null && (localizablePrompts = this.getPromptsForLocalization()) == null) {
            return null;
        }
        return localizablePrompts.getLocales();
    }

    public PropertyList getLocalizableProperties(Locale locale) throws UnexpectedLocalizationException {
        if (this._localizablePrompts != null) {
            return this._localizablePrompts.getLocalizableProperties(locale);
        }
        if (this._promptDef != null) {
            return this.getPromptsForLocalization().getLocalizableProperties(locale);
        }
        return null;
    }

    public void setLocalizableProperties(Locale locale, PropertyMap map) throws UnexpectedLocalizationException {
        MultiLocaleProperties localizablePrompts = this._localizablePrompts;
        if (localizablePrompts == null && (localizablePrompts = this.getPromptsForLocalization()) == null) {
            return;
        }
        localizablePrompts.setLocalizableProperties(locale, map);
        if (this._localizablePrompts == null) {
            this.setPromptsForLocalization(localizablePrompts);
        }
    }

    private MultiLocaleProperties getPromptsForLocalization() throws UnexpectedLocalizationException {
        MultiLocaleProperties localizablePrompts = null;
        if (this._promptDef != null) {
            PromptsReadingContext readingContext = PersistenceFactory.newReadingContext(null);
            StringReader reader = new StringReader(this._promptDef);
            try {
                localizablePrompts = (MultiLocaleProperties)PromptUtil.newObjectFromXML((Reader)reader, null, (PromptsReadingContext)readingContext);
            }
            catch (SAXException e) {
                throw new UnexpectedLocalizationException((Throwable)e);
            }
            catch (IOException e) {
                throw new UnexpectedLocalizationException((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new UnexpectedLocalizationException((Throwable)e);
            }
        }
        return localizablePrompts;
    }

    private void setPromptsForLocalization(MultiLocaleProperties localizedPrompts) throws UnexpectedLocalizationException {
        try {
            this._promptDef = XmlUtil.promptModelToPrettyString((PersistenceInterface)((PersistenceInterface)localizedPrompts));
        }
        catch (ParserConfigurationException e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
        catch (BackingStoreException e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
    }

    class NamespaceFilter
    extends XMLFilterImpl {
        String _namespace;

        public NamespaceFilter(String targetNamespace) throws SAXException {
            this._namespace = targetNamespace;
            XMLReader reader = XMLReaderFactory.createXMLReader();
            this.setParent(reader);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            int i = atts.getIndex("xmlns");
            if (i >= 0) {
                AttributesImpl newAtts = new AttributesImpl(atts);
                newAtts.removeAttribute(i);
                atts = newAtts;
            }
            super.startElement(this._namespace, localName, localName, atts);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(this._namespace, localName, localName);
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            super.startPrefixMapping(prefix, this._namespace);
        }
    }
}

