/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.appmeta;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.tools.appmeta.AppMetaException;
import com.sas.metadata.tools.appmeta.ApplicationMetadataUtility2;
import com.sas.metadata.tools.appmeta.Capability2;
import com.sas.metadata.tools.appmeta.CapabilityCategory2;
import com.sas.metadata.tools.appmeta.ConfigurableObject2;
import com.sas.metadata.tools.appmeta.Configuration2;
import com.sas.metadata.tools.appmeta.Directives2;
import com.sas.metadata.tools.appmeta.RB;
import com.sas.metadata.tools.appmeta.Services2;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIServer;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.text.Message;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.ParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class Application2
extends ConfigurableObject2
implements MultiLocaleProperties {
    private String _productName = null;
    private String _classIdentifier = null;
    private int _major = -1;
    private int _minor = -1;
    private String _platform = null;
    private String _productIdentifier = null;
    private String _softwareVersion = null;
    private String _specVendor = null;
    private String _specVersion = null;
    private String _vendor = null;
    private String _vendorIdentifier = null;
    private String _associatedApplication = null;
    private String _isDefaultInstance = null;
    private String _isGridCapable = null;
    private String _isSoap = null;
    private String _uriProtocol = null;
    private String _uriHost = null;
    private int _uriPort = 0;
    private String _uriService = null;
    private String _folder = null;
    private String _parentComponent = null;
    private CapabilityCategory2 _rootCategory = null;
    private Directives2 _directives = null;
    private Services2 _services = null;
    private Map<String, Capability2> _capabilities = new HashMap<String, Capability2>();

    private Application2(ApplicationMetadataUtility2 context) {
        super(context);
    }

    CapabilityCategory2 getCapabilityCategories() {
        return this._rootCategory;
    }

    Capability2 getCapability(String id) {
        return this._capabilities.get(id);
    }

    Directives2 getDirectives() {
        return this._directives;
    }

    static Application2 create(ApplicationMetadataUtility2 context) {
        Application2 app = new Application2(context);
        return app;
    }

    String getProductName() {
        return this._productName;
    }

    void loadFromXML(Element xml) throws AppMetaException {
        String minorVersion;
        String majorVersion;
        if (xml.hasAttribute("Name")) {
            this._name = xml.getAttribute("Name");
        }
        if (xml.hasAttribute("ProductName")) {
            this._productName = xml.getAttribute("ProductName");
        }
        if (xml.hasAttribute("ClassIdentifier")) {
            this._classIdentifier = xml.getAttribute("ClassIdentifier");
        }
        if (xml.hasAttribute("Desc")) {
            this._desc = xml.getAttribute("Desc");
        }
        if (xml.hasAttribute("Major") && (majorVersion = xml.getAttribute("Major")).length() > 0) {
            this._major = Integer.parseInt(majorVersion);
        }
        if (xml.hasAttribute("Minor") && (minorVersion = xml.getAttribute("Minor")).length() > 0) {
            this._minor = Integer.parseInt(minorVersion);
        }
        if (xml.hasAttribute("Platform")) {
            this._platform = xml.getAttribute("Platform");
        }
        if (xml.hasAttribute("ProductIdentifier")) {
            this._productIdentifier = xml.getAttribute("ProductIdentifier");
        }
        if (xml.hasAttribute("SoftwareVersion")) {
            this._softwareVersion = xml.getAttribute("SoftwareVersion");
        }
        if (xml.hasAttribute("SpecVendor")) {
            this._specVendor = xml.getAttribute("SpecVendor");
        }
        if (xml.hasAttribute("SpecVersion")) {
            this._specVersion = xml.getAttribute("SpecVersion");
        }
        if (xml.hasAttribute("Vendor")) {
            this._vendor = xml.getAttribute("Vendor");
        }
        if (xml.hasAttribute("VendorIdentifier")) {
            this._vendorIdentifier = xml.getAttribute("VendorIdentifier");
        }
        if (xml.hasAttribute("AssociatedApplication")) {
            this._associatedApplication = xml.getAttribute("AssociatedApplication");
        }
        if (xml.hasAttribute("IsDefaultInstance")) {
            this._isDefaultInstance = xml.getAttribute("IsDefaultInstance");
        }
        if (xml.hasAttribute("IsGridCapable")) {
            this._isGridCapable = xml.getAttribute("IsGridCapable");
        }
        if (xml.hasAttribute("IsSoap")) {
            this._isSoap = xml.getAttribute("IsSoap");
            this._context.getLogger().warn("IsSoap attribute on Application2 objects is deprecated.  Use ServiceType attribute on Service objects instead.");
            this._context.declareWarning();
        }
        if (xml.hasAttribute("Folder")) {
            this._folder = xml.getAttribute("Folder");
        }
        if (xml.hasAttribute("ParentComponent")) {
            this._parentComponent = xml.getAttribute("ParentComponent");
        }
        if (this._name == null || this._name.length() == 0) {
            this._name = this._productName;
        }
        NodeList nodes = xml.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String tagName = element.getTagName();
            if (tagName.equals("Capabilities")) {
                this._rootCategory = CapabilityCategory2.create(this, null);
                this._rootCategory.loadFromXML(element);
                continue;
            }
            if (tagName.equals("Directives2")) {
                this._directives = Directives2.create(this);
                this._directives.loadFromXML(element);
                continue;
            }
            if (tagName.equals("Configuration2")) {
                this._configuration = Configuration2.create(this);
                this._configuration.loadFromXML(element);
                continue;
            }
            if (tagName.equals("ApplicationUri")) {
                this._uriProtocol = element.getAttribute("Protocol");
                this._uriHost = element.getAttribute("Host");
                String port = element.getAttribute("Port");
                if (port.length() > 0) {
                    this._uriPort = Integer.parseInt(port);
                }
                this._uriService = element.getAttribute("Service");
                if (!this._uriService.startsWith("//")) continue;
                this._context.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"Application.TrimServiceValue.fmt.log", (Object)this._uriService));
                this._context.declareWarning();
                this._uriService = this._uriService.substring(1);
                continue;
            }
            if (!tagName.equals("Services2")) continue;
            this._services = Services2.create(this);
            this._services.loadFromXML(element);
        }
    }

    boolean addCapability(Capability2 capability) {
        if (this._capabilities.containsKey(capability.getId())) {
            return false;
        }
        this._capabilities.put(capability.getId(), capability);
        return true;
    }

    void createNewApplication(OMIServer server) throws MdException, ParseException, AppMetaException, ServiceException, IllegalStateException, RemoteException {
        MdObjectStore store = server.getObjectStore();
        MdOMIUtil omiUtil = store.getFactory().getOMIUtil();
        if (this._context.getApplicationName() != null) {
            this._name = this._context.getApplicationName();
        }
        if (this._context.getFolder() != null) {
            this._folder = this._context.getFolder();
        }
        if (this._folder == null || this._folder.length() == 0) {
            throw new AppMetaException(RB.getStringResource("Application.NoFolder.log"));
        }
        List objects = omiUtil.getMetadataObjectsSubset((MdStore)store, omiUtil.getFoundationReposID(), "SoftwareComponent", 8584, "<XMLSelect search=\"SoftwareComponent[@Name='" + this._name + "' and @PublicType='Application2']\"/>");
        if (objects.size() >= 1) {
            this._context.declareError(9);
            throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"Application.ApplicationAlreadyExists.fmt.log", (Object)this._name));
        }
        SoftwareComponent jomaObject = (SoftwareComponent)store.getFactory().createComplexMetadataObject(store, this._name, "SoftwareComponent", omiUtil.getFoundationReposID().substring(9));
        jomaObject.setPublicType("Application");
        jomaObject.setUsageVersion(1000000.0);
        if (this._classIdentifier != null) {
            jomaObject.setClassIdentifier(this._classIdentifier);
        }
        if (this._desc != null) {
            jomaObject.setDesc(this._desc);
        }
        if (this._major >= 0) {
            jomaObject.setMajor(this._major);
        }
        if (this._minor >= 0) {
            jomaObject.setMinor(this._minor);
        }
        if (this._platform != null) {
            jomaObject.setPlatform(this._platform);
        }
        if (this._productIdentifier != null) {
            jomaObject.setProductIdentifier(this._productIdentifier);
        }
        if (this._productName != null) {
            jomaObject.setProductName(this._productName);
        }
        if (this._softwareVersion != null) {
            jomaObject.setSoftwareVersion(this._softwareVersion);
        }
        if (this._specVendor != null) {
            jomaObject.setSpecVendor(this._specVendor);
        }
        if (this._specVersion != null) {
            jomaObject.setSpecVersion(this._specVersion);
        }
        if (this._vendor != null) {
            jomaObject.setVendor(this._vendor);
        }
        if (this._vendorIdentifier != null) {
            jomaObject.setVendorIdentifier(this._vendorIdentifier);
        }
        this.makeApplicationProperty(store, omiUtil, jomaObject, "AssociatedApplication", this._associatedApplication, "");
        this.makeApplicationProperty(store, omiUtil, jomaObject, "IsDefaultInstance", this._isDefaultInstance, "false");
        this.makeApplicationProperty(store, omiUtil, jomaObject, "IsGridCapable", this._isGridCapable, "false");
        this.makeApplicationProperty(store, omiUtil, jomaObject, "IsSoap", this._isSoap, "false");
        this.makeApplicationUri(store, omiUtil, jomaObject);
        this.setParentComponent(store, omiUtil, jomaObject);
        this._jomaObject = jomaObject;
        this._context.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"Application.CreatingApplication.fmt.log", (Object)this._productName));
        this.setParentFolder(server, jomaObject);
        this.mergeComponents();
    }

    void updateExistingApplication(OMIServer server) throws RemoteException, MdException, ParseException, AppMetaException, ServiceException, IllegalStateException {
        SoftwareComponent jomaObject;
        MdObjectStore store = server.getObjectStore();
        MdOMIUtil omiUtil = store.getFactory().getOMIUtil();
        try {
            jomaObject = (SoftwareComponent)omiUtil.getMetadataAllDepths((MdStore)store, "SoftwareComponent", this._context.getApplicationId(), null, null, null, 8);
        }
        catch (MdException e) {
            this._context.declareError(10);
            throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"Application.ApplicationNotFound.fmt.log", (Object)this._context.getApplicationId()), e);
        }
        if (jomaObject == null) {
            this._context.declareError(10);
            throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"Application.ApplicationNotFound.fmt.log", (Object)this._context.getApplicationId()));
        }
        this._name = this._context.getApplicationName() != null ? this._context.getApplicationName() : null;
        this._folder = this._context.getFolder() != null ? this._context.getFolder() : null;
        jomaObject.setPublicType("Application");
        jomaObject.setUsageVersion(1000000.0);
        if (this._name != null && !jomaObject.getName().equals(this._name)) {
            jomaObject.setName(this._name);
        }
        if (this._classIdentifier != null && !jomaObject.getClassIdentifier().equals(this._classIdentifier)) {
            jomaObject.setClassIdentifier(this._classIdentifier);
        }
        if (this._desc != null && !jomaObject.getDesc().equals(this._desc)) {
            jomaObject.setDesc(this._desc);
        }
        if (this._major >= 0 && jomaObject.getMajor() != this._major) {
            jomaObject.setMajor(this._major);
        }
        if (this._minor >= 0 && jomaObject.getMinor() != this._minor) {
            jomaObject.setMinor(this._minor);
        }
        if (this._platform != null && !jomaObject.getPlatform().equals(this._platform)) {
            jomaObject.setPlatform(this._platform);
        }
        if (this._productIdentifier != null && !jomaObject.getProductIdentifier().equals(this._productIdentifier)) {
            jomaObject.setProductIdentifier(this._productIdentifier);
        }
        if (this._productName != null && !jomaObject.getProductName().equals(this._productName)) {
            jomaObject.setProductName(this._productName);
        }
        if (this._softwareVersion != null && !jomaObject.getSoftwareVersion().equals(this._softwareVersion)) {
            jomaObject.setSoftwareVersion(this._softwareVersion);
        }
        if (this._specVendor != null && !jomaObject.getSpecVendor().equals(this._specVendor)) {
            jomaObject.setSpecVendor(this._specVendor);
        }
        if (this._specVersion != null && !jomaObject.getSpecVersion().equals(this._specVersion)) {
            jomaObject.setSpecVersion(this._specVersion);
        }
        if (this._vendor != null && !jomaObject.getVendor().equals(this._vendor)) {
            jomaObject.setVendor(this._vendor);
        }
        if (this._vendorIdentifier != null && !jomaObject.getVendorIdentifier().equals(this._vendorIdentifier)) {
            jomaObject.setVendorIdentifier(this._vendorIdentifier);
        }
        this.makeApplicationProperty(store, omiUtil, jomaObject, "AssociatedApplication", this._associatedApplication, "");
        this.makeApplicationProperty(store, omiUtil, jomaObject, "IsDefaultInstance", this._isDefaultInstance, "false");
        this.makeApplicationProperty(store, omiUtil, jomaObject, "IsGridCapable", this._isGridCapable, "false");
        this.makeApplicationProperty(store, omiUtil, jomaObject, "IsSoap", this._isSoap, "false");
        this.makeApplicationUri(store, omiUtil, jomaObject);
        this.setParentComponent(store, omiUtil, jomaObject);
        this._jomaObject = jomaObject;
        this._context.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"Application.UpdatingApplication.fmt.log", (Object)this._productName));
        this.setParentFolder(server, jomaObject);
        this.mergeComponents();
    }

    private void setParentComponent(MdObjectStore store, MdOMIUtil omiUtil, SoftwareComponent object) throws RemoteException, MdException {
        if (this._parentComponent == null || this._parentComponent.length() == 0) {
            return;
        }
        List components = omiUtil.getMetadataObjectsSubset((MdStore)store, omiUtil.getFoundationReposID(), "SoftwareComponent", 8584, "<XMLSelect search=\"SoftwareComponent[@Name='" + this._parentComponent + "' and @PublicType='Application2']\"/>");
        if (components.size() > 1) {
            this._context.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"Application.MultipleParentComponents.fmt.log", (Object)this._parentComponent));
            this._context.declareWarning();
        } else if (components.size() == 0) {
            this._context.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"Application.MissingParentComponent.fmt.log", (Object)this._parentComponent));
            this._context.declareWarning();
        } else {
            SoftwareComponent parentComp = (SoftwareComponent)components.get(0);
            object.getImplementedObjects().set(0, (Object)parentComp);
        }
    }

    private void makeApplicationProperty(MdObjectStore store, MdOMIUtil omiUtil, SoftwareComponent object, String propertyName, String propertyValue, String defaultValue) throws RemoteException, MdException {
        AssociationList properties = object.getProperties();
        for (Object item : properties) {
            Property property = (Property)item;
            if (!property.getName().equalsIgnoreCase(propertyName)) continue;
            property.delete();
            break;
        }
        if (propertyValue != null && !propertyValue.equalsIgnoreCase(defaultValue)) {
            Property applicationProperty = (Property)store.getFactory().createComplexMetadataObject(store, propertyName, "Property", omiUtil.getFoundationReposID().substring(9));
            applicationProperty.setAssociatedObject((Root)object);
            applicationProperty.setPropertyName(propertyName);
            applicationProperty.setSQLType(12);
            applicationProperty.setDefaultValue(propertyValue);
        }
    }

    private void makeApplicationUri(MdObjectStore store, MdOMIUtil omiUtil, SoftwareComponent object) throws RemoteException, MdException {
        if (this._uriProtocol == null && this._uriHost == null && this._uriService == null) {
            return;
        }
        AssociationList deployedComponents = object.getDeployedComponents();
        for (Object item : deployedComponents) {
            DeployedComponent component;
            if (!(item instanceof DeployedComponent) || !(component = (DeployedComponent)item).getName().equals("Registered SAS Application2")) continue;
            component.delete();
            break;
        }
        DeployedComponent regSASApp = (DeployedComponent)store.getFactory().createComplexMetadataObject(store, "Registered SAS Application2", "DeployedComponent", omiUtil.getFoundationReposID().substring(9));
        regSASApp.setDescriptiveComponent(object);
        TCPIPConnection tcp = (TCPIPConnection)store.getFactory().createComplexMetadataObject(store, "Connection URI", "TCPIPConnection", omiUtil.getFoundationReposID().substring(9));
        tcp.setSource(regSASApp);
        if (this._uriProtocol != null) {
            tcp.setCommunicationProtocol(this._uriProtocol);
        }
        if (this._uriHost != null) {
            tcp.setHostName(this._uriHost);
        }
        tcp.setPort(this._uriPort);
        if (this._uriService != null) {
            tcp.setService(this._uriService);
        }
    }

    void setParentFolder(OMIServer server, SoftwareComponent object) throws RemoteException, MdException, AppMetaException {
        if (this._folder == null || this._folder.length() == 0) {
            return;
        }
        try {
            FolderInterface folder;
            Tree newFolderObject;
            AssociationList oldTrees = this._jomaObject.getTrees();
            Tree oldFolderObject = null;
            if (oldTrees.size() > 0) {
                oldFolderObject = (Tree)oldTrees.get(0);
            }
            if ((newFolderObject = (Tree)(folder = this._context.makeFolder(server, this._folder)).getRepositoryEntity()) != oldFolderObject) {
                this._jomaObject.getTrees().set(0, (Object)newFolderObject);
                this._context.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"Application.MovingApplication.fmt.log", (Object)this._folder));
            } else {
                this._context.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"Application.InFolder.fmt.log", (Object)this._folder));
            }
        }
        catch (ServiceException e) {
            throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"Application.FolderCreateError.fmt.log", (Object)this._folder), e);
        }
    }

    private void mergeComponents() throws MdException {
        if (this._rootCategory != null) {
            this._rootCategory.mergeToMetadata();
        }
        if (this._directives != null) {
            this._directives.mergeToMetadata();
        }
        if (this._configuration != null) {
            this._configuration.mergeToMetadata();
        }
        if (this._services != null) {
            this._services.mergeToMetadata();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void loadFromMetadata(OMIServer server) throws MdException, MissingOptionException, AppMetaException, ServiceException, IllegalStateException {
        MdObjectStore store = server.getObjectStore();
        SoftwareComponent sc = null;
        try {
            AssociationList implObjects;
            MdOMIUtil omiUtil = store.getFactory().getOMIUtil();
            String id = this._context.getApplicationId();
            String name = this._context.getApplicationName();
            if (id != null && id.length() > 0) {
                sc = (SoftwareComponent)omiUtil.getMetadataAllDepths((MdStore)store, "SoftwareComponent", id, null, null, null, 8);
                if (sc == null) {
                    throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"Application.ApplicationNotFound.fmt.log", (Object)id));
                }
            } else {
                if (name == null || name.length() <= 0) throw new MissingOptionException("You must identify the application with the -applicationId or -applicationName option.");
                List objects = omiUtil.getMetadataObjectsSubset((MdStore)store, omiUtil.getFoundationReposID(), "SoftwareComponent", 8584, "<XMLSelect search=\"SoftwareComponent[@Name='" + name + "' and @PublicType='Application2']\"/>");
                if (objects.size() < 1) throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"Application.ApplicationNotFound.fmt.log", (Object)name));
                sc = (SoftwareComponent)objects.get(0);
            }
            this._jomaObject = sc;
            this._name = sc.getName();
            this._classIdentifier = sc.getClassIdentifier();
            this._desc = sc.getDesc();
            this._major = sc.getMajor();
            this._minor = sc.getMinor();
            this._platform = sc.getPlatform();
            this._productIdentifier = sc.getProductIdentifier();
            this._productName = sc.getProductName();
            this._softwareVersion = sc.getSoftwareVersion();
            this._specVendor = sc.getSpecVendor();
            this._specVersion = sc.getSpecVersion();
            this._vendor = sc.getVendor();
            this._vendorIdentifier = sc.getVendorIdentifier();
            for (Object item : sc.getProperties()) {
                Property property = (Property)item;
                if (property.getPropertyName().equalsIgnoreCase("AssociatedApplication")) {
                    this._associatedApplication = property.getDefaultValue();
                    continue;
                }
                if (property.getPropertyName().equalsIgnoreCase("IsDefaultInstance")) {
                    this._isDefaultInstance = property.getDefaultValue();
                    continue;
                }
                if (property.getPropertyName().equalsIgnoreCase("IsGridCapable")) {
                    this._isGridCapable = property.getDefaultValue();
                    continue;
                }
                if (!property.getPropertyName().equalsIgnoreCase("IsSoap")) continue;
                this._isSoap = property.getDefaultValue();
            }
            block5: for (Object item : sc.getDeployedComponents()) {
                DeployedComponent comp;
                if (!(item instanceof DeployedComponent) || !(comp = (DeployedComponent)item).getName().equals("Registered SAS Application2")) continue;
                for (Object conn : comp.getSourceConnections()) {
                    TCPIPConnection tcp;
                    if (!(conn instanceof TCPIPConnection) || !(tcp = (TCPIPConnection)conn).getName().equals("Connection URI")) continue;
                    this._uriProtocol = tcp.getCommunicationProtocol();
                    this._uriHost = tcp.getHostName();
                    this._uriPort = tcp.getPort();
                    this._uriService = tcp.getService();
                    break block5;
                }
            }
            if (!sc.getTrees().isEmpty()) {
                Tree folderObject = (Tree)sc.getTrees().get(0);
                FolderInterface folder = (FolderInterface)server.factoryProcess((Object)folderObject);
                this._folder = folder.getPathUrl().getDisplayPath();
            }
            if ((implObjects = sc.getImplementedObjects()).size() == 1) {
                try {
                    this._parentComponent = ((SoftwareComponent)implObjects.get(0)).getName();
                }
                catch (ClassCastException e) {
                    this._context.getLogger().warn("ImplementedObjects association object is not a SoftwareComponent.  Unable to extract ParentComponent.");
                    this._context.declareWarning();
                }
            } else if (implObjects.size() > 1) {
                this._context.getLogger().warn("Multiple ImplementedObjects association objects.  Unable to extract ParentComponent.");
                this._context.declareWarning();
            }
            Element app = this._context._sourceDocument.createElement("Application");
            if (this._name != null) {
                app.setAttribute("Name", this._name);
            }
            if (this._productName != null) {
                app.setAttribute("ProductName", this._productName);
            }
            if (this._classIdentifier != null) {
                app.setAttribute("ClassIdentifier", this._classIdentifier);
            }
            if (this._desc != null) {
                app.setAttribute("Desc", this._desc);
            }
            if (this._major >= 0) {
                app.setAttribute("Major", Integer.toString(this._major));
            }
            if (this._minor >= 0) {
                app.setAttribute("Minor", Integer.toString(this._minor));
            }
            if (this._platform != null) {
                app.setAttribute("Platform", this._platform);
            }
            if (this._productIdentifier != null) {
                app.setAttribute("ProductIdentifier", this._productIdentifier);
            }
            if (this._softwareVersion != null) {
                app.setAttribute("SoftwareVersion", this._softwareVersion);
            }
            if (this._specVendor != null) {
                app.setAttribute("SpecVendor", this._specVendor);
            }
            if (this._specVersion != null) {
                app.setAttribute("SpecVersion", this._specVersion);
            }
            if (this._vendor != null) {
                app.setAttribute("Vendor", this._vendor);
            }
            if (this._vendorIdentifier != null) {
                app.setAttribute("VendorIdentifier", this._vendorIdentifier);
            }
            if (this._associatedApplication != null) {
                app.setAttribute("AssociatedApplication", this._associatedApplication);
            }
            if (this._isDefaultInstance != null) {
                app.setAttribute("IsDefaultInstance", this._isDefaultInstance);
            }
            if (this._isGridCapable != null) {
                app.setAttribute("IsGridCapable", this._isGridCapable);
            }
            if (this._isSoap != null) {
                this._context.getLogger().warn("IsSoap attribute on Application2 objects is deprecated and will be ignored.");
                this._context.declareWarning();
            }
            if (this._folder != null && this._folder.length() > 0) {
                app.setAttribute("Folder", this._folder);
            }
            if (this._parentComponent != null && this._parentComponent.length() > 0) {
                app.setAttribute("ParentComponent", this._parentComponent);
            }
            app.getOwnerDocument().getLastChild().appendChild(app);
            if (this._uriProtocol != null || this._uriHost != null || this._uriService != null) {
                Element appUri = this._context._sourceDocument.createElement("ApplicationUri");
                if (this._uriProtocol != null) {
                    appUri.setAttribute("Protocol", this._uriProtocol);
                }
                if (this._uriHost != null) {
                    appUri.setAttribute("Host", this._uriHost);
                }
                if (this._uriPort > 0) {
                    appUri.setAttribute("Port", Integer.toString(this._uriPort));
                }
                if (this._uriService != null) {
                    appUri.setAttribute("Service", this._uriService);
                }
                app.appendChild(appUri);
            }
            for (Object item : ((SoftwareComponent)this._jomaObject).getSoftwareTrees()) {
                Tree tree = (Tree)item;
                if (tree.getName().equals("ApplicationActions") && this._rootCategory == null) {
                    this._rootCategory = CapabilityCategory2.create(this, null);
                    this._rootCategory.loadFromMetadata(tree, app);
                    continue;
                }
                if (!tree.getName().equals("Directives2") || this._directives != null) continue;
                this._directives = Directives2.create(this);
                this._directives.loadFromMetadata(tree, app);
            }
            for (Object item : this._jomaObject.getPropertySets()) {
                PropertySet set = (PropertySet)item;
                if (!set.getName().equals("Application Configuration2")) continue;
                this._configuration = Configuration2.create(this);
                this._configuration.loadFromMetadata(set, app);
                break;
            }
            this._services = Services2.create(this);
            this._services.loadFromMetadata(sc, app);
            return;
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    void removeAllCapabilities() {
        this._rootCategory = null;
    }

    void removeCapabilities(Capability2 capability) {
        this._capabilities.remove(capability.getId());
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        list.addProperty("Desc", this._desc);
        if (this._rootCategory != null) {
            list.addProperty("Capabilities", this._rootCategory.getLocalizableProperties());
        }
        PropertyList capList = new PropertyList();
        ArrayList<String> capabilities = new ArrayList<String>(this._capabilities.keySet().size());
        capabilities.addAll(this._capabilities.keySet());
        Collections.sort(capabilities);
        for (String capabilityId : capabilities) {
            capList.addProperty(capabilityId, this._capabilities.get(capabilityId).getLocalizableProperties());
        }
        list.addProperty("Capability", capList);
        if (this._directives != null) {
            list.addProperty("Directives2", this._directives.getLocalizableProperties());
        }
        if (this._configuration != null) {
            list.addProperty("Configuration2", this._configuration.getLocalizableProperties());
        }
        if (this._services != null) {
            list.addProperty("Services2", this._services.getLocalizableProperties());
        }
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        PropertyMap capsMap;
        if (map.containsProperty("Desc")) {
            this._desc = map.getProperty("Desc");
        }
        if (this._rootCategory != null && map.containsNestedProperty("Capabilities")) {
            this._rootCategory.setLocalizableProperties(map.getNestedProperties("Capabilities"));
        }
        if ((capsMap = map.getNestedProperties("Capability")) != null) {
            for (String capabilityId : this._capabilities.keySet()) {
                PropertyMap capMap = capsMap.getNestedProperties(capabilityId);
                if (capMap == null) continue;
                this._capabilities.get(capabilityId).setLocalizableProperties(capMap);
            }
        }
        if (this._directives != null && map.containsNestedProperty("Directives")) {
            this._directives.setLocalizableProperties(map.getNestedProperties("Directives"));
        }
        if (this._configuration != null && map.containsNestedProperty("Configuration")) {
            this._configuration.setLocalizableProperties(map.getNestedProperties("Configuration"));
        }
        if (this._services != null && map.containsNestedProperty("Services")) {
            this._services.setLocalizableProperties(map.getNestedProperties("Services"));
        }
    }

    public void beginLocalization() throws UnexpectedLocalizationException {
        if (this._configuration != null) {
            this._configuration.beginLocalization();
        }
    }

    public void endLocalization() throws UnexpectedLocalizationException {
        if (this._configuration != null) {
            this._configuration.endLocalization();
        }
    }

    public Collection<Locale> getLocales() throws UnexpectedLocalizationException {
        if (this._configuration != null) {
            return this._configuration.getLocales();
        }
        return null;
    }

    public PropertyList getLocalizableProperties(Locale locale) throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        if (this._configuration != null) {
            list.addProperty("Configuration2", this._configuration.getLocalizableProperties(locale));
        }
        return list;
    }

    public void setLocalizableProperties(Locale locale, PropertyMap map) throws UnexpectedLocalizationException {
        if (this._configuration != null && map.containsNestedProperty("Configuration2")) {
            this._configuration.setLocalizableProperties(locale, map.getNestedProperties("Configuration2"));
        }
    }
}

