/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals.search;

import com.sas.metadata.logical.visuals.search.RB;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchFactory;
import com.sas.services.information.search.SearchFolder;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.visuals.WAGeneralPanel;
import java.awt.Dimension;
import java.awt.Frame;
import java.rmi.RemoteException;

public class SaveSearchDialog
extends WAPropertyDialog {
    private static final long serialVersionUID = 1L;
    private WAGeneralPanel m_generalPanel;
    private FolderInterface m_folder;
    private Search m_search;
    private String m_searchName = null;
    private String m_searchDesc = null;
    private FolderInterface m_saveToFolder = null;
    Tree owningTree = null;
    ChildServerInterface csi = null;

    public SaveSearchDialog(Frame frm, Search searchObj, FolderInterface folder) {
        super(frm, true);
        this.m_folder = folder;
        this.m_search = searchObj;
        this.setTitle(RB.getStringResource("SaveSearchDialog.title.txt"));
        this.initialize();
    }

    protected void initialize() {
        super.initialize();
        this.m_generalPanel = new WAGeneralPanel(null, null, false, false, false, true);
        this.m_generalPanel.setPreferredSize(new Dimension(400, 200));
        this.m_generalPanel.enableNameValidation(true);
        this.m_generalPanel.setHelpProduct("searchview");
        this.m_generalPanel.setHelpTopic("save");
        this.setMainPanel((WAPanel)this.m_generalPanel);
        this.setResizable(true);
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        try {
            if (!bSaveToModel) {
                this.m_generalPanel.moveDataToView();
                String sName = WsMetadataNameUtil.getUniqueNameForType((String)"Search", (String)RB.getStringResource("SaveSearchDialog.StartsWithDefaultName.txt"));
                this.m_generalPanel.setNameField(sName);
                if (this.m_folder != null) {
                    Tree treeFolder = (Tree)this.m_folder.getRepositoryEntity();
                    this.m_generalPanel.setOwningTree(treeFolder);
                }
                return true;
            }
            return this.createSearchFolder();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (ServiceException se) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)se);
        }
        return false;
    }

    public boolean validateData() {
        boolean state = this.m_generalPanel.validateData();
        if (!state) {
            return state;
        }
        this.owningTree = this.m_generalPanel.getOwningTree();
        if (this.owningTree == null) {
            MessageUtil.displayMessage((String)RB.getStringResource("SaveSearchDialog.NoFolderSelected.txt"), (int)0);
            return false;
        }
        this.m_searchName = this.m_generalPanel.getNameComponent().getText();
        boolean bIsUniqueName = WsMetadataNameUtil.isNameUniqueInFolder((String)this.m_generalPanel.getNameComponent().getText(), (Tree)this.owningTree, (String)"SearchFolder");
        if (!bIsUniqueName) {
            MessageUtil.displayMessage((String)RB.getStringResource("SaveSearchDialog.DuplicateSearchFound.txt"), (int)0);
            return false;
        }
        this.m_searchDesc = this.m_generalPanel.getDescriptionComponent().getText();
        return true;
    }

    private boolean createSearchFolder() throws ServiceException, RemoteException {
        UserContextInterface user = Workspace.getWorkspace().getUserContext();
        this.csi = user.getAuthServer().newChild(true);
        String key = this.owningTree.getFQID() + "/" + "Tree";
        this.m_saveToFolder = (FolderInterface)this.csi.fetch(key);
        if (this.m_saveToFolder == null) {
            MessageUtil.displayMessage((String)"SaveSearchDialog.FolderMissing.txt", (int)0);
            try {
                this.csi.rollback();
            }
            catch (ServiceException e1) {
                e1.printStackTrace();
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        SearchFolder searchFolderObj = SearchFactory.createSearchFolder((String)this.m_searchName, (FolderInterface)this.m_saveToFolder, (Search)this.m_search);
        if (this.m_searchDesc != null) {
            searchFolderObj.setDescription(this.m_searchDesc);
        }
        searchFolderObj.update();
        try {
            this.csi.commit();
        }
        catch (Exception e) {
            try {
                this.csi.rollback();
            }
            catch (ServiceException e1) {
                e1.printStackTrace();
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
        }
        return true;
    }
}

