/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals.search;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.visuals.search.AbstractFilterComponent;
import com.sas.metadata.logical.visuals.search.RB;
import com.sas.nls.collator.SASCollatorFactory;
import com.sas.nls.collator.SASStringComparator;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.services.information.search.PublicTypeFilter;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchFilter;
import com.sas.swing.visuals.CheckBoxTree;
import com.sas.swing.visuals.CheckBoxTreeCellRendererWrapper;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.Resources;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PublicTypeFilterComponent
extends AbstractFilterComponent
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Insets BUTTON_MARGIN = new Insets(2, 2, 2, 2);
    protected JScrollPane _treeScrollPane;
    protected CheckBoxTree _tree;
    protected JButton _selectAllButton;
    protected JButton _clearAllButton;
    protected List<String> _supportedTypes;
    protected boolean _scopeToFolders = false;
    protected boolean allTypesSelected = true;

    @Override
    protected void initialize() {
        super.initialize();
        this._tree = new CheckBoxTree();
        this._tree.setModel((TreeModel)new DefaultTreeModel(null));
        this._tree.setRootVisible(false);
        this._tree.setCellRenderer((TreeCellRenderer)new CheckBoxTreeCellRendererWrapper((TreeCellRenderer)new TreeNodeRenderer()));
        this._tree.setShowSelectionIcon(false);
        this._treeScrollPane = new JScrollPane((Component)this._tree);
        this._treeScrollPane.setPreferredSize(new Dimension(350, 100));
        this._selectAllButton = this.createSelectAllButton(new SelectAllAction());
        this._clearAllButton = this.createClearAllButton(new ClearAllAction());
    }

    @Override
    protected void layoutWidgets() {
        super.layoutWidgets();
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.add(this._selectAllButton);
        toolBar.addSeparator(new Dimension(0, 3));
        toolBar.add(this._clearAllButton);
        this.setLayout(new GridBagLayout());
        this.add((Component)toolBar, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._treeScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 5, 5, 3), 10, 10));
    }

    public JButton createSelectAllButton(WsAbstractAction action) {
        String name = RB.getStringResource("PublicTypeFilterComponent.SelectAll.Mnemonic.txt");
        ImageIcon selectIcon = Resources.getImageIcon(PublicTypeFilterComponent.class, (String)RB.getStringResource("PublicTypeFilterComponent.Select.Icon.image"));
        JButton selectAllButton = WsUIUtilities.createFlatTextIconButton((WsAbstractAction)action);
        PublicTypeFilterComponent.configureButton(selectAllButton, selectIcon, RB.getStringResource("PublicTypeFilterComponent.SelectAll.txt"), name);
        return selectAllButton;
    }

    public JButton createClearAllButton(WsAbstractAction action) {
        String name = RB.getStringResource("PublicTypeFilterComponent.ClearAll.Mnemonic.txt");
        ImageIcon clearIcon = Resources.getImageIcon(PublicTypeFilterComponent.class, (String)RB.getStringResource("PublicTypeFilterComponent.Clear.Icon.image"));
        JButton clearAllButton = WsUIUtilities.createFlatTextIconButton((WsAbstractAction)action);
        PublicTypeFilterComponent.configureButton(clearAllButton, clearIcon, RB.getStringResource("PublicTypeFilterComponent.ClearAll.txt"), name);
        return clearAllButton;
    }

    public static void configureButton(AbstractButton button, Icon icon, String tooltip, String name) {
        button.setIcon(icon);
        button.setFocusable(true);
        button.setMargin(BUTTON_MARGIN);
        if (tooltip != null && tooltip.length() > 0) {
            button.setToolTipText(tooltip);
        }
        if (name != null) {
            Util.configureMnemonicForButton((AbstractButton)button, (String)name);
        }
    }

    @Override
    public String getLabel() {
        return RB.getStringResource("PublicTypeFilterComponent.Label.txt");
    }

    @Override
    public void loadInitialData() throws ServiceException, RemoteException {
        if (this._scopeToFolders) {
            this.loadFolderTypes();
        } else {
            this.loadAllTypes();
        }
    }

    @Override
    public void setPreviousValues(SearchFilter filter) throws ServiceException, RemoteException {
        if (filter instanceof PublicTypeFilter) {
            List types = ((PublicTypeFilter)filter).getTypes();
            this.checkNodes(types);
        } else {
            this.resetValues();
        }
    }

    @Override
    public void resetValues() {
        PublicTypeFilterComponent.selectTreeNodes(this._tree);
    }

    @Override
    public SearchFilter createFilter() throws ServiceException, RemoteException {
        TreeNode root = (TreeNode)this._tree.getModel().getRoot();
        if (root == null) {
            return null;
        }
        int initialSize = root.getChildCount();
        ArrayList<String> types = null;
        Object[] selectedItems = this._tree.getCheckedObjects();
        int size = selectedItems.length;
        if (initialSize != size || this._supportedTypes != null) {
            types = new ArrayList<String>();
            for (int i = 0; i < size; ++i) {
                if (!(selectedItems[i] instanceof TypeNode)) continue;
                TypeNode node = (TypeNode)selectedItems[i];
                types.add(node.getTypeDescriptor().getTypeName());
            }
            if (types.size() == 0) {
                this.allTypesSelected = false;
                throw new ServiceException(RB.getStringResource("PublicTypeFilterComponent.NoTypes.txt"));
            }
        }
        if (types != null) {
            Factory factory = Factory.getInstance();
            MetadataServerInterface server = factory.getMetadataServerInterface();
            PublicTypeFilter filter = new PublicTypeFilter(types);
            filter.setServer((ServerInterface)server);
            return filter;
        }
        this.allTypesSelected = initialSize == size;
        return null;
    }

    public void configurePublicTypes(List<String> types) {
        this._supportedTypes = types;
    }

    private void checkNodes(List<String> types) throws ServiceException, RemoteException {
        if (types == null) {
            return;
        }
        TreeNode root = (TreeNode)this._tree.getModel().getRoot();
        Enumeration<? extends TreeNode> enumer = root.children();
        while (enumer.hasMoreElements()) {
            TypeNode node = (TypeNode)enumer.nextElement();
            Object[] nodePath = node.getPath();
            TreePath path = new TreePath(nodePath);
            if (this.isTypeSelected(types, node.getTypeDescriptor().getTypeName())) {
                this._tree.checkPath(path, true, true);
                continue;
            }
            this._tree.checkPath(path, false, true);
        }
    }

    private boolean isTypeSelected(List<String> types, String publicType) {
        if (publicType == null) {
            return false;
        }
        for (String type : types) {
            if (!publicType.equalsIgnoreCase(type)) continue;
            return true;
        }
        return false;
    }

    private void loadAllTypes() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        try {
            ArrayList<TypeDescriptorInterface> validTypes = new ArrayList<TypeDescriptorInterface>();
            Factory factory = Factory.getInstance();
            TypeInterface[] types = factory.getTypesSupported();
            int length = types.length;
            for (int index = 0; index < length; ++index) {
                String publicType = types[index].getPublicType();
                TypeDescriptorInterface tdi = factory.getTypeDescriptorFromTypeDictionary(publicType);
                String isSearchAllowed = tdi.getPropertyValue("IsSearchAllowed");
                if (isSearchAllowed != null && isSearchAllowed.equalsIgnoreCase("false") || this._supportedTypes != null && !this._supportedTypes.contains(publicType) || "RootFolder".equalsIgnoreCase(publicType)) continue;
                validTypes.add(tdi);
            }
            Collections.sort(validTypes, new TypesSorter());
            for (TypeDescriptorInterface tdi : validTypes) {
                TypeNode node = new TypeNode(tdi);
                rootNode.add(node);
            }
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)UtilMisc.getMessage(RB.getStringResource("PublicTypeFilterComponent.ErrorLoadingTypes.fmt"), e.getLocalizedMessage()), (int)0);
        }
        this._tree.setModel((TreeModel)new DefaultTreeModel(rootNode));
        PublicTypeFilterComponent.selectTreeNodes(this._tree);
    }

    private void loadFolderTypes() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        try {
            ArrayList<TypeDescriptorInterface> validTypes = new ArrayList<TypeDescriptorInterface>();
            Factory factory = Factory.getInstance();
            MetadataServerInterface server = factory.getMetadataServerInterface();
            TypeInterface[] types = factory.getTypesSupported();
            int length = types.length;
            for (int index = 0; index < length; ++index) {
                String publicType = types[index].getPublicType();
                TypeDescriptorInterface tdi = factory.getTypeDescriptorFromTypeDictionary(publicType);
                String isSearchAllowed = tdi.getPropertyValue("IsSearchAllowed");
                if (isSearchAllowed != null && isSearchAllowed.equalsIgnoreCase("false") || this._supportedTypes != null && !this._supportedTypes.contains(publicType) || "RootFolder".equalsIgnoreCase(publicType) || !SASFoldersUtil.isContainedByFolder((String)publicType, (ServerInterface)server) && !SASFoldersUtil.isContainedByVirtualFolder((String)publicType, (ServerInterface)server)) continue;
                validTypes.add(tdi);
            }
            Collections.sort(validTypes, new TypesSorter());
            for (TypeDescriptorInterface tdi : validTypes) {
                TypeNode node = new TypeNode(tdi);
                rootNode.add(node);
            }
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)UtilMisc.getMessage(RB.getStringResource("PublicTypeFilterComponent.ErrorLoadingTypes.fmt"), e.getLocalizedMessage()), (int)0);
        }
        this._tree.setModel((TreeModel)new DefaultTreeModel(rootNode));
        PublicTypeFilterComponent.selectTreeNodes(this._tree);
    }

    public static void selectTreeNodes(CheckBoxTree tree) {
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        if (model != null && model.getRoot() != null) {
            TreePath path = new TreePath(model.getRoot());
            tree.checkChildren(path, true, true);
        }
    }

    public static void clearTreeNodes(CheckBoxTree tree) {
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        if (model != null && model.getRoot() != null) {
            TreePath path = new TreePath(model.getRoot());
            tree.checkChildren(path, false, true);
        }
    }

    public void setTypeDimension(Dimension dimension) {
        this._treeScrollPane.setPreferredSize(dimension);
    }

    public void setTypeScopeToFolders(boolean scope) {
        this._scopeToFolders = scope;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase("scopeToFolder")) {
            Integer typeView = (Integer)evt.getNewValue();
            if (typeView == 1) {
                if (!this._scopeToFolders) {
                    SearchFilter ptf = this.createTemporaryTypesFilter();
                    this.loadFolderTypes();
                    if (ptf != null) {
                        try {
                            this.setPreviousValues(ptf);
                        }
                        catch (ServiceException e) {
                            e.printStackTrace();
                        }
                        catch (RemoteException e) {
                            e.printStackTrace();
                        }
                    } else if (!this.allTypesSelected) {
                        PublicTypeFilterComponent.clearTreeNodes(this._tree);
                    }
                }
                this.setTypeScopeToFolders(true);
            } else {
                if (this._scopeToFolders) {
                    SearchFilter ptf = this.createTemporaryTypesFilter();
                    this.loadAllTypes();
                    if (ptf != null) {
                        try {
                            this.setPreviousValues(ptf);
                        }
                        catch (ServiceException e) {
                            e.printStackTrace();
                        }
                        catch (RemoteException e) {
                            e.printStackTrace();
                        }
                    } else if (!this.allTypesSelected) {
                        PublicTypeFilterComponent.clearTreeNodes(this._tree);
                    }
                }
                this.setTypeScopeToFolders(false);
            }
        }
    }

    private SearchFilter createTemporaryTypesFilter() {
        SearchFilter typesFilter = null;
        try {
            typesFilter = this.createFilter();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return typesFilter;
    }

    @Override
    public void setPreviousValues(Search search) throws ServiceException, RemoteException {
        List filters = search.getFilters();
        if (filters == null) {
            return;
        }
        for (SearchFilter filter : filters) {
            if (!(filter instanceof PublicTypeFilter)) continue;
            this.setPreviousValues(filter);
            break;
        }
    }

    @Override
    public boolean isVerticallyResizable() {
        return true;
    }

    @Override
    public void setEditable(boolean bEditable) {
        if (this._tree != null) {
            this._tree.setEnabled(bEditable);
        }
        if (this._clearAllButton != null) {
            this._clearAllButton.setEnabled(bEditable);
        }
        if (this._selectAllButton != null) {
            this._selectAllButton.setEnabled(bEditable);
        }
    }

    class TreeNodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        TreeNodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            TypeDescriptorInterface tdi;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof TypeNode && (tdi = ((TypeNode)value).getTypeDescriptor()) != null) {
                Icon typeIcon = null;
                try {
                    typeIcon = tdi.getIcon();
                    if (typeIcon != null) {
                        this.setIcon(typeIcon);
                    } else {
                        this.setIcon(Resources.getImageIcon((String)RB.getStringResource("IMGS.GenericIcon.image"), (int)16));
                    }
                }
                catch (Exception e) {
                    this.setIcon(Resources.getImageIcon((String)RB.getStringResource("IMGS.GenericIcon.image"), (int)16));
                }
            }
            return this;
        }
    }

    class SelectAllAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        SelectAllAction() {
        }

        public void actionPerformed(ActionEvent e) {
            PublicTypeFilterComponent.selectTreeNodes(PublicTypeFilterComponent.this._tree);
        }
    }

    class ClearAllAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        ClearAllAction() {
        }

        public void actionPerformed(ActionEvent e) {
            PublicTypeFilterComponent.clearTreeNodes(PublicTypeFilterComponent.this._tree);
        }
    }

    class TypeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private TypeDescriptorInterface _tdi;

        public TypeNode(TypeDescriptorInterface tdi) throws ServiceException, RemoteException {
            super(tdi.getType(), false);
            this._tdi = tdi;
        }

        public TypeDescriptorInterface getTypeDescriptor() {
            return this._tdi;
        }
    }

    class TypesSorter
    implements Comparator<TypeDescriptorInterface> {
        private SASStringComparator _comparator = SASCollatorFactory.createCollator((Locale)JComponent.getDefaultLocale());

        TypesSorter() {
        }

        @Override
        public int compare(TypeDescriptorInterface tdi1, TypeDescriptorInterface tdi2) {
            if (tdi1 == tdi2) {
                return 0;
            }
            if (tdi1 == null) {
                return -1;
            }
            if (tdi2 == null) {
                return 1;
            }
            try {
                return this._comparator.compare(tdi1.getType(), tdi2.getType());
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            return 1;
        }
    }
}

