/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals.search;

import com.sas.metadata.logical.visuals.search.AbstractFilterComponent;
import com.sas.metadata.logical.visuals.search.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.search.NotesFilter;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchFilter;
import com.sas.workspace.WATextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class NotesFilterComponent
extends AbstractFilterComponent {
    private static final long serialVersionUID = 1L;
    protected WATextField _notesTextField;

    @Override
    protected void initialize() {
        super.initialize();
        this._notesTextField = new WATextField();
        this._notesTextField.setColumns(40);
    }

    @Override
    protected void layoutWidgets() {
        super.layoutWidgets();
        this.setLayout(new GridBagLayout());
        this.add((Component)this._notesTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    @Override
    public String getLabel() {
        return RB.getStringResource("NotesFilterComponent.Label.txt");
    }

    @Override
    public void loadInitialData() throws ServiceException, RemoteException {
    }

    @Override
    public void setPreviousValues(SearchFilter filter) throws ServiceException, RemoteException {
        if (filter instanceof NotesFilter) {
            List notes = ((NotesFilter)filter).getNotes();
            if (notes != null && notes.size() > 0) {
                this._notesTextField.setText((String)notes.get(0));
            }
        } else {
            this.resetValues();
        }
    }

    @Override
    public void resetValues() {
        this._notesTextField.setText("");
    }

    @Override
    public SearchFilter createFilter() throws ServiceException, RemoteException {
        String noteValue = this._notesTextField.getText().trim();
        if (noteValue.length() > 0) {
            ArrayList<String> notes = new ArrayList<String>(1);
            notes.add(noteValue);
            return new NotesFilter(notes);
        }
        return null;
    }

    @Override
    public void setPreviousValues(Search search) throws ServiceException, RemoteException {
        List filters = search.getFilters();
        if (filters == null) {
            return;
        }
        for (SearchFilter filter : filters) {
            if (!(filter instanceof NotesFilter)) continue;
            this.setPreviousValues(filter);
            break;
        }
    }

    @Override
    public void setEditable(boolean bEditable) {
        if (this._notesTextField != null) {
            this._notesTextField.setEditable(bEditable);
        }
    }
}

