/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals.search;

import com.sas.metadata.logical.visuals.search.AbstractFilterComponent;
import com.sas.metadata.logical.visuals.search.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.search.ObjectNameFilter;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchFilter;
import com.sas.services.information.search.SearchOperator;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WAComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class NameFilterComponent
extends AbstractFilterComponent {
    private static final long serialVersionUID = 1L;
    protected JTextField _nameTextField;
    protected WAComboBox _operatorsComboBox;
    private final int CONTAINS_SEARCH = 0;
    private final int EQUALS_SEARCH = 1;
    private final int STARTSWITH_SEARCH = 2;
    protected JCheckBox _descriptionCheckBox;

    @Override
    protected void initialize() {
        super.initialize();
        this._nameTextField = new JTextField();
        this._nameTextField.requestFocus();
        this._operatorsComboBox = new WAComboBox((Object[])SearchOperator.values());
        this._descriptionCheckBox = new JCheckBox();
        Util.configureMnemonicForButton((AbstractButton)this._descriptionCheckBox, (String)RB.getStringResource("NameFilterComponent.IncludeDesc.txt"));
        this._descriptionCheckBox.setToolTipText(RB.getStringResource("NameFilterComponent.IncludeDesc.Tooltip.txt"));
    }

    @Override
    protected void layoutWidgets() {
        super.layoutWidgets();
        this.setLayout(new GridBagLayout());
        this.add((Component)this._nameTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this._operatorsComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this._descriptionCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    @Override
    public String getLabel() {
        return RB.getStringResource("NameFilterComponent.Label.txt");
    }

    @Override
    public void loadInitialData() throws ServiceException, RemoteException {
    }

    @Override
    public void setPreviousValues(SearchFilter filter) throws ServiceException, RemoteException {
        if (filter instanceof ObjectNameFilter) {
            this._nameTextField.setText(((ObjectNameFilter)filter).getName());
            this._descriptionCheckBox.setSelected(((ObjectNameFilter)filter).isIncludingDescription());
            this._operatorsComboBox.setSelectedIndex(this.getOperatorIndex(this._operatorsComboBox.getModel(), ((ObjectNameFilter)filter).getSearchOperator()));
        } else {
            this.resetValues();
        }
    }

    @Override
    public void resetValues() {
        this._nameTextField.setText("");
        this._descriptionCheckBox.setSelected(false);
        this._operatorsComboBox.setSelectedIndex(0);
    }

    @Override
    public SearchFilter createFilter() throws ServiceException, RemoteException {
        String nameValue = this._nameTextField.getText().trim();
        if (nameValue.length() > 0) {
            boolean includeDescription = this._descriptionCheckBox.isSelected();
            return new ObjectNameFilter(nameValue, includeDescription, this._getSearchOperator(this._operatorsComboBox.getSelectedIndex()));
        }
        return null;
    }

    @Override
    public void setPreviousValues(Search search) throws ServiceException, RemoteException {
        List filters = search.getFilters();
        if (filters == null) {
            return;
        }
        for (SearchFilter filter : filters) {
            if (!(filter instanceof ObjectNameFilter)) continue;
            this.setPreviousValues(filter);
            break;
        }
    }

    protected SearchOperator _getSearchOperator(int nSearchOperator) {
        switch (nSearchOperator) {
            case 0: {
                return SearchOperator.CONTAINS;
            }
            case 1: {
                return SearchOperator.EQUALS;
            }
            case 2: {
                return SearchOperator.STARTSWITH;
            }
        }
        return SearchOperator.CONTAINS;
    }

    private int getOperatorIndex(ComboBoxModel dataModel, SearchOperator operator) {
        SearchOperator sObject = operator;
        int c = dataModel.getSize();
        for (int i = 0; i < c; ++i) {
            Object obj = dataModel.getElementAt(i);
            if (obj == null || !obj.equals(sObject)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setEditable(boolean bEditable) {
        if (this._nameTextField != null) {
            this._nameTextField.setEditable(bEditable);
        }
        if (this._descriptionCheckBox != null) {
            this._descriptionCheckBox.setEnabled(bEditable);
        }
        if (this._operatorsComboBox != null) {
            this._operatorsComboBox.setEnabled(bEditable);
        }
    }
}

