/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals.search;

import com.sas.metadata.logical.visuals.search.AbstractFilterComponent;
import com.sas.metadata.logical.visuals.search.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.search.KeywordFilter;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchFilter;
import com.sas.workspace.WATextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class KeywordsFilterComponent
extends AbstractFilterComponent {
    private static final long serialVersionUID = 1L;
    protected WATextField _keywordsTextField;

    @Override
    protected void initialize() {
        super.initialize();
        this._keywordsTextField = new WATextField();
        this._keywordsTextField.setColumns(40);
        this._keywordsTextField.setMaxCharacters(60);
    }

    @Override
    protected void layoutWidgets() {
        super.layoutWidgets();
        this.setLayout(new GridBagLayout());
        this.add((Component)this._keywordsTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    @Override
    public String getLabel() {
        return RB.getStringResource("KeywordsFilterComponent.Label.txt");
    }

    @Override
    public void loadInitialData() throws ServiceException, RemoteException {
    }

    @Override
    public void setPreviousValues(SearchFilter filter) throws ServiceException, RemoteException {
        if (filter instanceof KeywordFilter) {
            List keys = ((KeywordFilter)filter).getKeywords();
            if (keys != null && keys.size() > 0) {
                this._keywordsTextField.setText((String)keys.get(0));
            }
        } else {
            this.resetValues();
        }
    }

    @Override
    public void resetValues() {
        this._keywordsTextField.setText("");
    }

    @Override
    public SearchFilter createFilter() throws ServiceException, RemoteException {
        String keyValue = this._keywordsTextField.getText().trim();
        if (keyValue.length() > 0) {
            ArrayList<String> keys = new ArrayList<String>(1);
            keys.add(keyValue);
            return new KeywordFilter(keys);
        }
        return null;
    }

    @Override
    public void setPreviousValues(Search search) throws ServiceException, RemoteException {
        List filters = search.getFilters();
        if (filters == null) {
            return;
        }
        for (SearchFilter filter : filters) {
            if (!(filter instanceof KeywordFilter)) continue;
            this.setPreviousValues(filter);
            break;
        }
    }

    @Override
    public void setEditable(boolean bEditable) {
        if (this._keywordsTextField != null) {
            this._keywordsTextField.setEditable(bEditable);
        }
    }
}

