/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals.search;

import com.sas.metadata.logical.visuals.search.AbstractFilterComponent;
import com.sas.metadata.logical.visuals.search.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.search.ExtendedAttributesFilter;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchFilter;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WATextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;

public class ExtendedAttributesFilterComponent
extends AbstractFilterComponent {
    private static final long serialVersionUID = 1L;
    protected JLabel _nameLabel;
    protected WATextField _nameTextField;
    protected JLabel _valueLabel;
    protected WATextField _valueTextField;

    @Override
    protected void initialize() {
        super.initialize();
        this._nameTextField = new WATextField();
        this._nameTextField.setColumns(40);
        this._nameTextField.setMaxCharacters(60);
        this._nameLabel = Util.createLabelForComponent((Component)this._nameTextField, (String)RB.getStringResource("ExtendedAttributesFilterComponent.NameLabel.txt"));
        this._valueTextField = new WATextField();
        this._valueTextField.setColumns(40);
        this._valueTextField.setMaxCharacters(256);
        this._valueLabel = Util.createLabelForComponent((Component)this._valueTextField, (String)RB.getStringResource("ExtendedAttributesFilterComponent.ValueLabel.txt"));
    }

    @Override
    protected void layoutWidgets() {
        super.layoutWidgets();
        this.setLayout(new GridBagLayout());
        this.add((Component)this._nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this._nameTextField, new GridBagConstraints(1, 0, -1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this._valueLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 10, 0), 0, 0));
        this.add((Component)this._valueTextField, new GridBagConstraints(1, 1, -1, 1, 1.0, 1.0, 18, 1, new Insets(10, 5, 10, 5), 0, 0));
    }

    @Override
    public String getLabel() {
        return RB.getStringResource("ExtendedAttributesFilterComponent.Label.txt");
    }

    @Override
    public void loadInitialData() throws ServiceException, RemoteException {
    }

    @Override
    public void setPreviousValues(SearchFilter filter) throws ServiceException, RemoteException {
        if (filter instanceof ExtendedAttributesFilter) {
            String name;
            Map extensions = ((ExtendedAttributesFilter)filter).getExtendedAttributes();
            if (extensions != null && extensions.size() > 0 && (name = (String)extensions.keySet().iterator().next()) != null) {
                this._nameTextField.setText(name);
                String value = (String)extensions.get(name);
                this._valueTextField.setText(value);
            }
        } else {
            this.resetValues();
        }
    }

    @Override
    public void resetValues() {
        this._nameTextField.setText("");
        this._valueTextField.setText("");
    }

    @Override
    public SearchFilter createFilter() throws ServiceException, RemoteException {
        String name = this._nameTextField.getText().trim();
        String value = this._valueTextField.getText().trim();
        if (name.length() > 0) {
            HashMap<String, String> extensions = new HashMap<String, String>(1);
            extensions.put(name, value);
            return new ExtendedAttributesFilter(extensions);
        }
        if (value.length() > 0) {
            this._nameTextField.requestFocus();
            throw new ServiceException(RB.getStringResource("ExtendedAttributesFilterComponent.MissingName.txt"));
        }
        return null;
    }

    @Override
    public void setPreviousValues(Search search) throws ServiceException, RemoteException {
        List filters = search.getFilters();
        if (filters == null) {
            return;
        }
        for (SearchFilter filter : filters) {
            if (!(filter instanceof ExtendedAttributesFilter)) continue;
            this.setPreviousValues(filter);
            break;
        }
    }

    @Override
    public void setEditable(boolean bEditable) {
        if (this._nameTextField != null) {
            this._nameTextField.setEditable(bEditable);
        }
        if (this._valueTextField != null) {
            this._valueTextField.setEditable(bEditable);
        }
    }
}

