/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals.search;

import com.sas.metadata.logical.visuals.search.BaseFilterPanel;
import com.sas.metadata.logical.visuals.search.DateFilterComponent;
import com.sas.metadata.logical.visuals.search.DefaultAdvancedFilterDialog;
import com.sas.metadata.logical.visuals.search.ExtendedAttributesFilterComponent;
import com.sas.metadata.logical.visuals.search.FolderScopeComponent;
import com.sas.metadata.logical.visuals.search.KeywordsFilterComponent;
import com.sas.metadata.logical.visuals.search.NameFilterComponent;
import com.sas.metadata.logical.visuals.search.NotesFilterComponent;
import com.sas.metadata.logical.visuals.search.PublicTypeFilterComponent;
import com.sas.metadata.logical.visuals.search.RB;
import com.sas.metadata.logical.visuals.search.ResponsibilitiesFilterComponent;
import com.sas.metadata.logical.visuals.search.SaveSearchDialog;
import com.sas.metadata.logical.visuals.search.SearchEventListener;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIServer;
import com.sas.services.information.UserFolderType;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchCriteriaException;
import com.sas.services.information.search.SearchFolder;
import com.sas.swing.visuals.UnderlineIcon;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.OpRequestUICancellableRunnable;
import com.sas.workspace.WARootPane;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractOperation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class DefaultSearchPanel
extends BaseFilterPanel {
    private static final long serialVersionUID = 1L;
    private List<PublicObjectInterface> m_searchResults;
    private SearchFolder m_searchFolder;
    private JButton m_btnReset;
    private JButton m_btnSearch;
    private JButton m_btnSave;
    private PublicTypeFilterComponent m_cmpTypeFilter;
    private boolean m_bDisplayResetButton;
    private boolean m_bDisplaySearchButton;
    private boolean m_bDisplaySaveButton;

    @Override
    protected void initializePanel() {
        super.initializePanel();
        this.createButtons();
        this.createFilterComponents();
        this.createAdvancedFilterDialog();
    }

    private void createButtons() {
        this.m_btnSearch = new JButton();
        Util.configureMnemonicForButton((AbstractButton)this.m_btnSearch, (String)RB.getStringResource("DefaultSearchPanel.Search.txt"));
        this.m_btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultSearchPanel.this.onRunSearch();
            }
        });
        this.m_btnSave = new JButton();
        Util.configureMnemonicForButton((AbstractButton)this.m_btnSave, (String)RB.getStringResource("DefaultSearchPanel.Save.txt"));
        this.m_btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultSearchPanel.this.onSave();
            }
        });
        this.m_btnReset = new JButton();
        Util.configureMnemonicForButton((AbstractButton)this.m_btnReset, (String)RB.getStringResource("DefaultSearchPanel.ResetToDefaults.txt"));
        this.m_btnReset.setRolloverIcon((Icon)new UnderlineIcon(true));
        this.m_btnReset.setIcon((Icon)new UnderlineIcon(false));
        this.m_btnReset.setMargin(new Insets(0, 0, 0, 0));
        this.m_btnReset.setBorderPainted(false);
        this.m_btnReset.setContentAreaFilled(false);
        this.m_btnReset.setVerticalAlignment(3);
        this.m_btnReset.setForeground(SystemColor.blue);
        this.m_btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultSearchPanel.this.onReset();
            }
        });
        this.setDisplayResetButton(true);
        this.setDisplaySaveButton(true);
        this.setDisplaySearchButton(true);
    }

    private void createFilterComponents() {
        FolderScopeComponent cmpFolderScope = new FolderScopeComponent();
        this.addFilterPanel(cmpFolderScope);
        NameFilterComponent cmpNameFilter = new NameFilterComponent();
        this.addFilterPanel(cmpNameFilter);
        this.m_cmpTypeFilter = new PublicTypeFilterComponent();
        this.m_cmpTypeFilter.setTypeDimension(new Dimension(0, 100));
        this.addFilterPanel(this.m_cmpTypeFilter);
        DateFilterComponent cmpDateFilter = new DateFilterComponent(true);
        this.addFilterPanel(cmpDateFilter);
        cmpFolderScope.addPropertyChangeListener("scopeToFolder", this.m_cmpTypeFilter);
    }

    private void createAdvancedFilterDialog() {
        DefaultAdvancedFilterDialog advancedDialog = new DefaultAdvancedFilterDialog(RB.getStringResource("DefaultSearchPanel.AdvancedFiltersDialog.Title.txt"), (Frame)Workspace.getWorkspace());
        advancedDialog.addFilterPanel(new KeywordsFilterComponent());
        advancedDialog.addFilterPanel(new NotesFilterComponent());
        advancedDialog.addFilterPanel(new ExtendedAttributesFilterComponent());
        advancedDialog.addFilterPanel(new ResponsibilitiesFilterComponent());
        this.setAdvancedFilterDialog(advancedDialog);
    }

    public void layoutComponents() {
        this.setLayout(new GridBagLayout());
        int yIndex = 0;
        this.add((Component)this.m_btnReset, new GridBagConstraints(0, yIndex++, 3, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JSeparator(), new GridBagConstraints(0, yIndex++, 3, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        yIndex = this.layoutFilterPanels(yIndex);
        this.add((Component)new JSeparator(), new GridBagConstraints(0, yIndex++, 3, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (this.isDisplayingAdvancedButton()) {
            this.add((Component)this._advancedButton, new GridBagConstraints(0, yIndex, 1, 1, 1.0, 0.0, 18, 0, new Insets(10, 10, 5, 0), 0, 0));
        }
        if (this.isDisplayingSearchButton()) {
            this.add((Component)this.m_btnSearch, new GridBagConstraints(1, yIndex, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 10, 5, 0), 0, 0));
        }
        if (this.isDisplayingSaveButton()) {
            this.add((Component)this.m_btnSave, new GridBagConstraints(2, yIndex, 1, 1, 1.0, 0.0, 12, 0, new Insets(10, 10, 5, 5), 0, 0));
        }
    }

    public void configurePublicTypes(List<String> types) {
        this.m_cmpTypeFilter.configurePublicTypes(types);
    }

    public boolean isDisplayingResetButton() {
        return this.m_bDisplayResetButton;
    }

    public void setDisplayResetButton(boolean show) {
        this.m_bDisplayResetButton = show;
    }

    public boolean isDisplayingSaveButton() {
        return this.m_bDisplaySaveButton;
    }

    public void setDisplaySaveButton(boolean show) {
        this.m_bDisplaySaveButton = show;
    }

    public boolean isDisplayingSearchButton() {
        return this.m_bDisplaySearchButton;
    }

    public void setDisplaySearchButton(boolean show) {
        this.m_bDisplaySearchButton = show;
    }

    public void setSearchButtonAsDefaultButton() {
        if (!this.isDisplayingSearchButton()) {
            throw new UnsupportedOperationException("Search button cannot be default if it is not displayed.");
        }
        JRootPane root = this.getRootPane();
        if (root == null) {
            return;
        }
        if (root instanceof WARootPane) {
            ((WARootPane)root).setRealDefaultButton(this.m_btnSearch);
        } else {
            root.setDefaultButton(this.m_btnSearch);
        }
    }

    public void addSearchListener(SearchEventListener l) {
        this.listenerList.add(SearchEventListener.class, l);
    }

    public void removeSearchListener(SearchEventListener l) {
        this.listenerList.remove(SearchEventListener.class, l);
    }

    public void setSearchFolder(SearchFolder searchFolder) {
        this.m_searchFolder = searchFolder;
        if (this.isDisplayingAdvancedButton()) {
            try {
                this._advancedFilterDialog.setSearch(searchFolder.getSearch());
            }
            catch (ServiceException ex) {
                Workspace.handleServiceException((ServiceException)ex);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    public SearchFolder getSearchFolder() {
        return this.m_searchFolder;
    }

    public void setPreviousValues() throws ServiceException, RemoteException {
        if (this.m_searchFolder == null) {
            throw new UnsupportedOperationException("SearchFolder must be set prior to calling setPreviousValues");
        }
        this.setPreviousValues(this.m_searchFolder.getSearch());
    }

    public List<PublicObjectInterface> getSearchResults() {
        return this.m_searchResults;
    }

    private void fireSearchStartedEvent() {
        SearchEventListener[] aListeners = (SearchEventListener[])this.getListeners(SearchEventListener.class);
        for (int iListener = aListeners.length - 1; iListener >= 0; --iListener) {
            aListeners[iListener].searchStarted();
        }
    }

    private void fireSearchCompletedEvent() {
        SearchEventListener[] aListeners = (SearchEventListener[])this.getListeners(SearchEventListener.class);
        for (int iListener = aListeners.length - 1; iListener >= 0; --iListener) {
            aListeners[iListener].searchCompleted(this.m_searchResults);
        }
    }

    private void fireSearchCanceledEvent() {
        SearchEventListener[] aListeners = (SearchEventListener[])this.getListeners(SearchEventListener.class);
        for (int iListener = aListeners.length - 1; iListener >= 0; --iListener) {
            aListeners[iListener].searchCanceled();
        }
    }

    private void onRunSearch() {
        try {
            this.runSearch();
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
    }

    private void onSave() {
        if (this.m_searchFolder != null) {
            this.save();
        } else {
            this.showSaveDialog();
        }
    }

    private void save() {
        try {
            Search search = this.m_searchFolder.getSearch();
            List filters = search.getFilters();
            if (filters != null) {
                filters.clear();
            }
            this.updateSearch(search);
            this.m_searchFolder.update();
        }
        catch (ServiceException ex) {
            Workspace.handleServiceException((ServiceException)ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void showSaveDialog() {
        try {
            Search newSearch = this.createSearch();
            OMIServer server = Workspace.getWorkspace().getConnectionManager().getMetadataServer();
            FolderInterface myFolder = server.getHomeFolder(null, UserFolderType.MYFOLDER, null);
            SaveSearchDialog dlg = new SaveSearchDialog((Frame)Workspace.getWorkspace(), newSearch, myFolder);
            dlg.show();
            dlg.dispose();
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
    }

    private void onReset() {
        this.reset();
        if (this._advancedFilterDialog != null) {
            this._advancedFilterDialog.resetAllValues();
            this._advancedFilterDialog.validateData();
        }
    }

    private void runSearch() throws RemoteException, ServiceException {
        if (this.m_searchResults != null) {
            this.m_searchResults = null;
        }
        Search newSearch = this.createSearch();
        this.fireSearchStartedEvent();
        OpRequestUI request = new OpRequestUI((Component)SwingUtilities.getWindowAncestor(this), RB.getStringResource("DefaultSearchPanel.RunSearch.Description.txt"));
        request.setTitle(RB.getStringResource("DefaultSearchPanel.Dialog.Title.txt"));
        request.setDelayBeforeProgressCancelDialog(800);
        int result = request.executeWithCancel(this.createSearchOperation(request, newSearch));
        if (result == 0) {
            this.fireSearchCompletedEvent();
        } else {
            this.fireSearchCanceledEvent();
        }
    }

    protected OpRequestUICancellableRunnable createSearchOperation(OpRequestUI opUI, Search newSearch) {
        return new SearchOperation(opUI, newSearch);
    }

    private void executeSearch(Search newSearch) {
        try {
            this.m_searchResults = newSearch.search();
        }
        catch (SearchCriteriaException se) {
            MessageUtil.displayListMessage((String)RB.getStringResource("DefaultSearchPanel.ErrorDialog.Msg.txt"), (List)se.getMessageList(), (String)RB.getStringResource("DefaultSearchPanel.Dialog.Title.txt"), (int)0);
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
    }

    private class SearchOperation
    extends WsAbstractOperation {
        private Search m_Search;

        public SearchOperation(OpRequestUI opUI, Search newSearch) {
            super(opUI);
            this.m_Search = newSearch;
        }

        public void run() {
            DefaultSearchPanel.this.executeSearch(this.m_Search);
            if (this.isOperationCancelled()) {
                DefaultSearchPanel.this.fireSearchCanceledEvent();
                return;
            }
        }
    }
}

