/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals.search;

import com.sas.metadata.logical.visuals.search.AbstractFilterDialog;
import com.sas.metadata.logical.visuals.search.FilterComponentInterface;
import com.sas.metadata.logical.visuals.search.ResultsConfigurationComponent;
import com.sas.services.ServiceException;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchFilter;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class DefaultAdvancedFilterDialog
extends AbstractFilterDialog {
    private static final long serialVersionUID = 1L;
    protected ResultsConfigurationComponent _resultsPanel = null;
    protected boolean _displayResultsConfiguration = false;
    private Search m_search;
    private boolean m_bDataValidated;

    public DefaultAdvancedFilterDialog(String title, Dialog dlgOwner) {
        super(title, dlgOwner);
        this.initializeDialog();
    }

    public DefaultAdvancedFilterDialog(String title, Frame frameOwner) {
        super(title, frameOwner);
        this.initializeDialog();
    }

    @Override
    protected void initializeDialog() {
        super.initializeDialog();
        this.setHelpProduct("searchview");
        this.setHelpTopic("advanced_criteria");
    }

    @Override
    protected void layoutWidgets() {
        super.layoutWidgets();
        int yIndex = 3;
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.add((Component)this._headerPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        mainPanel.add((Component)new JSeparator(), new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._basePanel.layoutWidgets();
        mainPanel.add((Component)this._basePanel, new GridBagConstraints(0, yIndex++, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
        if (this.isDisplayingResultsConfiguration()) {
            mainPanel.add((Component)((Object)this._resultsPanel), new GridBagConstraints(0, yIndex++, 0, 0, 1.0, 1.0, 18, 1, new Insets(5, 15, 5, 10), 0, 0));
        }
        this.add(mainPanel);
    }

    public boolean isDisplayingResultsConfiguration() {
        return this._displayResultsConfiguration;
    }

    public void setDisplayResultsConfigurationPanel(ResultsConfigurationComponent panel) {
        this._displayResultsConfiguration = true;
        this._resultsPanel = panel;
    }

    public ResultsConfigurationComponent getResultsPanel() {
        return this._resultsPanel;
    }

    @Override
    protected ActionListener getResetAction() {
        return new ResetAction();
    }

    protected void resetAllValues() {
        Map<FilterComponentInterface, SearchFilter> filterPanels = this._basePanel.getFilterPanelMap();
        for (FilterComponentInterface panel : filterPanels.keySet()) {
            panel.resetValues();
        }
        if (this.isDisplayingResultsConfiguration()) {
            this._resultsPanel.resetValues();
        }
    }

    public void setSearch(Search search) {
        this.m_search = search;
        this.m_bDataValidated = false;
    }

    public Search getSearch() {
        return this.m_search;
    }

    @Override
    public void setPreviousValues() {
        if (this.m_search == null || this.m_bDataValidated) {
            super.setPreviousValues();
            return;
        }
        try {
            List<FilterComponentInterface> dialogFilters = this.getFilterPanels();
            for (FilterComponentInterface panel : dialogFilters) {
                panel.setPreviousValues(this.m_search);
            }
            if (this.isDisplayingResultsConfiguration()) {
                this.getResultsPanel().setPreviousValues(this.m_search.getResultDetails().getResultLimit(), this.m_search.getResultDetails().getSortOrder());
            }
        }
        catch (ServiceException ex) {
            Workspace.handleServiceException((ServiceException)ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    @Override
    public boolean validateData() {
        this.m_bDataValidated = super.validateData();
        return this.m_bDataValidated;
    }

    @Override
    public void show() {
        if (this._previouslyLoaded) {
            try {
                Map<FilterComponentInterface, SearchFilter> filterPanels = this._basePanel.getFilterPanelMap();
                for (FilterComponentInterface panel : filterPanels.keySet()) {
                    panel.refreshData();
                }
            }
            catch (ServiceException ex) {
                Workspace.handleServiceException((ServiceException)ex);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        super.show();
    }

    private class ResetAction
    implements ActionListener {
        private ResetAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultAdvancedFilterDialog.this.resetAllValues();
        }
    }
}

