/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals;

import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.visuals.RB;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WorkspaceUtil;
import com.sas.workspace.WsButtonsLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;

public class UtilGui {
    static String[] buttonLabels = new String[]{RB.getStringResource("YYN.Lbl.Yes.txt"), RB.getStringResource("YYN.Lbl.YesToAll.txt"), RB.getStringResource("YYN.Lbl.No.txt")};

    public static void setLabelAndMnemonicOnAction(AbstractAction abstractAction, String text) {
        Util.setLabelAndMnemonicOnAction((Action)abstractAction, (String)text);
    }

    public static JLabel createLabelForComponent(Component component, String text) {
        return Util.createLabelForComponent((Component)component, (String)text);
    }

    public static JButton createButton(String text) {
        JButton jButton = new JButton();
        Util.configureMnemonicForButton((AbstractButton)jButton, (String)text);
        return jButton;
    }

    public static JCheckBox createCheckBox(String text) {
        JCheckBox jCheckBox = new JCheckBox();
        Util.configureMnemonicForButton((AbstractButton)jCheckBox, (String)text);
        return jCheckBox;
    }

    public static JRadioButton createRadioButton(String text) {
        JRadioButton jRadioButton = new JRadioButton();
        Util.configureMnemonicForButton((AbstractButton)jRadioButton, (String)text);
        return jRadioButton;
    }

    public static void displayInternalError(String message) {
        String msg = "Internal error: " + message;
        msg = msg + " Application behavior may be unpredictable from this point onwards.";
        MessageUtil.displayMessage((String)msg, (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0, (int)-1);
    }

    public static void displayExceptionError(Exception e) {
        String text = UtilMisc.getExceptionMessageText(e);
        String message = Message.format((ResourceBundle)RB.getResources(), (String)"COM.Excp.fmt.txt", (Object)text);
        MessageUtil.displayMessage((String)message, (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
    }

    public static void displayError(String errorMessage) {
        MessageUtil.displayMessage((String)errorMessage, (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
    }

    public static void displayWarning(String warningMessage) {
        MessageUtil.displayMessage((String)warningMessage, (String)RB.getStringResource("COM.WrngDlgTitle.txt"), (int)2);
    }

    public static void displayMdException(MdException mde) {
        MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
    }

    public static void displayRemoteException(RemoteException re) {
        String text = UtilMisc.getExceptionMessageText(re);
        UtilGui.displayInternalError(text);
    }

    public static int displayYesYesToAllNoDialog(String message, String title, int eType, int eOptions) {
        DisplayMessageRunnable run = new DisplayMessageRunnable(message, title, eType, eOptions);
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return run.getReturnCode();
    }

    protected static int showShortMessageDialog(String sMessage, String sTitle, int eType, int eOptions) {
        return JOptionPane.showConfirmDialog(MessageUtil.getMainWindow(), sMessage, sTitle, eOptions, eType);
    }

    protected static int showLongMessageDialog(String sMessage, String sTitle, int eType, int eOptions) {
        MessageDialog dialog = MessageUtil.getMainWindow() instanceof JFrame ? new MessageDialog((JFrame)MessageUtil.getMainWindow(), sMessage, sTitle, eType, eOptions) : new MessageDialog((JDialog)MessageUtil.getMainWindow(), sMessage, sTitle, eType, eOptions);
        dialog.pack();
        WorkspaceUtil.centerOver((Window)((Object)dialog), (Component)MessageUtil.getMainWindow());
        dialog.show();
        return dialog.getReturn();
    }

    static class DisplayMessageRunnable
    implements Runnable {
        protected String m_sTitle;
        protected String m_sMessage;
        protected int m_eType;
        protected int m_eOptions;
        protected int m_eReturnCode;

        public DisplayMessageRunnable(String sMessage, String sTitle, int eType, int eOptions) {
            this.m_sMessage = sMessage;
            this.m_sTitle = sTitle;
            this.m_eType = eType;
            this.m_eOptions = eOptions;
        }

        @Override
        public void run() {
            this.m_eReturnCode = UtilGui.showLongMessageDialog(this.m_sMessage, this.m_sTitle, this.m_eType, this.m_eOptions);
        }

        public int getReturnCode() {
            return this.m_eReturnCode;
        }
    }

    static class MessageDialog
    extends MessageUtil.cMessageDialog {
        private static final long serialVersionUID = 1L;

        public MessageDialog(JFrame frmParent, String sMessage, String sTitle, int eType, int eOptions) {
            super(frmParent, sMessage, sTitle, eType, eOptions);
        }

        public MessageDialog(JDialog dlgParent, String sMessage, String sTitle, int eType, int eOptions) {
            super(dlgParent, sMessage, sTitle, eType, eOptions);
        }

        protected JPanel createButtonsPanel(int eOptions) {
            if (eOptions == 1) {
                JPanel pnlButtons = new JPanel((LayoutManager)new WsButtonsLayout());
                pnlButtons.add(new cOptionButton(this, buttonLabels[0], 0));
                pnlButtons.add(new cOptionButton(this, buttonLabels[1], 1));
                pnlButtons.add(new cOptionButton(this, buttonLabels[2], 2));
                JButton btnDefault = (JButton)pnlButtons.getComponents()[0];
                this.getRootPane().setDefaultButton(btnDefault);
                return pnlButtons;
            }
            return super.createButtonsPanel(eOptions);
        }
    }

    protected static class cOptionButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        protected MessageUtil.cMessageDialog m_dlgParent;
        protected int m_eReturnCode;

        public cOptionButton(MessageUtil.cMessageDialog dlgParent, String label, int eReturnCode) {
            super(label);
            this.m_dlgParent = dlgParent;
            this.m_eReturnCode = eReturnCode;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.m_dlgParent.setReturn(this.m_eReturnCode);
            this.m_dlgParent.dispose();
        }
    }

    public static class NoHtmlTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        public NoHtmlTableCellRenderer() {
            this.putClientProperty("html.disable", Boolean.TRUE);
        }
    }
}

