/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.GeneralPropertyTab;
import com.sas.metadata.logical.visuals.RB;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.VirtualFolderManager;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.text.Message;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;

public class NonFolderMemberGeneralPropertyTab
extends GeneralPropertyTab {
    private static final long serialVersionUID = 1L;
    private TypeInterface _type;
    private boolean _isCompatible;
    private boolean _isVirtualFolderMember;

    public NonFolderMemberGeneralPropertyTab(Root root, int type, TypeInterface ti, Config config) throws RemoteException, ServiceException {
        this(root, ti, type, config);
        this._isCompatible = true;
        this.setMetadataObjectDisplayType(this._type.getDisplayType());
    }

    public NonFolderMemberGeneralPropertyTab(Root root, int type, LogicalObjectInterface loi, Config config) throws RemoteException, ServiceException {
        this(root, loi.getTypeInterface(), type, config);
        this._isCompatible = loi.isCompatible();
        String displayType = this._isCompatible ? this._type.getDisplayType() : (loi.isReadCompatible() ? Message.format((String)RB.getStringResource("COM.VerTypRC.fmt.txt"), (Object)this._type.getDisplayType(), (Object)loi.getUsageVersion().toString()) : Message.format((String)RB.getStringResource("COM.VerTypNS.fmt.txt"), (Object)this._type.getDisplayType(), (Object)loi.getUsageVersion().toString()));
        this.setMetadataObjectDisplayType(displayType);
    }

    private NonFolderMemberGeneralPropertyTab(Root root, TypeInterface ti, int type, Config config) throws RemoteException, ServiceException {
        super(root, type, config);
        this._type = ti;
        this.setIconForType(this._type.getIcon(1));
    }

    @Override
    protected void initialize() {
        this._isVirtualFolderMember = false;
        try {
            String publicType;
            Root meta = this.getMetadataObject();
            if (meta instanceof PrimaryType && SASFoldersUtil.isContainedByVirtualFolder((String)(publicType = ((PrimaryType)meta).getPublicType()), (ServerInterface)Factory.getInstance().getMetadataServerInterface())) {
                this._isVirtualFolderMember = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.initialize();
    }

    protected boolean isVirtualFolderMember() {
        return this._isVirtualFolderMember;
    }

    protected boolean isNonFolderContainerMember() {
        return !this._isVirtualFolderMember;
    }

    @Override
    protected String getContextLabel() {
        return this.isVirtualFolderMember() ? RB.getStringResource("COM.Lbl.Loc.txt") : "";
    }

    @Override
    protected String getContext() throws MdException, RemoteException {
        try {
            if (this.isVirtualFolderMember()) {
                Root meta = this.getMetadataObject();
                String reposID = meta.getRepositoryID();
                OMIRepositoryInterface repos = null;
                OMIServer server = Workspace.getWorkspace().getMetadataServer();
                List reposList = server.getRepositories(true);
                for (RepositoryInterface rs : reposList) {
                    String id;
                    if (!(rs instanceof OMIRepositoryInterface) || !reposID.equals((id = ((OMIRepositoryInterface)rs).getDefaultRepositoryId()).substring(9))) continue;
                    repos = (OMIRepositoryInterface)rs;
                    break;
                }
                return repos == null ? VirtualFolderManager.getDefaultPath((String)this._type.getPublicType()) : VirtualFolderManager.getDefaultPath((String)this._type.getPublicType(), repos);
            }
            return "";
        }
        catch (ServiceException e) {
            throw new MdException((Throwable)e);
        }
    }

    @Override
    protected String getPopulateStoreTemplate(Root root) throws RemoteException {
        String type = root.getCMetadataType();
        String template = "<Templates><" + type + "><Keywords/><ResponsibleParties/></" + type + "></Templates>";
        return template;
    }

    @Override
    public void onParentOK() {
        if (!this._isCompatible) {
            throw new UnsupportedOperationException("Logic error: Ok button should not be visible for object which is not compatible.");
        }
        super.onParentOK();
    }
}

