/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals;

import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.visuals.MetadataDialogPanel;
import com.sas.metadata.logical.visuals.RB;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.Keyword;
import com.sas.metadata.remote.MdException;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import javax.swing.JLabel;

public class KeywordPanel
extends MetadataDialogPanel {
    private static final long serialVersionUID = 1L;
    private Keyword _keyword;
    private String[] _existingKeywordNames;
    private String _originalName;
    private int _context;
    private JLabel _lblName;
    protected WATextField _txtName;

    public KeywordPanel(Keyword keyword, String[] existingKeywordNames, int context) {
        this._keyword = keyword;
        this._existingKeywordNames = existingKeywordNames;
        this._context = context;
        this.initialize();
        this.layoutWidgets();
    }

    public void initialize() {
        this.setHelpProduct("folderview");
        this.setHelpTopic(this._context == 2 ? "editkeywordwin" : "addkeywordwin");
        this._txtName = new WATextField();
        this._txtName.setMaxCharacters(60);
        this._txtName.setToolTipText(RB.getStringResource("COM.Tooltip.Name.txt"));
        this._lblName = UtilGui.createLabelForComponent((Component)this._txtName, RB.getStringResource("COM.Lbl.Name0.txt"));
    }

    public void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        int row = 0;
        this.add(this._lblName, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_TOP_ROW, 0, 0));
        this.add((Component)this._txtName, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_TOP_ROW, 0, 0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        this._originalName = this._keyword.getName();
        this._txtName.setText(this._originalName);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this._keyword.setName(this._txtName.getText().trim());
    }

    @Override
    public boolean dataValidate() {
        String newName = this._txtName.getText().trim();
        if (UtilMisc.isBlankOrEmptyString(newName)) {
            MessageUtil.displayMessage((String)RB.getStringResource("COM.NoName.txt"), (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
            this._txtName.requestFocus();
            return false;
        }
        boolean checkNameForDuplicates = true;
        if (this._context == 2 && this._originalName.equals(newName)) {
            checkNameForDuplicates = false;
        }
        if (checkNameForDuplicates) {
            for (String thisName : this._existingKeywordNames) {
                if (!newName.equals(thisName)) continue;
                String text = Message.format((ResourceBundle)RB.getResources(), (String)"COM.Exsts.fmt.txt", (Object)newName);
                MessageUtil.displayMessage((String)text, (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
                this._txtName.requestFocus();
                return false;
            }
        }
        return true;
    }
}

