/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.visuals.ResponsiblePartyTableModel;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

public class GeneralResponsiblePartyModel
extends ResponsiblePartyTableModel {
    private static final long serialVersionUID = 1L;
    protected List<Map<String, Object>> m_personList;

    public void moveDataToStore() throws MdException, RemoteException {
        MdObjectStore store = (MdObjectStore)this.m_oMetadata.getObjectStore();
        MdOMIUtil mdOMIUtil = store.getFactory().getOMIUtil();
        AssociationList alResponsibleParties = this.m_oMetadata.getResponsibleParties(false);
        int nParties = alResponsibleParties.size();
        ResponsibleParty[] respPartiesArray = (ResponsibleParty[])alResponsibleParties.toArray((Object[])new ResponsibleParty[nParties]);
        for (int iParty = 0; iParty < nParties; ++iParty) {
            ResponsibleParty oParty = respPartiesArray[iParty];
            String sRole = oParty.getRole();
            if ("Created By".equalsIgnoreCase(sRole)) continue;
            alResponsibleParties.remove((Object)oParty);
        }
        int size = this.getRowCount();
        for (int index = 0; index < size; ++index) {
            String name = (String)this.getValueAt(index, 0);
            String role = (String)this.getValueAt(index, 1);
            ResponsibleParty rp = (ResponsibleParty)this.getValueAt(index, 2);
            role = GeneralResponsiblePartyModel.getModelRole((String)role);
            if (rp == null) {
                rp = mdOMIUtil.getResponsibleParty(store, name, role);
            } else {
                boolean roleChanged;
                boolean nameChanged = !rp.getName().equals(name);
                boolean bl = roleChanged = !rp.getRole().equalsIgnoreCase(role);
                if (roleChanged || nameChanged) {
                    rp = mdOMIUtil.getResponsibleParty(store, name, role);
                }
            }
            if (rp == null) continue;
            alResponsibleParties.add((Object)rp);
        }
    }

    public String[] getPersons() {
        if (this.m_saPersons == null) {
            try {
                int flags = 8452;
                String options = "<Templates><Person Name=\"\"/></Templates>";
                String sRepositoryId = UtilMetadata.getFoundationRepositoryID();
                this.m_personList = Factory.getInstance().getOMIUtil().getMetadataObjectsNoCache("Person", sRepositoryId, options, flags);
                int size = this.m_personList.size();
                this.m_saPersons = new String[size];
                for (int i = 0; i < size; ++i) {
                    this.m_saPersons[i] = (String)this.m_personList.get(i).get("Name");
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                this.m_saPersons = new String[0];
            }
            catch (RemoteException re) {
                UtilGui.displayRemoteException(re);
                this.m_saPersons = new String[0];
            }
        }
        return this.m_saPersons;
    }

    protected CMetadata getPerson(MdObjectStore store, String sName) throws RemoteException {
        if (this.m_personList == null) {
            this.getPersons();
        }
        int length = this.m_saPersons.length;
        for (int index = 0; index < length; ++index) {
            if (!this.m_saPersons[index].equals(sName)) continue;
            return this.createPerson(index, store, sName);
        }
        return null;
    }

    protected CMetadata getPerson(ResponsibleParty rp, String personName) throws MdException, RemoteException {
        AssociationList persons = rp.getPersons();
        for (Person person : persons) {
            if (!person.getName().equals(personName)) continue;
            return person;
        }
        return null;
    }

    private CMetadata createPerson(int index, MdObjectStore store, String name) throws RemoteException {
        String id = (String)this.m_personList.get(index).get("Id");
        return Factory.getInstance().getMdFactory().createComplexMetadataObject(store, name, "Person", id);
    }
}

