/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderContentMappingModel;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.ConfigContentMappingPanel;
import com.sas.metadata.logical.visuals.FolderContentMappingTabPanelVC;
import com.sas.metadata.logical.visuals.ListElementInterface;
import com.sas.metadata.logical.visuals.RB;
import com.sas.metadata.logical.visuals.ServerComponentListElement;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import java.awt.Cursor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class FolderContentMappingTabPanel
extends FolderContentMappingTabPanelVC {
    private static final long serialVersionUID = 1L;
    private FolderContentMappingModel _model;
    private Root _root;
    private Config _config;
    private String _oldPassword;
    private int _oldBackingType;
    private String _oldDAVURL;
    private List<ServerComponentListElement> _davServers;

    public FolderContentMappingTabPanel(Tree tree, int type, Config config) throws RemoteException {
        super(type == 0, true);
        this._root = tree;
        this._model = new FolderContentMappingModel(tree);
        this._config = config;
    }

    public FolderContentMappingTabPanel(SoftwareComponent softwareComponent, int type, Config config) throws RemoteException {
        super(type == 0, false);
        this._root = softwareComponent;
        this._model = new FolderContentMappingModel(softwareComponent);
        this._config = config;
    }

    @Override
    public boolean dataValidate() throws RemoteException {
        boolean okToContinue;
        boolean showWarning;
        if (!this.isEditable()) {
            return true;
        }
        int backingType = this.getBackingType();
        String contentMappingLocation = null;
        if (backingType == 2) {
            ServerComponentListElement scle = (ServerComponentListElement)this._davServerComboBoxModel.getSelectedItem();
            if (scle == ServerComponentListElement.SELECT_A_SERVER) {
                MessageUtil.displayMessage((String)RB.getStringResource("FCMTP.NoMappn.txt"), (String)RB.getStringResource("FGTP.ErrDlgTitle.txt"), (int)0);
                return false;
            }
            contentMappingLocation = this._txtCompletePath.getText();
        }
        if (backingType == 2) {
            try {
                boolean notServerRoot;
                FolderContentMappingModel[] models = this._model.getRootAndTopLevelModels();
                boolean bl = notServerRoot = !this._model.isServerRoot();
                if (notServerRoot && this.compareBacking(backingType, contentMappingLocation, models[0])) {
                    MessageUtil.displayMessage((String)RB.getStringResource("FCMTP.dupCntntMpngPathWithRoot.msg.txt"), (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
                    return false;
                }
                for (int i = 1; i < models.length; ++i) {
                    FolderContentMappingModel targetModel = models[i];
                    if (notServerRoot && targetModel.getMetadataObject().getFQID().equalsIgnoreCase(this._root.getFQID()) || !this.compareBacking(backingType, contentMappingLocation, targetModel)) continue;
                    MessageUtil.displayMessage((String)UtilMisc.getMessage(RB.getStringResource("FCMTP.dupCntntMpngPathWithTopLvl.msg.fmt.txt"), targetModel.getMetadataObject().getName()), (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
                    return false;
                }
            }
            catch (MdException e) {
                UtilGui.displayMdException(e);
                return false;
            }
            catch (ServiceException e) {
                UtilGui.displayExceptionError((Exception)((Object)e));
                return false;
            }
        }
        if (backingType == 2) {
            String confirmPwd;
            boolean okToContinue2;
            String userId = this._userId.getText();
            String password = new String(this._password.getPassword());
            if (!(userId.length() != 0 && password.length() != 0 || (okToContinue2 = this.getYesOrNo(RB.getStringResource("FCMTP.UserIdPasswordMissing.title.txt"), RB.getStringResource("FCMTP.UserIdPasswordMissing.message.txt"), 3)))) {
                return false;
            }
            if (userId.length() > 0 && !password.equals(confirmPwd = new String(this._passwordConfirm.getPassword()))) {
                MessageUtil.displayMessage((String)RB.getStringResource("FCMTP.PwdNotMatch.txt"), (String)RB.getStringResource("FGTP.ErrDlgTitle.txt"), (int)0);
                this._password.setText(this._oldPassword);
                this._passwordConfirm.setText(this._oldPassword);
                this._password.requestFocus();
                return false;
            }
        }
        if (this._oldBackingType == 0) {
            if (this._root instanceof Tree) {
                try {
                    showWarning = Factory.getInstance().getRootFolder().isContentBacked() && backingType != 0;
                }
                catch (LogicalTypeException e) {
                    showWarning = false;
                }
            } else {
                showWarning = false;
            }
        } else if (this._oldBackingType == 1) {
            showWarning = false;
        } else if (backingType != 2) {
            showWarning = true;
        } else {
            boolean bl = showWarning = !this._oldDAVURL.equals(this._txtCompletePath.getText());
        }
        return !showWarning || (okToContinue = this.getYesOrNo(RB.getStringResource("FCMTP.changeWarning.title.txt"), RB.getStringResource("FCMTP.changeWarning.message.txt"), 2));
    }

    private boolean compareBacking(int type, String location, FolderContentMappingModel target) {
        String longString;
        String shortString;
        String compString = null;
        if (type == 2 && target.getBackingType() == 2) {
            compString = target.getDavURL();
        }
        if (compString == null) {
            return false;
        }
        if (compString.length() == location.length()) {
            return compString.equals(location);
        }
        if (compString.length() < location.length()) {
            shortString = compString;
            longString = location;
        } else {
            shortString = location;
            longString = compString;
        }
        if (!longString.startsWith(shortString)) {
            return false;
        }
        int shortLen = shortString.length();
        char pathSep = this.findPathSeparator(shortString);
        char charToBeTested = longString.charAt(shortLen);
        if (pathSep == '\u0000') {
            pathSep = this.findPathSeparator(longString);
        }
        if (pathSep != '\u0000') {
            return charToBeTested == pathSep;
        }
        return charToBeTested == '\\' || charToBeTested == '/';
    }

    private char findPathSeparator(String path) {
        boolean bkwd;
        boolean fwd = path.indexOf(47) != -1;
        boolean bl = bkwd = path.indexOf(92) != -1;
        if (fwd && !bkwd) {
            return '/';
        }
        if (!fwd && bkwd) {
            return '\\';
        }
        return '\u0000';
    }

    public void saveSettingsAndCleanUp() {
        if (!this.isEditable()) {
            return;
        }
        Config.Callback cb = this._config.getCallback(ConfigContentMappingPanel.SAVE_SETTINGS_AND_CLOSE);
        if (cb != null) {
            try {
                cb.callback(null);
            }
            catch (RemoteException re) {
                UtilGui.displayRemoteException(re);
            }
            catch (LogicalTypeException e) {
                UtilGui.displayExceptionError(e);
            }
        }
    }

    @Override
    public void smartPopulateStore() throws MdException, RemoteException {
        this._model.loadMetadata();
    }

    @Override
    public void moveDataToView() throws MdException {
        int backingType;
        this.setListeningForChanges(false);
        this._oldBackingType = backingType = this._model.getBackingType();
        if (backingType == 0) {
            this.enableButtonSet(0, true);
        } else if (backingType == 1) {
            String message = Message.format((ResourceBundle)RB.getResources(), (String)"FCMTP.fileNotSupported.message.fmt.txt", (Object)this._model.getFilePath());
            UtilGui.displayWarning(message);
            this.enableButtonSet(0, true);
        } else {
            this._oldDAVURL = this._model.getDavURL();
            this.enableButtonSet(2, true);
            this.setURLRelatedFields(this._oldDAVURL);
            String userId = this._model.getUserId();
            this._userId.setText(userId);
            String password = this._model.getPassword();
            this._password.setText(password);
            this._passwordConfirm.setText(password);
            this._oldPassword = password;
        }
        this.setListeningForChanges(true);
    }

    private void setURLRelatedFields(String url) throws MdException {
        String basePath;
        String serverURL;
        int doubleSlashPos = url.indexOf("//");
        int firstSingleSlashAfterDoubleSlash = url.indexOf(47, doubleSlashPos + 2);
        if (firstSingleSlashAfterDoubleSlash < 0) {
            serverURL = url;
            basePath = null;
        } else {
            serverURL = url.substring(0, firstSingleSlashAfterDoubleSlash);
            basePath = url.substring(firstSingleSlashAfterDoubleSlash);
        }
        int size = this._davServerComboBoxModel.getSize();
        DAVServer serverMatch = null;
        for (int i = 0; i < size; ++i) {
            DAVServer ds;
            ServerComponentListElement scle = (ServerComponentListElement)this._davServerComboBoxModel.getElementAt(i);
            if (!(scle instanceof DAVServer) || !(ds = (DAVServer)scle)._serverURL.equalsIgnoreCase(serverURL)) continue;
            serverMatch = ds;
            break;
        }
        if (serverMatch == null) {
            serverMatch = new DAVServer(serverURL, basePath);
            this._davServerComboBoxModel.addElement(serverMatch);
        }
        this._davServerComboBoxModel.setSelectedItem(serverMatch);
        ListElementInterface bpMatch = null;
        if (basePath != null) {
            size = this._davBasePathComboBoxModel.getSize();
            for (int i = 0; i < size; ++i) {
                ListElementInterface lei = (ListElementInterface)this._davBasePathComboBoxModel.getElementAt(i);
                if (!lei.toString().equals(basePath)) continue;
                bpMatch = lei;
                break;
            }
        }
        if (bpMatch == null) {
            if (basePath == null) {
                basePath = "";
            }
            final String fbp = basePath;
            bpMatch = new ListElementInterface(){

                @Override
                public String toString() {
                    return fbp;
                }
            };
            this._davBasePathComboBoxModel.addElement(bpMatch);
        }
        this._davBasePathComboBoxModel.setSelectedItem(bpMatch);
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        if (!this.isEditable()) {
            return;
        }
        if (this._rbNoMapping.isSelected()) {
            this._model.setBackingType(0);
        } else {
            this._model.setBackingType(2);
            this._model.setDavURL(this._txtCompletePath.getText());
            this._model.setUserId(this._userId.getText());
            String pw = new String(this._password.getPassword());
            this._model.setPassword(pw);
        }
        this._model.updateJomaObjects();
    }

    public void onParentOK() {
        if (this._root instanceof Tree) {
            try {
                this._model.loadMetadata();
                this._model.updateJomaObjects();
            }
            catch (MdException e) {
                UtilGui.displayMdException(e);
            }
            catch (RemoteException re) {
                UtilGui.displayRemoteException(re);
            }
        }
    }

    private boolean getYesOrNo(String title, String question, int type) {
        int answer = MessageUtil.displayMessage((String)question, (String)title, (int)type, (int)0);
        boolean retVal = answer == 0;
        return retVal;
    }

    @Override
    protected void doDAVServerSelected(ListElementInterface le) {
        this._davBasePathComboBoxModel.removeAllElements();
        ServerComponentListElement scle = (ServerComponentListElement)le;
        if (scle instanceof DAVServer) {
            DAVServer ds = (DAVServer)scle;
            Iterator<ListElementInterface> it = ds.getBasePaths().iterator();
            while (it.hasNext()) {
                this._davBasePathComboBoxModel.addElement(it.next());
            }
        } else {
            this._txtCompletePath.setText("");
        }
    }

    @Override
    protected void doDAVBasePathSelected(ListElementInterface le) {
        DAVServer ds = (DAVServer)this._davServerComboBoxModel.getSelectedItem();
        String basePath = le.toString();
        String url = ds._serverURL;
        if (!basePath.startsWith("/")) {
            url = url + "/";
        }
        url = url + basePath;
        this._txtCompletePath.setText(url);
    }

    @Override
    protected void initializeForFirstUseOfDAV() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this._davServerComboBoxModel.removeAllElements();
            this.loadDAVServerList();
            Iterator<ServerComponentListElement> it = this._davServers.iterator();
            while (it.hasNext()) {
                this._davServerComboBoxModel.addElement(it.next());
            }
        }
        catch (MdException e) {
            UtilGui.displayMdException(e);
            this.setOtherMetaDataException();
        }
        catch (RemoteException re) {
            UtilGui.displayRemoteException(re);
            this.setRemoteExceptionEncountered();
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void loadDAVServerList() throws MdException, RemoteException {
        if (this._davServers != null) {
            return;
        }
        this._davServers = new ArrayList<ServerComponentListElement>();
        this._davServers.add(ServerComponentListElement.SELECT_A_SERVER);
        List<ServerComponent> davServerList = UtilMetadata.locateDAVServers(this._root.getObjectStore(), UtilMetadata.makeRepositoryFQIDFromRoot(this._root));
        for (ServerComponent sc : davServerList) {
            DAVServer ds = new DAVServer(sc);
            if (ds._badServer) continue;
            this._davServers.add(ds);
        }
    }

    private class DAVServer
    extends ServerComponentListElement {
        private String _serverURL;
        private List<ListElementInterface> _basePathsModelItems;
        private boolean _badServer;

        public DAVServer(String url, final String basePath) {
            super(url);
            this._serverURL = url;
            this._basePathsModelItems = new ArrayList<ListElementInterface>();
            if (basePath != null) {
                this._basePathsModelItems.add(new ListElementInterface(){

                    @Override
                    public String toString() {
                        return basePath;
                    }
                });
            }
        }

        public DAVServer(ServerComponent sc) throws MdException, RemoteException {
            super(sc);
            String WEBDAV_PROTOCOL = "http";
            String WEBDAV_HTTPS_PROTOCOL = "https";
            boolean foundHttpServer = false;
            boolean foundHttpsServer = false;
            String hostName = null;
            int port = 0;
            AssociationList srcConnList = sc.getSourceConnections();
            for (CMetadata element : srcConnList) {
                if (!(element instanceof TCPIPConnection)) continue;
                TCPIPConnection tcpConn = (TCPIPConnection)element;
                String appProtocol = tcpConn.getApplicationProtocol();
                if (appProtocol.equalsIgnoreCase("http")) {
                    foundHttpServer = true;
                    hostName = tcpConn.getHostName();
                    port = tcpConn.getPort();
                    continue;
                }
                if (!appProtocol.equalsIgnoreCase("https")) continue;
                foundHttpsServer = true;
                hostName = tcpConn.getHostName();
                port = tcpConn.getPort();
            }
            if (foundHttpServer || foundHttpsServer) {
                this._serverURL = foundHttpServer ? "http" : "https";
                this._serverURL = this._serverURL + "://" + hostName + ":" + port;
            } else {
                this._badServer = true;
            }
        }

        List<ListElementInterface> getBasePaths() {
            if (this._basePathsModelItems == null) {
                this._basePathsModelItems = new ArrayList<ListElementInterface>();
                try {
                    List<Directory> dirList = UtilMetadata.getDAVServerBasePaths(this.getServerComponent());
                    for (final Directory d : dirList) {
                        this._basePathsModelItems.add(new ListElementInterface(){

                            @Override
                            public String toString() {
                                try {
                                    return d.getDirectoryName();
                                }
                                catch (RemoteException e) {
                                    UtilGui.displayRemoteException(e);
                                    FolderContentMappingTabPanel.this.setRemoteExceptionEncountered();
                                    return "";
                                }
                            }
                        });
                    }
                }
                catch (MdException e) {
                    UtilGui.displayMdException(e);
                }
                catch (RemoteException re) {
                    UtilGui.displayRemoteException(re);
                    FolderContentMappingTabPanel.this.setRemoteExceptionEncountered();
                }
            }
            return this._basePathsModelItems;
        }
    }
}

