/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals;

import com.sas.metadata.logical.visuals.ListElementInterface;
import com.sas.swing.visuals.WideComboBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;

public abstract class EditableComboBox
extends WideComboBox {
    private static final long serialVersionUID = 1L;
    private ActionListener _listener;
    private boolean _actionListenerSet;

    public EditableComboBox(DefaultComboBoxModel model, boolean editable) {
        super((ComboBoxModel)model);
        this.init(editable);
    }

    private void init(boolean editable) {
        ListCellRenderer lcr;
        if (editable) {
            this.setEditable(true);
        }
        if ((lcr = this.getRenderer()) instanceof JComponent) {
            ((JComponent)((Object)lcr)).putClientProperty("html.disable", Boolean.TRUE);
        }
        this._listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JComboBox cb = (JComboBox)event.getSource();
                Object selected = cb.getSelectedItem();
                if (selected instanceof ListElementInterface) {
                    EditableComboBox.this.doListItemSelected((ListElementInterface)selected);
                }
            }
        };
    }

    public void setListener(boolean on) {
        if (this._actionListenerSet == on) {
            return;
        }
        if (on) {
            this.addActionListener(this._listener);
            this._actionListenerSet = true;
        } else {
            this.removeActionListener(this._listener);
            this._actionListenerSet = false;
        }
    }

    protected abstract void doListItemSelected(ListElementInterface var1);

    protected ListElementInterface addNewItem(String input) {
        return null;
    }
}

