/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals;

import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.GeneralPropertyTab;
import com.sas.metadata.logical.visuals.RB;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;

public class BIPTreeElementGeneralPropertyTab
extends GeneralPropertyTab {
    private static final long serialVersionUID = 1L;
    private Tree _containingTree;
    private TypeInterface _ti;
    private boolean _isCompatible;

    public BIPTreeElementGeneralPropertyTab(Root root, Tree containingTree, int type, TypeInterface ti, Config config) throws RemoteException {
        this(root, ti, containingTree, type, config);
        this._isCompatible = true;
        this.setMetadataObjectDisplayType(this._ti.getDisplayType());
    }

    public BIPTreeElementGeneralPropertyTab(Root root, Tree containingTree, int type, LogicalObjectInterface loi, Config config) throws RemoteException {
        this(root, loi.getTypeInterface(), containingTree, type, config);
        this._isCompatible = loi.isCompatible();
        String displayType = this._isCompatible ? this._ti.getDisplayType() : (loi.isReadCompatible() ? Message.format((String)RB.getStringResource("COM.VerTypRC.fmt.txt"), (Object)this._ti.getDisplayType(), (Object)loi.getUsageVersion().toString()) : Message.format((String)RB.getStringResource("COM.VerTypNS.fmt.txt"), (Object)this._ti.getDisplayType(), (Object)loi.getUsageVersion().toString()));
        this.setMetadataObjectDisplayType(displayType);
    }

    private BIPTreeElementGeneralPropertyTab(Root root, TypeInterface ti, Tree containingTree, int type, Config config) throws RemoteException {
        super(root, type, config);
        this._containingTree = containingTree;
        this._ti = ti;
        this.setIconForType(this._ti.getIcon(1));
    }

    @Override
    protected String getContextLabel() {
        return RB.getStringResource("COM.Lbl.Loc.txt");
    }

    @Override
    protected String getContext() throws MdException, RemoteException {
        if (this._containingTree == null) {
            return RB.getStringResource("BITEGPT.noPath.txt");
        }
        return UtilMetadata.getPathWhichMayBeIncomplete(this._containingTree, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean checkForDuplicate(String nameToBeValidated) throws RemoteException, MdException, LogicalTypeException {
        if (this._containingTree == null) {
            UtilGui.displayError(RB.getStringResource("BITEGPT.noParentCantDupCheck.txt"));
            return true;
        }
        boolean ret = super.checkForDuplicate(nameToBeValidated);
        if (!ret) {
            UtilPlatformServices.DetachedTransaction detachedTransaction = null;
            try {
                detachedTransaction = UtilPlatformServices.getDetachedTransaction();
                FolderInterface fi = (FolderInterface)detachedTransaction.getSmartObject((Root)this._containingTree);
                if (fi == null) {
                    throw new LogicalTypeException("Could not obtain folder smart object for " + this._containingTree.getFQID());
                }
                try {
                    ret = fi.hasDuplicate(nameToBeValidated, this._ti.getPublicType());
                }
                catch (ServiceException e) {
                    throw new LogicalTypeException((Exception)((Object)e));
                }
                if (ret) {
                    String text = Message.format((ResourceBundle)RB.getResources(), (String)"COM.ExstsInv.fmt.txt", (Object)nameToBeValidated);
                    MessageUtil.displayMessage((String)text, (String)RB.getStringResource("COM.NameErr.title.txt"), (int)0);
                }
            }
            finally {
                if (detachedTransaction != null) {
                    detachedTransaction.rollback();
                }
            }
        }
        return ret;
    }

    @Override
    protected List<? extends Root> getOtherObjectsInContext() throws MdException, RemoteException {
        if (this._ti != null && this._containingTree != null) {
            return UtilMetadata.getBIObjectsFromTree(this._ti, this._containingTree);
        }
        return super.getOtherObjectsInContext();
    }

    @Override
    protected String getPopulateStoreTemplate(Root root) throws RemoteException {
        String type = root.getCMetadataType();
        String template = "<Templates><" + type + "><Keywords/><ResponsibleParties/><Trees/></" + type + "><Tree><ParentTree/></Tree></Templates>";
        return template;
    }

    @Override
    public void onParentOK() {
        if (!this._isCompatible) {
            throw new UnsupportedOperationException("Logic error: Ok button should not be visible for object which is not compatible.");
        }
        super.onParentOK();
    }
}

