/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.visuals;

import com.sas.metadata.logical.OperationUserInteraction2Interface;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.workspace.MessageUtil;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;

public abstract class AbstractOperationUserInteraction
implements OperationUserInteraction2Interface {
    private boolean _operationCancelled;
    private boolean _continueOperationWithPrompting = true;
    private Map<String, Object> _userObjectCache;

    @Override
    public boolean isOperationCancelled() {
        return this._operationCancelled;
    }

    @Override
    public void setOperationCancelled(boolean value) {
        this._operationCancelled = value;
    }

    @Override
    public boolean continueOperationWithPrompting() {
        return this._continueOperationWithPrompting;
    }

    @Override
    public void setContinueOperationWithPrompting(boolean value) {
        this._continueOperationWithPrompting = value;
    }

    @Override
    public abstract void updateProgress(String var1);

    @Override
    public int displayMessage(String title, String messageText, int messageType, int[] choiceSet) {
        if (choiceSet == OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET) {
            int retVal;
            int buttonSelected = UtilGui.displayYesYesToAllNoDialog(messageText, title, 3, 1);
            if (buttonSelected == 0) {
                retVal = 0;
            } else if (buttonSelected == 1) {
                retVal = 1;
            } else if (buttonSelected == 2) {
                retVal = 2;
            } else {
                throw new IllegalStateException("Logic error - unexpected button value returned: " + buttonSelected + ".");
            }
            return retVal;
        }
        if (choiceSet == OperationUserInteractionInterface.YES_NO_CANCEL_CHOICE_SET) {
            int messageTypeForMessageUtil;
            switch (messageType) {
                case 0: {
                    messageTypeForMessageUtil = 1;
                    break;
                }
                case 1: {
                    messageTypeForMessageUtil = 2;
                    break;
                }
                case 2: {
                    messageTypeForMessageUtil = 0;
                    break;
                }
                case 3: {
                    messageTypeForMessageUtil = 3;
                    break;
                }
                default: {
                    throw new IllegalStateException("Logic error - illegal value specified for messageType " + messageType + ".");
                }
            }
            int retVal = MessageUtil.displayMessage((String)messageText, (String)title, (int)messageTypeForMessageUtil, (int)1);
            if (retVal == 0) {
                retVal = 0;
            } else if (retVal == 1) {
                retVal = 3;
            } else if (retVal == 2) {
                retVal = 2;
            } else {
                throw new IllegalStateException("Logic error - unexpected button value returned: " + retVal + ".");
            }
            return retVal;
        }
        if (choiceSet == OperationUserInteractionInterface.OK_CHOICE_SET) {
            JOptionPane.showMessageDialog(null, messageText, title, 0);
            return 0;
        }
        throw new IllegalStateException("Logic error - choice set not known.");
    }

    @Override
    public boolean isUserInteractionSupported() {
        return true;
    }

    @Override
    public void setUserObject(String key, Object value) {
        if (this._userObjectCache == null) {
            this._userObjectCache = new HashMap<String, Object>();
        }
        this._userObjectCache.put(key, value);
    }

    @Override
    public Object getUserObject(String key) {
        return this._userObjectCache == null ? null : this._userObjectCache.get(key);
    }
}

