/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.batch;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.batch.BatchDriver2;
import com.sas.metadata.logical.batch.BatchDriverOptions;
import com.sas.metadata.logical.batch.RB;
import com.sas.services.information.OMIServer;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.text.Message;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;

@SASScope
public class MakeFolder2
extends BatchDriver2 {
    public static final String OPTION_MAKE_FULL_PATH = "makeFullPath";
    private String _folderPath = null;
    private String _parentFolderPath = null;
    private String _folderName = null;
    private boolean _makeFullPath = false;

    public MakeFolder2() {
        this._logTimestamps = false;
        this._logFileDisabled = true;
    }

    public static int makeFolder(BatchDriver2 parent, String folderPath, boolean makeFullPath) throws Exception {
        MakeFolder2 make = new MakeFolder2();
        make.setParent(parent);
        make.setFolderPath(folderPath);
        make.setMakeFullPath(makeFullPath);
        int rc = make.makeFolder();
        try {
            make.terminate();
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        return rc;
    }

    public void setFolderPath(String folderPath) {
        Pattern pattern = Pattern.compile("^(/(.*?/)*)([^/]+)/?$");
        Matcher matcher = pattern.matcher(folderPath);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(RB.getStringResource("MakeFolder.InvalidFolderPath.log"));
        }
        this._folderPath = folderPath;
        this._parentFolderPath = matcher.group(1);
        this._folderName = matcher.group(3);
    }

    public void setMakeFullPath(boolean makeFullPath) {
        this._makeFullPath = makeFullPath;
    }

    public int makeFolder() {
        if (this._folderPath == null) {
            this._logger.error(RB.getStringResource("MakeFolder.NoFolderPath.log"));
            this._rc = 8;
            return this._rc;
        }
        try {
            this.initialize();
            this.logStart();
            this.logConnectionInfo();
            this.makeTheFolder();
        }
        catch (Exception e) {
            this.logException(e);
        }
        finally {
            try {
                this.terminate();
            }
            catch (Exception e) {
                this.logException(e);
            }
        }
        return this._rc;
    }

    private void makeTheFolder() throws Exception {
        OMIServer server = (OMIServer)this._session.getUserContext().getAuthServer();
        FolderInterface parentFolder = null;
        RootFolderInterface rootFolder = server.getRootFolder();
        PathUrl parentFolderUrl = new PathUrl(rootFolder.getPathUrl(), this._parentFolderPath);
        parentFolder = (FolderInterface)server.getObjectByPath(parentFolderUrl);
        if (parentFolder == null && this._makeFullPath) {
            String previousFolderPath = this._folderPath;
            this.setFolderPath(this._parentFolderPath);
            this.makeTheFolder();
            this.setFolderPath(previousFolderPath);
            parentFolderUrl = new PathUrl(rootFolder.getPathUrl(), this._parentFolderPath);
            parentFolder = (FolderInterface)server.getObjectByPath(parentFolderUrl);
        }
        if (parentFolder == null) {
            this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"MakeFolder.ParentFolderDoesNotExist.fmt.log", (Object)this._parentFolderPath));
            this._rc = 8;
        } else if (parentFolder.getSubfolder(this._folderName) != null) {
            this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"MakeFolder.FolderAlreadyExists.fmt.log", (Object)this._folderPath));
            this._rc = 4;
        } else {
            FolderInterface newFolder = parentFolder.makeSubfolder(this._folderName);
            if (newFolder != null) {
                newFolder.update();
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"MakeFolder.FolderCreated.fmt.log", (Object)this._folderPath));
                this._rc = 0;
            }
        }
    }

    @Override
    protected void parse(String[] args) throws ParseException, MissingOptionException {
        this._options = new Options();
        super.parse(args);
        if (this._help) {
            return;
        }
        this.setMakeFullPath(this._commandLine.hasOption(OPTION_MAKE_FULL_PATH));
        String[] remainingArgs = this._commandLine.getArgs();
        if (remainingArgs.length == 0 || remainingArgs.length > 1) {
            this._help = true;
            return;
        }
        this.setFolderPath(remainingArgs[0]);
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtRuntimeExceptionHandler(true, 8));
        MakeFolder2 makeFolder = new MakeFolder2();
        try {
            makeFolder.parse(args);
            if (makeFolder._help) {
                HelpFormatter help = new HelpFormatter();
                String[] exclusions = new String[]{"debug", "nolog"};
                org.apache.commons.cli.Options helpOptions = MakeFolder2.getHelpOptions(makeFolder._options, exclusions);
                help.printHelp(80, MakeFolder2.getUsage(help), RB.getStringResource("MakeFolder.Options.txt"), helpOptions, null);
                return;
            }
            makeFolder.makeFolder();
        }
        catch (Exception e) {
            makeFolder.logException(e);
        }
        makeFolder.logCompletion();
        System.exit(makeFolder.getReturnCode());
    }

    private static String getUsage(HelpFormatter help) {
        StringBuffer usage = new StringBuffer();
        usage.append(RB.getStringResource("MakeFolder.HelpUsage.txt"));
        return usage.toString();
    }

    protected class Options
    extends BatchDriverOptions {
        private static final long serialVersionUID = 1L;

        public Options() {
            Option option = new Option(MakeFolder2.OPTION_MAKE_FULL_PATH, RB.getStringResource("MakeFolder.CreateIntermediateFolders.txt"));
            this.addOption(option);
        }
    }
}

