/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.batch;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.OperationUserInteraction2Interface;
import com.sas.metadata.logical.batch.BatchDriver2;
import com.sas.metadata.logical.batch.BatchDriverOptions;
import com.sas.metadata.logical.batch.ConfigPropertiesInstaller2;
import com.sas.metadata.logical.batch.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.text.Message;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;

@SASScope
public class BatchDelete2
extends BatchDriver2 {
    public static final String OPTION_DELETE_CONTENTS = "deleteContents";
    private boolean _deleteContents = false;
    private String[] _objects = null;
    private String _productID = null;
    private String _productKey = null;

    public BatchDelete2() {
        this._utilityName = "DeleteObjects";
        this._logTimestamps = false;
        this._logFileDisabled = true;
    }

    public BatchDelete2(String host, String port, String user, String password) {
        this();
        this.setConnection(host, port);
        this.setCredential(user, password);
    }

    public BatchDelete2(SessionContextInterface session) throws ServiceException, RemoteException {
        this();
        this.setConnection(session);
    }

    public static int deleteObject(BatchDriver2 parent, String object, boolean deleteContents) throws Exception {
        BatchDelete2 del = new BatchDelete2();
        del.setParent(parent);
        del.setObjects(object);
        del.setDeleteContents(deleteContents);
        int rc = del.delete();
        try {
            del.terminate();
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        return rc;
    }

    public void setDeleteContents(boolean deleteContents) {
        this._deleteContents = deleteContents;
    }

    public void setObjects(String object) {
        this._objects = new String[1];
        this._objects[0] = object;
    }

    public void setObjects(String[] objects) {
        this._objects = objects;
    }

    public void setConfigurationProductID(String prodID) {
        this._productID = prodID;
    }

    public void setConfigurationProductKey(String prodKey) {
        this._productKey = prodKey;
    }

    @Override
    public void initialize() throws ServiceException, LogicalTypeException, RemoteException {
        super.initialize();
        super.initializeWorkspace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete() {
        if (this._objects == null && this._productID == null) {
            this._logger.error(RB.getStringResource("BatchDelete.NoObjectsToDelete.log"));
            return 8;
        }
        try {
            this.initialize();
            this.logStart();
            this.logConnectionInfo();
            Factory logicalObjectFactory = Factory.getInstance();
            UnpromptedOperation operation = new UnpromptedOperation();
            if (this._productID != null) {
                this._rc |= this.readConfigurationProperties();
            }
            for (PathUrl path : this.sortObjectPaths(this._server, this._objects)) {
                String objectPath = path.getAbsolutePath();
                LogicalObjectInterface logicalObject = logicalObjectFactory.getObjectByPath(path);
                if (logicalObject == null) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"BatchDelete.ObjectDoesNotExist.fmt.log", (Object)objectPath));
                    this._rc |= 4;
                    continue;
                }
                if (!logicalObject.isDeleteAllowed()) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"BatchDelete.DeleteNotAllowed.fmt.log", (Object)objectPath));
                    this._rc |= 4;
                    continue;
                }
                if (!this._deleteContents && logicalObject instanceof FolderInterface && !((FolderInterface)logicalObject).isEmpty()) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"BatchDelete.FolderNotEmpty.fmt.log", (Object)objectPath));
                    this._rc |= 4;
                    continue;
                }
                if (logicalObject.delete(operation)) {
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"BatchDelete.DeleteSucceeded.fmt.log", (Object)objectPath));
                    continue;
                }
                this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"BatchDelete.DeleteFailed.fmt.log", (Object)objectPath));
                this._rc |= 8;
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
        finally {
            try {
                this.terminate();
            }
            catch (Exception e) {
                this.logException(e);
            }
        }
        return this._rc;
    }

    private int readConfigurationProperties() throws Exception {
        ArrayList<String> objectPaths = new ArrayList<String>();
        ConfigPropertiesInstaller2 props = new ConfigPropertiesInstaller2(this._productID, this._factory, this._logger);
        int rc = props.loadConfigurationProperties(objectPaths, this._productKey);
        if (objectPaths.size() > 0) {
            String[] paths = objectPaths.toArray(new String[objectPaths.size()]);
            this.setObjects(paths);
        }
        return rc;
    }

    public List<PathUrl> sortObjectPaths(ServerInterface server, String[] paths) throws ServiceException, RemoteException {
        ArrayList<PathUrl> objectPaths = new ArrayList<PathUrl>();
        if (paths != null) {
            for (String objectPath : paths) {
                PathUrl path;
                if (objectPath == null || objectPath.length() <= 0) continue;
                if (!objectPath.endsWith("/") && !objectPath.endsWith(")")) {
                    objectPath = objectPath + "/";
                }
                if ((path = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)objectPath)).getType() == null) {
                    path.setType("Folder");
                }
                objectPaths.add(path);
            }
        }
        if (objectPaths.size() > 1) {
            Collections.sort(objectPaths, new PathSorter());
        }
        return objectPaths;
    }

    @Override
    protected void parse(String[] args) throws ParseException, MissingOptionException {
        this._options = new Options();
        super.parse(args);
        if (this._help) {
            return;
        }
        if (this._commandLine.hasOption("configProductID")) {
            this._productID = this._commandLine.getOptionValue("configProductID");
        }
        if (this._commandLine.hasOption("configProductKey")) {
            this._productKey = this._commandLine.getOptionValue("configProductKey");
        }
        if (this._productID == null) {
            this.setDeleteContents(this._commandLine.hasOption(OPTION_DELETE_CONTENTS));
            String[] remainingArgs = this._commandLine.getArgs();
            if (remainingArgs.length == 0) {
                this._help = true;
                return;
            }
            if (remainingArgs != null && remainingArgs.length > 0) {
                this.setObjects(remainingArgs);
            }
        }
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtRuntimeExceptionHandler(true, 8));
        BatchDelete2 batchDelete = new BatchDelete2();
        try {
            batchDelete.parse(args);
            if (batchDelete._help) {
                HelpFormatter help = new HelpFormatter();
                String[] exclusions = new String[]{"debug", "nolog", "configProductID", "configProductKey"};
                org.apache.commons.cli.Options helpOptions = BatchDelete2.getHelpOptions(batchDelete._options, exclusions);
                help.printHelp(80, BatchDelete2.getUsage(help), RB.getStringResource("BatchDelete.Options.txt"), helpOptions, null);
                return;
            }
            batchDelete.delete();
        }
        catch (Exception e) {
            batchDelete.logException(e);
        }
        batchDelete.logCompletion();
        System.exit(batchDelete.getReturnCode());
    }

    private static String getUsage(HelpFormatter help) {
        StringBuffer usage = new StringBuffer();
        usage.append(RB.getStringResource("BatchDelete.HelpUsage.txt"));
        return usage.toString();
    }

    private class UnpromptedOperation
    implements OperationUserInteraction2Interface {
        private boolean _operationCancelled;
        private Map<String, Object> _userObjectCache;

        private UnpromptedOperation() {
        }

        @Override
        public boolean continueOperationWithPrompting() {
            return false;
        }

        @Override
        public int displayMessage(String title, String messageText, int messageType, int[] choiceSet) {
            return 1;
        }

        @Override
        public boolean isOperationCancelled() {
            return this._operationCancelled;
        }

        @Override
        public void setContinueOperationWithPrompting(boolean value) {
        }

        @Override
        public void setOperationCancelled(boolean value) {
            this._operationCancelled = value;
        }

        @Override
        public void updateProgress(String messageText) {
            BatchDelete2.this._logger.debug(messageText);
        }

        @Override
        public boolean isUserInteractionSupported() {
            return false;
        }

        @Override
        public void setUserObject(String key, Object value) {
            if (this._userObjectCache == null) {
                this._userObjectCache = new HashMap<String, Object>();
            }
            this._userObjectCache.put(key, value);
        }

        @Override
        public Object getUserObject(String key) {
            return this._userObjectCache == null ? null : this._userObjectCache.get(key);
        }
    }

    private class PathSorter
    implements Comparator<PathUrl> {
        private PathSorter() {
        }

        @Override
        public int compare(PathUrl path1, PathUrl path2) {
            if (path1 == path2) {
                return 0;
            }
            if (path1 == null) {
                return -1;
            }
            if (path2 == null) {
                return 1;
            }
            return this.runCompare(path1, path2);
        }

        private int runCompare(PathUrl path1, PathUrl path2) {
            int level2;
            if (path1 == null) {
                return 1;
            }
            if (path2 == null) {
                return -1;
            }
            String type1 = path1.getType();
            String type2 = path2.getType();
            if (type1 == null) {
                return -1;
            }
            if (type2 == null) {
                return 1;
            }
            int level1 = this.getLevel(path1.getDisplayPath());
            if (level1 == (level2 = this.getLevel(path2.getDisplayPath()))) {
                boolean matchingTypes = type1.equalsIgnoreCase(type2);
                if (!matchingTypes && "Folder".equalsIgnoreCase(type1)) {
                    return 1;
                }
                if (!matchingTypes && "Folder".equalsIgnoreCase(type2)) {
                    return -1;
                }
                String name1 = path1.getName();
                String name2 = path2.getName();
                if (name1 != null && name2 != null) {
                    return name1.compareToIgnoreCase(name2);
                }
                return 1;
            }
            if (level1 < level2) {
                return 1;
            }
            return -1;
        }

        private int getLevel(String path) {
            int level = 0;
            if (path != null) {
                if (path.endsWith("/") && (path = path.substring(0, path.length() - 1)).equalsIgnoreCase("/")) {
                    return 0;
                }
                int length = path.length();
                for (int i = 0; i < length; ++i) {
                    char c = path.charAt(i);
                    if (c != '/') continue;
                    ++level;
                }
            }
            return level;
        }
    }

    protected class Options
    extends BatchDriverOptions {
        private static final long serialVersionUID = 1L;

        public Options() {
            Option option = new Option(BatchDelete2.OPTION_DELETE_CONTENTS, RB.getStringResource("BatchDelete.Options.DeleteContents.Desc.txt"));
            this.addOption(option);
            this.addOption(ConfigPropertiesInstaller2.getProductIDOption());
            this.addOption(ConfigPropertiesInstaller2.getProductKeyOption());
        }
    }
}

