/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.UtilReportRepositoryService;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;

public class UtilPlatformServices {
    private static SessionContextInterface _sessionContextInterface;
    private static UserContextInterface _userContextInterface;
    private static MetadataServerInterface _metadataServerInterface;

    static void setSessionContext(SessionContextInterface sessionContextInterface) throws IllegalStateException, RemoteException, ServiceException, LogicalTypeException {
        _sessionContextInterface = sessionContextInterface;
        _userContextInterface = sessionContextInterface.getUserContext();
        _metadataServerInterface = (MetadataServerInterface)_userContextInterface.getAuthServer();
        UtilReportRepositoryService.init();
    }

    public static SessionContextInterface getSessionContext() {
        if (_sessionContextInterface == null) {
            throw new IllegalStateException("Session Context is null.");
        }
        return _sessionContextInterface;
    }

    public static UserContextInterface getUserContext() {
        if (_userContextInterface == null) {
            throw new IllegalStateException("User Context is null.");
        }
        return _userContextInterface;
    }

    public static MetadataInterface getSmartObject(String absolutePath) throws ServiceException, RemoteException {
        if (absolutePath == null) {
            throw new IllegalStateException("Logic error: parameter must not be null.");
        }
        PathUrl pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)_metadataServerInterface, (String)absolutePath);
        return _metadataServerInterface.getObjectByPath(pathUrl);
    }

    public static MetadataInterface getSmartObject(Root root) throws ServiceException, RemoteException {
        if (root == null) {
            throw new IllegalStateException("Logic error: parameter must not be null.");
        }
        return UtilPlatformServices.getSmartObject(root.getFQID(), root.getCMetadataType());
    }

    public static MetadataInterface getSmartObject(SimpleLogicalObjectInterface logicalObject) throws ServiceException, RemoteException {
        if (logicalObject == null) {
            throw new IllegalStateException("Logic error: parameter must not be null.");
        }
        String mdObjType = logicalObject.getTypeInterface().getMetadataType();
        return UtilPlatformServices.getSmartObject(logicalObject.getID(), mdObjType);
    }

    public static MetadataInterface getSmartObject(String mdObjFQID, String mdObjType) throws ServiceException, RemoteException {
        String infoSvcsKey = mdObjFQID + "/" + mdObjType;
        return _metadataServerInterface.fetch(infoSvcsKey, true);
    }

    public static void destroy() {
        _userContextInterface = null;
        _sessionContextInterface = null;
        _metadataServerInterface = null;
        UtilReportRepositoryService.destroy();
    }

    public static DetachedTransaction getDetachedTransaction() throws LogicalTypeException, RemoteException {
        return new DetachedTransaction();
    }

    public static class DetachedTransaction {
        ChildServerInterface _childServer;

        private DetachedTransaction() throws LogicalTypeException, RemoteException {
            try {
                this._childServer = _metadataServerInterface.newChild(true);
            }
            catch (ServiceException e) {
                throw new LogicalTypeException((Exception)((Object)e));
            }
        }

        public MetadataInterface getSmartObject(Root root) throws LogicalTypeException, RemoteException {
            if (root == null) {
                throw new IllegalStateException("Logic error: parameter must not be null.");
            }
            return this.getSmartObject(root.getFQID(), root.getCMetadataType());
        }

        public MetadataInterface getSmartObject(SimpleLogicalObjectInterface logicalObject) throws LogicalTypeException, RemoteException {
            if (logicalObject == null) {
                throw new IllegalStateException("Logic error: parameter must not be null.");
            }
            String mdObjType = logicalObject.getTypeInterface().getMetadataType();
            return this.getSmartObject(logicalObject.getID(), mdObjType);
        }

        public MetadataInterface getSmartObject(String mdObjFQID, String mdObjType) throws LogicalTypeException, RemoteException {
            String infoSvcsKey = mdObjFQID + "/" + mdObjType;
            try {
                return this._childServer.fetch(infoSvcsKey, true);
            }
            catch (ServiceException e) {
                throw new LogicalTypeException((Exception)((Object)e));
            }
        }

        public void rollback() throws RemoteException, LogicalTypeException {
            try {
                this._childServer.rollback();
            }
            catch (ServiceException e) {
                throw new LogicalTypeException((Exception)((Object)e));
            }
        }
    }
}

