/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical;

import com.sas.meta.SASOMI.ISecurity;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.RB;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.remote.entities.MdOMAEntityUtility;
import com.sas.services.util.Names;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.StringHolder;

public class UtilMetadata {
    public static final int SIZE_DESCRIPTION = 200;
    public static final int SIZE_NAME = 60;
    public static final int SIZE_PROPERTY_NAME = 200;
    public static final String BIP_FOLDER = "BIP Folder";
    public static final String OMR_NAME_BIP_SERVICE = "BIP Service";
    public static final String BIP_SERVICE_CLASSID = "E5F27790-2149-11D6-8828-AA0004006D06";
    public static final String BIP_FOLDER_PUBLICTYPE = "Folder";
    public static final String HTTP_SERVER_CLASSID = "DAC0D7F0-10DA-11D6-8816-AA0004006D06";
    public static final String HTTP_SERVER_BASE_PATH_PROPERTY_NAME = "HttpServerBasePath";
    public static final String HTTP_SERVER_SUPPORTS_DAV_PROPERTY_NAME = "SupportsWebDAV";
    public static final String QMGR_SERVER_WEBSPHERE_CLASSID = "MessageQueue.Websphere";
    public static final String QMGR_SERVER_MSMQ_CLASSID = "MessageQueue.MSMQ";
    public static final String MESSAGE_QUEUE_TRANSFORM_ROLE = "SASMessageQueue";
    public static final String REPORT_REPOSITORY_CM_NAME = "Report Repository Content Mapping";
    public static final String REPORT_REPOSITORY_CM_DOCUMENT_URITYPE_FILE = "File";
    public static final String REPORT_REPOSITORY_CM_DOCUMENT_URITYPE_DAV = "DAV";
    public static final String REPORT_REPOSITORY_CM_TEXTSTORE_TEXTTYPE = "PlainText";
    public static final String OMR_NAME_PROPERTY_TYPE = "BIM Property Type";
    static List _entityPropertyTypes;
    static String _repositoryIDForCachedEntityPropertyTypes;
    private static DateFormat g_fmtParse;

    public static CMetadata createANewStoreAndGetObjectIntoIt(CMetadata source) throws MdException, RemoteException {
        MdObjectStore newStore = Factory.getInstance().getMdFactory().createObjectStore();
        String objectID = source.getFQID();
        return Factory.getInstance().getOMIUtil().getMetadataAllDepths((MdStore)newStore, source.getCMetadataType(), objectID, null, null, null, 264);
    }

    public static CMetadata createAChildStoreAndCopyObjectIntoIt(CMetadata source) throws RemoteException {
        MdObjectStore targetChildStore = Factory.getInstance().getMdFactory().createObjectStore(source.getObjectStore());
        CMetadata copy = Factory.getInstance().getMdFactory().createComplexMetadataObject(targetChildStore, source);
        return copy;
    }

    public static CMetadata copyExistingObjectIntoDifferentStore(MdObjectStore targetStore, CMetadata source) throws RemoteException {
        MdStoreUtil.copyMetaObject((MdStore)source.getObjectStore(), (MdStore)targetStore, (String)source.getFQID());
        CMetadata copy = Factory.getInstance().getMdFactory().createComplexMetadataObject(targetStore, source);
        return copy;
    }

    public static CMetadata createANewComplexObjectToBeAssociatedWithGivenObject(CMetadata source, String name, String type) throws RemoteException {
        CMetadata newObject = Factory.getInstance().getMdFactory().createComplexMetadataObject((MdObjectStore)source.getObjectStore(), null, name, type, source.getRepositoryID());
        return newObject;
    }

    public static CMetadata createANewComplexObjectInANewChildStore(CMetadata source, String name, String type) throws RemoteException {
        MdObjectStore childStore = Factory.getInstance().getMdFactory().createObjectStore(source.getObjectStore());
        CMetadata newObject = Factory.getInstance().getMdFactory().createComplexMetadataObject(childStore, null, name, type, source.getRepositoryID());
        return newObject;
    }

    public static CMetadata createANewComplexObjectInANewStore(String name, String type, String repository8CharID) throws RemoteException {
        MdObjectStore store = Factory.getInstance().getMdFactory().createObjectStore();
        CMetadata newObject = Factory.getInstance().getMdFactory().createComplexMetadataObject(store, null, name, type, repository8CharID);
        return newObject;
    }

    public static CMetadata createAnExistingObjectInANewStore(CMetadata source) throws RemoteException {
        MdObjectStore store = Factory.getInstance().getMdFactory().createObjectStore();
        CMetadata object = Factory.getInstance().getMdFactory().createComplexMetadataObject(store, null, source.getName(), source.getCMetadataType(), source.getFQID());
        return object;
    }

    public static CMetadata locateExistingObject(MdObjectStore store, String type, String fqid) throws MdException, RemoteException {
        int options = 8;
        CMetadata object = Factory.getInstance().getOMIUtil().getMetadataAllDepths((MdStore)store, type, fqid, null, null, null, options);
        return object;
    }

    public static CMetadata locateExistingObject(MdObjectStore store, String type, String fqid, String template) throws MdException, RemoteException {
        int options = 268;
        CMetadata object = Factory.getInstance().getOMIUtil().getMetadataAllDepths((MdStore)store, type, fqid, null, null, template, options);
        return object;
    }

    public static String makeRepositoryFQIDFromRoot(Root root) throws RemoteException {
        return Factory.getInstance().getOMIUtil().getReposIdFromMetadataObject((CMetadata)root);
    }

    public static String makeRepositoryFQIDFromRoot(String metadataObjectID) {
        String shortReposID = metadataObjectID.substring(0, 8);
        return "A0000001." + shortReposID;
    }

    public static Property addPropertyToObject(Root object, String propertyName, String propertyRole, String defaultValue) throws MdException, RemoteException {
        PropertyType owningType;
        Property property = (Property)UtilMetadata.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)object, propertyName, "Property");
        property.setPropertyName(propertyName);
        property.setPropertyRole(propertyRole);
        if (defaultValue != null) {
            property.setDefaultValue(defaultValue);
        }
        if ((owningType = MdOMAEntityUtility.getGenericPropertyType((Root)property)) == null) {
            owningType = (PropertyType)UtilMetadata.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)property, OMR_NAME_PROPERTY_TYPE, "PropertyType");
            owningType.setSQLType(12);
        }
        property.setOwningType(owningType);
        object.getProperties().add((Object)property);
        return property;
    }

    public static void setBooleanPropertyValue(Root root, String propertyName, boolean value) throws MdException, RemoteException {
        Property property = UtilMetadata.getProperty(root, propertyName, null);
        if (value) {
            if (property == null) {
                property = UtilMetadata.addPropertyToObject(root, propertyName, "", null);
            }
            property.setDefaultValue("1");
        } else if (property != null) {
            property.setDefaultValue("0");
        }
    }

    public static boolean getBooleanPropertyValue(Root root, String propertyName) throws MdException, RemoteException {
        return UtilMetadata.checkPropertyNamePresence(root, propertyName, "0", false);
    }

    public static Property getProperty(Root object, String propertyName, String propertyRole) throws MdException, RemoteException {
        for (Property p : object.getProperties()) {
            if (propertyName != null && p.getPropertyName().equalsIgnoreCase(propertyName)) {
                return p;
            }
            if (propertyRole == null || !p.getPropertyRole().equalsIgnoreCase(propertyRole)) continue;
            return p;
        }
        return null;
    }

    public static Property getPropertyByValue(Root object, String propertyName, String propertyRole, String value) throws MdException, RemoteException {
        if (value == null) {
            throw new IllegalArgumentException("method shouldn't be called with a null value");
        }
        Property p = UtilMetadata.getProperty(object, propertyName, propertyRole);
        if (p == null) {
            return null;
        }
        if (p.getDefaultValue().equals(value)) {
            return p;
        }
        return null;
    }

    public static boolean checkPropertyRolePresence(Root object, String propertyRole, String defaultValue, boolean equals) throws MdException, RemoteException {
        for (Property p : object.getProperties()) {
            if (!p.getPropertyRole().equalsIgnoreCase(propertyRole)) continue;
            if (defaultValue == null) {
                return true;
            }
            if (equals) {
                return defaultValue.equals(p.getDefaultValue());
            }
            return !defaultValue.equals(p.getDefaultValue());
        }
        return false;
    }

    public static boolean checkPropertyNamePresence(Root object, String propertyName, String defaultValue, boolean equals) throws MdException, RemoteException {
        for (Property p : object.getProperties()) {
            if (!p.getPropertyName().equalsIgnoreCase(propertyName)) continue;
            if (defaultValue == null) {
                return true;
            }
            if (equals) {
                return defaultValue.equals(p.getDefaultValue());
            }
            return !defaultValue.equals(p.getDefaultValue());
        }
        return false;
    }

    public static void deleteAllProperties(Root root) throws MdException, RemoteException {
        UtilMetadata.deleteAllAssociatedObjects(root.getProperties());
    }

    public static void deleteObjects(ArrayList objList) throws MdException, RemoteException {
        for (Root root : objList) {
            if (root instanceof Property) {
                UtilMetadata.deleteProperty((Property)root);
                continue;
            }
            root.delete();
        }
    }

    public static void deleteProperty(Property property) throws MdException, RemoteException {
        PropertyType propertyType = property.getOwningType();
        if (propertyType != null) {
            boolean canDeletePropertyType = true;
            List list = UtilMetadata.getEntityPropertyTypes((Root)propertyType);
            if (list != null) {
                String ptID = propertyType.getFQID();
                for (String id : list) {
                    if (!ptID.equals(id)) continue;
                    canDeletePropertyType = false;
                    break;
                }
            }
            if (canDeletePropertyType) {
                AssociationList alArrayTypes = propertyType.getArrayTypes();
                AssociationList alGroups = propertyType.getGroups();
                AssociationList alTypedAttProperties = propertyType.getTypedAttProperties();
                AssociationList alTypedProperties = propertyType.getTypedProperties();
                if (alArrayTypes.size() != 0 || alGroups.size() != 0 || alTypedAttProperties.size() != 0 || alTypedProperties.size() != 1) {
                    canDeletePropertyType = false;
                }
            }
            if (canDeletePropertyType) {
                propertyType.delete();
            }
        }
        property.delete();
    }

    static List getEntityPropertyTypes(Root root) throws RemoteException {
        boolean getEntityPropertyTypes = false;
        if (_entityPropertyTypes == null) {
            getEntityPropertyTypes = true;
        } else {
            String reposID = root.getRepositoryID();
            if (!reposID.equals(_repositoryIDForCachedEntityPropertyTypes)) {
                getEntityPropertyTypes = true;
            }
        }
        if (getEntityPropertyTypes) {
            try {
                _entityPropertyTypes = MdOMAEntityUtility.getPropertyTypesForObjectRepositoryIDList((Root)root);
                _repositoryIDForCachedEntityPropertyTypes = root.getRepositoryID();
            }
            catch (MdException e) {
                _entityPropertyTypes = null;
            }
        }
        return _entityPropertyTypes;
    }

    public static void deleteAllAssociatedObjects(AssociationList al) throws MdException, RemoteException {
        ArrayList<Root> objList = new ArrayList<Root>();
        for (Root root : al) {
            objList.add(root);
        }
        UtilMetadata.deleteObjects(objList);
    }

    public static List<PrimaryType> getBIObjectsFromTree(TypeInterface ti, Tree tree) throws MdException, RemoteException {
        String publicType = ti.getPublicType();
        Iterator it = tree.getMembers(true).iterator();
        ArrayList<PrimaryType> list = new ArrayList<PrimaryType>();
        while (it.hasNext()) {
            PrimaryType pt;
            Object o = it.next();
            if (!(o instanceof PrimaryType) || !publicType.equalsIgnoreCase((pt = (PrimaryType)o).getPublicType())) continue;
            list.add(pt);
        }
        return list;
    }

    public static boolean treeExists(Tree tree, String name) throws MdException, RemoteException {
        for (Tree t : tree.getSubTrees(true)) {
            if (!t.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static String getRepositoryName(String reposID) throws MdException, RemoteException {
        if (reposID.length() <= 0) {
            return "";
        }
        if (reposID.length() < 10) {
            reposID = "A0000001." + reposID;
        }
        String repositoryName = "";
        for (CMetadata repos : Factory.getInstance().getOMIUtil().getRepositories()) {
            if (!repos.getFQID().equals(reposID)) continue;
            repositoryName = repos.getName();
            break;
        }
        return repositoryName;
    }

    public static String getFoundationRepositoryID() throws MdException, RemoteException {
        return Factory.getInstance().getOMIUtil().getFoundationReposID();
    }

    public static SoftwareComponent locateSoftwareComponent(String repositoryFQID, MdObjectStore objectStore) throws MdException, RemoteException {
        int flags = 392;
        List softwareComponents = Factory.getInstance().getOMIUtil().getMetadataObjectsSubset((MdStore)objectStore, repositoryFQID, "SoftwareComponent", flags, "<XMLSELECT search=\"@ClassIdentifier = 'E5F27790-2149-11D6-8828-AA0004006D06' and @Name = 'BIP Service'\"/>", false);
        int count = softwareComponents.size();
        if (count == 1) {
            return (SoftwareComponent)softwareComponents.get(0);
        }
        String name = UtilMetadata.getRepositoryName(repositoryFQID);
        if (name.length() == 0) {
            name = repositoryFQID;
        }
        if (count == 0) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.NoSC.ex.fmt.txt", (Object)name);
            throw new MdException(msg);
        }
        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.MulSC.ex.fmt.txt", (Object)name);
        throw new MdException(msg);
    }

    public static SoftwareComponent locateFoundationSoftwareComponentFromTopLevelTree(Tree tree) throws MdException, RemoteException {
        String foundationRepositoryID = UtilMetadata.getFoundationRepositoryID().substring(9);
        Iterator it = tree.getSoftwareComponents().iterator();
        ArrayList<SoftwareComponent> softwareComponents = new ArrayList<SoftwareComponent>();
        while (it.hasNext()) {
            SoftwareComponent sc = (SoftwareComponent)it.next();
            String scReposid = UtilMetadata.get8CharReposidFromFQID(sc.getFQID());
            if (!sc.getClassIdentifier().equalsIgnoreCase(BIP_SERVICE_CLASSID) || !sc.getName().equalsIgnoreCase(OMR_NAME_BIP_SERVICE) || !scReposid.equalsIgnoreCase(foundationRepositoryID)) continue;
            softwareComponents.add(sc);
        }
        int count = softwareComponents.size();
        if (count == 1) {
            return (SoftwareComponent)softwareComponents.get(0);
        }
        String repositoryFQID = UtilMetadata.makeRepositoryFQIDFromRoot((Root)tree);
        String name = UtilMetadata.getRepositoryName(repositoryFQID);
        if (name.length() == 0) {
            name = repositoryFQID;
        }
        if (count == 0) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.NoSC.ex.fmt.txt", (Object)name);
            throw new MdException(msg);
        }
        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"COM.MulSC.ex.fmt.txt", (Object)name);
        throw new MdException(msg);
    }

    public static List<ServerComponent> locateDAVServers(MdStore objectStore, String repositoryFQID) throws MdException, RemoteException {
        int flags = 8584;
        List servers = Factory.getInstance().getOMIUtil().getMetadataObjectsSubset(objectStore, repositoryFQID, "ServerComponent", flags, "<XMLSELECT search=\"ServerComponent[@ClassIdentifier='DAC0D7F0-10DA-11D6-8816-AA0004006D06'][DataPackages/Directory/Properties/Property[@PropertyName='SupportsWebDAV']]\"/>");
        return servers;
    }

    public static List locateHTTPServers(MdStore objectStore, String repositoryFQID) throws MdException, RemoteException {
        int flags = 8584;
        List servers = Factory.getInstance().getOMIUtil().getMetadataObjectsSubset(objectStore, repositoryFQID, "ServerComponent", flags, "<XMLSELECT search=\"ServerComponent[@ClassIdentifier='DAC0D7F0-10DA-11D6-8816-AA0004006D06']\"/>");
        return servers;
    }

    public static List locateQueueManagerServers(MdStore objectStore, String repositoryFQID) throws MdException, RemoteException {
        int flags = 8584;
        List servers = Factory.getInstance().getOMIUtil().getMetadataObjectsSubset(objectStore, repositoryFQID, "ServerComponent", flags, "<XMLSELECT search=\"ServerComponent[@ClassIdentifier='MessageQueue.Websphere'  OR @ClassIdentifier='MessageQueue.MSMQ' ]\"/>");
        return servers;
    }

    public static List<Directory> getDAVServerBasePaths(ServerComponent davServer) throws MdException, RemoteException {
        ArrayList<Directory> list = new ArrayList<Directory>();
        for (Object o : davServer.getDataPackages(true)) {
            Directory d;
            if (!(o instanceof Directory) || !UtilMetadata.checkPropertyNamePresence((Root)(d = (Directory)o), HTTP_SERVER_BASE_PATH_PROPERTY_NAME, "0", false) || !UtilMetadata.checkPropertyNamePresence((Root)d, HTTP_SERVER_SUPPORTS_DAV_PROPERTY_NAME, "0", false)) continue;
            list.add(d);
        }
        return list;
    }

    public static List<Directory> getHTTPServerBasePaths(ServerComponent davServer) throws MdException, RemoteException {
        ArrayList<Directory> list = new ArrayList<Directory>();
        for (Directory d : davServer.getDataPackages(true)) {
            if (!UtilMetadata.checkPropertyNamePresence((Root)d, HTTP_SERVER_BASE_PATH_PROPERTY_NAME, "0", false)) continue;
            list.add(d);
        }
        return list;
    }

    public static List getQueues(ServerComponent qMgr) throws MdException, RemoteException {
        ArrayList<Transformation> list = new ArrayList<Transformation>();
        for (Object o : qMgr.getInitProcesses(true)) {
            Transformation t;
            if (!(o instanceof Transformation) || !(t = (Transformation)o).getTransformRole().equals(MESSAGE_QUEUE_TRANSFORM_ROLE)) continue;
            list.add(t);
        }
        return list;
    }

    public static boolean validateCharactersInNameOfItemInFolder(String name) throws LogicalTypeException {
        try {
            return Names.validateOMRObjectName((String)name, (boolean)true);
        }
        catch (IllegalArgumentException iae) {
            throw new LogicalTypeException(iae.getMessage());
        }
    }

    public static boolean validateStreamName(String name) throws LogicalTypeException {
        try {
            return Names.validateSASFilerefName((String)name, (boolean)true);
        }
        catch (IllegalArgumentException iae) {
            throw new LogicalTypeException(iae.getMessage());
        }
    }

    public static String getPath(Tree tree, boolean goToServer) throws MdException, RemoteException {
        if (goToServer) {
            String template = "<Templates><Tree Name=\"\"><ParentTree/></Tree></Templates>";
            Factory.getInstance().getOMIUtil().getMetadataAllDepths((CMetadata)tree, null, null, template, 4);
        }
        Tree element = tree;
        String location = element.getName();
        while (element.getParentTree() != null) {
            element = element.getParentTree();
            location = element.getName() + "/" + location;
        }
        location = "/" + location;
        return location;
    }

    public static String getPathWhichMayBeIncomplete(Tree tree, boolean goToServer) throws MdException, RemoteException {
        Tree next;
        if (goToServer) {
            String template = "<Templates><Tree Name=\"\"><ParentTree/><SoftwareComponents/></Tree></Templates>";
            Factory.getInstance().getOMIUtil().getMetadataAllDepths((CMetadata)tree, null, null, template, 4);
        }
        String location = tree.getName();
        while ((next = tree.getParentTree()) != null) {
            location = next.getName() + "/" + location;
            tree = next;
        }
        location = "/" + location;
        if (tree.getSoftwareComponents().size() == 0) {
            location = Message.format((ResourceBundle)RB.getResources(), (String)"UM.unknown.fmt.txt", (Object)location);
        }
        return location;
    }

    public static boolean checkRootPermission(Factory factory, String cMetadataType, String fqid, String permission) throws LogicalTypeException {
        ISecurity is = factory.getISecurity();
        if (is == null) {
            throw new LogicalTypeException(RB.getStringResource("UM.NoIS.txt"));
        }
        String resource = "OMSOBJ:" + cMetadataType + "/" + fqid;
        StringHolder permissionCondition = new StringHolder();
        BooleanHolder authorized = new BooleanHolder();
        try {
            is.IsAuthorized("", resource, permission, permissionCondition, authorized);
            return authorized.value;
        }
        catch (Exception e) {
            throw new LogicalTypeException(e);
        }
    }

    public static String get8CharReposidFromFQID(String fqid) {
        String id = fqid.substring(0, 8);
        if (id.length() < 8) {
            throw new IllegalStateException("Logic error: fqid passed in " + fqid + " is malformed.");
        }
        return id;
    }

    public static Root getJOMAObjectFromLogicalObject(LogicalObjectInterface loi, MdObjectStore store) throws MdException, RemoteException {
        return (Root)Factory.getInstance().getOMIUtil().getMetadataAllDepths((MdStore)store, loi.getTypeInterface().getMetadataType(), loi.getID(), null, null, null, 264);
    }

    static List<Tree> getChildTreesFromSoftwareComponent(SoftwareComponent softwareComponent) throws MdException, RemoteException, MdException {
        ArrayList<Tree> list = new ArrayList<Tree>();
        Iterator it = softwareComponent.getSoftwareTrees(true).iterator();
        while (it.hasNext()) {
            list.add((Tree)it.next());
        }
        return list;
    }

    static List<Tree> getChildTreesFromTree(Tree tree) throws MdException, RemoteException {
        ArrayList<Tree> list = new ArrayList<Tree>();
        Iterator it = tree.getSubTrees(true).iterator();
        while (it.hasNext()) {
            list.add((Tree)it.next());
        }
        return list;
    }

    static Tree getTopLevelTree(MdObjectStore store, FolderInterface flo) throws RemoteException, MdException {
        HashSet<String> loopCheckerSet = new HashSet<String>();
        Tree topLevel = (Tree)UtilMetadata.locateExistingObject(store, flo.getTypeInterface().getMetadataType(), flo.getID(), "<Templates><Tree><ParentTree/><SoftwareComponents/></Tree></Templates>");
        while (true) {
            loopCheckerSet.add(topLevel.getFQID());
            Tree temp = topLevel.getParentTree();
            if (temp == null) {
                if (topLevel.getSoftwareComponents().size() != 0) break;
                throw new MdException("Missing SoftwareComponent association for " + topLevel.getFQID() + ".");
            }
            if (loopCheckerSet.contains(temp.getFQID())) {
                throw new MdException("Invalid parentTree association: an ancestor of " + flo.getID() + " is " + temp.getFQID() + " which is inconsistent.");
            }
            topLevel = temp;
        }
        return topLevel;
    }

    public static Date parseUnformattedDate(String sDate) throws NumberFormatException {
        double secondsSince1Jan1960 = Double.parseDouble(sDate);
        double secondsSince1Jan1970 = secondsSince1Jan1960 - 3.156192E8;
        long millisecondsSince1Jan1970 = (long)(secondsSince1Jan1970 * 1000.0);
        return new Date(millisecondsSince1Jan1970);
    }

    public static Date parseFormattedDate(String sDate) throws ParseException {
        return g_fmtParse.parse(sDate + " GMT");
    }

    public static Date parseDate(String sDate) throws ParseException {
        try {
            return UtilMetadata.parseUnformattedDate(sDate);
        }
        catch (NumberFormatException ex) {
            return g_fmtParse.parse(sDate + " GMT");
        }
    }

    public static boolean setPublicType(PrimaryType metaObj, String publicType) throws RemoteException {
        boolean bMetadataChanges = false;
        String objPublicType = metaObj.getPublicType();
        if (objPublicType == null || !publicType.equals(objPublicType)) {
            bMetadataChanges = true;
            metaObj.setPublicType(publicType);
        }
        return bMetadataChanges;
    }

    public static boolean setUsageVersion(Root metaObj, UsageVersion current) throws RemoteException {
        boolean bMetadataChanges = false;
        double currentDouble = current.encode();
        UsageVersion version = UsageVersion.decode((double)metaObj.getUsageVersion());
        if (current.compareMajorMinor(version) > 0) {
            bMetadataChanges = true;
            metaObj.setUsageVersion(currentDouble);
        }
        return bMetadataChanges;
    }

    static {
        _repositoryIDForCachedEntityPropertyTypes = "";
        g_fmtParse = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss z", Locale.US);
    }
}

