/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical;

import com.sas.codepolicy.SASScopeExtension;
import com.sas.metadata.logical.BaseObjectFactory;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.RB;
import com.sas.metadata.logical.TypeInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.swing.visuals.CompoundIcon;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.Resources;
import java.rmi.RemoteException;
import javax.swing.Icon;

@SASScopeExtension(value="sas")
public abstract class Type
implements TypeInterface {
    protected final Factory _factory;
    private TypeDescriptorInterface _typeDescriptorInterface;
    private String _metadataType;
    private String _publicType;
    private String _displayType;
    private ObjectFactoryInterface _objectFactory;
    private Icon _defaultIcon;
    private Icon _newIcon;
    private Icon _updateIcon;
    private boolean _defaultIconSet;
    private boolean _newIconSet;
    private boolean _updateIconSet;
    private static boolean _overlayIconSet;
    private static Icon _updateOverlayIcon;

    protected Type(Factory factory, TypeDescriptorInterface typeDescriptorInterface) throws RemoteException, LogicalTypeException {
        if (factory == null) {
            throw new IllegalArgumentException("Logic error: factory is null.");
        }
        if (typeDescriptorInterface == null) {
            throw new IllegalArgumentException("Logic error: typeDescriptorInterface is null.");
        }
        this._factory = factory;
        this.init(typeDescriptorInterface);
    }

    private void init(TypeDescriptorInterface typeDescriptorInterface) throws RemoteException, LogicalTypeException {
        this._typeDescriptorInterface = typeDescriptorInterface;
        try {
            this._metadataType = this._typeDescriptorInterface.getMetadataType();
            this._publicType = this._typeDescriptorInterface.getTypeName();
            this._displayType = this._typeDescriptorInterface.getType();
        }
        catch (ServiceException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
    }

    protected void refresh(TypeDescriptorInterface typeDescriptorInterface) throws RemoteException, LogicalTypeException {
        this.init(typeDescriptorInterface);
        this._defaultIcon = null;
        this._newIcon = null;
        this._updateIcon = null;
        this._defaultIconSet = false;
        this._newIconSet = false;
        this._updateIconSet = false;
    }

    protected TypeDescriptorInterface getTypeDescriptorInterface() {
        return this._typeDescriptorInterface;
    }

    @Override
    public String getDisplayType() {
        return this._displayType;
    }

    @Override
    public Icon getIcon(int type) {
        switch (type) {
            case 1: {
                if (!this._defaultIconSet) {
                    this._defaultIconSet = true;
                    try {
                        this._defaultIcon = this._typeDescriptorInterface.getIcon();
                    }
                    catch (Exception e) {
                        this._factory.error(e, null);
                    }
                }
                return this._defaultIcon;
            }
            case 2: {
                if (!this._newIconSet) {
                    this._newIconSet = true;
                    Icon defIcon = this.getIcon(1);
                    if (defIcon != null) {
                        try {
                            this._newIcon = Util.getNewIcon((Icon)defIcon);
                        }
                        catch (Exception e) {
                            this._factory.error(e, null);
                        }
                    }
                }
                return this._newIcon;
            }
            case 3: {
                if (!this._updateIconSet) {
                    this._updateIconSet = true;
                    Icon defIcon = this.getIcon(1);
                    if (defIcon != null) {
                        try {
                            this._updateIcon = this.getUpdateIcon(defIcon);
                        }
                        catch (Exception e) {
                            this._factory.error(e, null);
                        }
                    }
                }
                return this._updateIcon;
            }
        }
        throw new IllegalArgumentException("Invalid value (" + type + ") specified for argument type.");
    }

    @Override
    public String getMetadataType() {
        return this._metadataType;
    }

    @Override
    public ObjectFactoryInterface getObjectFactory() {
        if (this._objectFactory == null) {
            this._objectFactory = this.createObjectFactory();
        }
        return this._objectFactory;
    }

    protected ObjectFactoryInterface createObjectFactory() {
        return new BaseObjectFactory(this);
    }

    protected void resetObjectFactory() {
        this._objectFactory = null;
    }

    @Override
    public String getPublicType() {
        return this._publicType;
    }

    private Icon getUpdateIcon(Icon typeIcon) {
        Icon[] icons = new Icon[2];
        icons[0] = this.getUpdateOverlayIcon();
        if (icons[0] == null) {
            return null;
        }
        icons[1] = typeIcon;
        int width = typeIcon.getIconWidth();
        CompoundIcon iconCompound = new CompoundIcon(icons);
        iconCompound.setIconGap(-width);
        iconCompound.setReverseOrder(true);
        return iconCompound;
    }

    private Icon getUpdateOverlayIcon() {
        if (!_overlayIconSet) {
            _overlayIconSet = true;
            try {
                _updateOverlayIcon = Resources.getImageIcon((String)RB.getStringResource("T.AttnOverlay.image"), (int)16);
            }
            catch (Exception e) {
                this._factory.error(e, null);
            }
        }
        return _updateOverlayIcon;
    }
}

