/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical;

import com.sas.metadata.logical.RB;
import com.sas.text.Message;
import com.sas.util.Encryption;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.io.File;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.security.auth.login.AppConfigurationEntry;

@Deprecated
public class SecurityContext {
    private String _host;
    private String _port;
    private String _user;
    private String _password;
    private String _domain;
    private WorkspaceFile _workspaceFile;
    private boolean _internalAccount = false;
    private String _securityPackage;
    private String _servicePrincipalName;
    private String _securityPackageList;

    public String getHost() {
        return this._host;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public String getPort() {
        return this._port;
    }

    public void setPort(String port) {
        this._port = port;
    }

    public String getUser() {
        return this._user;
    }

    public void setUser(String user) {
        this._user = user;
        this._internalAccount = this._user != null && this._user.toLowerCase().endsWith("@saspw");
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public String getDomain() {
        if (this._domain != null && this._domain.length() > 0) {
            return this._domain;
        }
        if (this._internalAccount) {
            return "InternalAuth";
        }
        return "DefaultAuth";
    }

    public void setDomain(String domain) {
        this._domain = domain;
    }

    public WorkspaceFile getWorkspaceFile() {
        return this._workspaceFile;
    }

    public void setConnectionProfile(String profile) {
        this._workspaceFile = SecurityContext.makeWorkspaceFile(profile);
        this._host = this._workspaceFile.getPropertyString("host");
        this._port = this._workspaceFile.getPropertyString("port");
        this._user = this._workspaceFile.getPropertyString("userid");
        if (this._user != null && this._user.length() == 0) {
            this._user = null;
        }
        this._password = Encryption.decrypt((String)this._workspaceFile.getPropertyString("password"));
        this._domain = this._workspaceFile.getPropertyString("authenticationdomain");
        this._internalAccount = this._workspaceFile.getPropertyBoolean("InternalAccount", false);
        this._securityPackage = this._workspaceFile.getPropertyString("SecurityPackage");
        if (this._securityPackage == null) {
            this._securityPackage = "Negotiate";
        }
        this._servicePrincipalName = this._workspaceFile.getPropertyString("ServicePrincipalName");
        if (this._servicePrincipalName == null) {
            this._servicePrincipalName = "";
        }
        this._securityPackageList = this._workspaceFile.getPropertyString("SecurityPackageList");
        if (this._securityPackageList == null) {
            this._securityPackageList = "Kerberos,NTLM";
        }
    }

    private static WorkspaceFile makeWorkspaceFile(String strFile) {
        File f;
        String fileSeparator;
        if (strFile == null) {
            return null;
        }
        String profileExtension = ".swa";
        if (!strFile.endsWith(".swa")) {
            strFile = strFile + ".swa";
        }
        if (strFile.lastIndexOf(fileSeparator = System.getProperty("file.separator")) > -1) {
            return new WorkspaceFile(strFile);
        }
        WorkspaceFile wksp = new WorkspaceFile();
        String fileName = Workspace.getMetadataProfilePath();
        if (!fileName.endsWith(fileSeparator)) {
            fileName = fileName + fileSeparator;
        }
        if ((f = new File(fileName = fileName + strFile)).exists()) {
            wksp.setFileName(fileName);
            wksp.openExisting(fileName);
            return wksp;
        }
        throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"BatchDriver.WorkspaceNotFound.fmt.txt", (Object)fileName));
    }

    public AppConfigurationEntry[] getAppConfigurationEntry() {
        HashMap<String, String> optionsMap = new HashMap<String, String>(7);
        optionsMap.put("host", this._host);
        optionsMap.put("port", this._port);
        optionsMap.put("domain", this.getDomain());
        optionsMap.put("holdopenconnection", "True");
        if (this._user == null || this._user.length() == 0) {
            optionsMap.put("idpropagation", "sspi");
            if (this._securityPackage != null) {
                if (this._securityPackage.equals("Negotiate")) {
                    if (this._securityPackageList != null && !this._securityPackageList.equals("Kerberos,NTLM")) {
                        optionsMap.put("sspisecuritypackagelist", this._securityPackageList);
                    }
                } else if (this._securityPackage != null && !this._securityPackage.equals("Negotiate")) {
                    optionsMap.put("sspisecuritypackagelist", this._securityPackage);
                }
            }
            if (this._servicePrincipalName != null && this._servicePrincipalName.length() > 0) {
                optionsMap.put("sspispn", this._servicePrincipalName);
            }
        }
        AppConfigurationEntry[] appConfigurationEntries = new AppConfigurationEntry[]{new AppConfigurationEntry("com.sas.services.security.login.OMILoginModule", AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, optionsMap)};
        return appConfigurationEntries;
    }
}

