/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.RootFolderLogicalObject;
import com.sas.metadata.logical.RootFolderType;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMetadataRemote;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.ConfigContentMappingPanel;
import com.sas.metadata.logical.visuals.ConfigGeneralPanel;
import com.sas.metadata.logical.visuals.FolderContentMappingTabPanel;
import com.sas.metadata.logical.visuals.GeneralPropertyTab;
import com.sas.metadata.logical.visuals.SmartWsDescriptionWizardTab;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;

public class RootFolderObjectFactory
implements ObjectFactoryInterface {
    RootFolderType _type;
    private Action[] EMPTY_ACTION_ARRAY = new Action[0];

    RootFolderObjectFactory(RootFolderType type) {
        this._type = type;
    }

    @Override
    public LogicalObjectInterface createItemFromMetadataObject(Root root) throws LogicalTypeException, RemoteException {
        if (!this.isMetadataObjectOfInterest(root)) {
            throw new IllegalArgumentException("Internal logic error: Not an object of interest " + root.toString() + " .");
        }
        RootFolderLogicalObject lo = new RootFolderLogicalObject((SoftwareComponent)root, (TypeInterface)this._type, this._type.getFactory());
        return lo;
    }

    public List getPropertyTabs(LogicalObjectInterface logicalObject, Root root, Config config) throws MdException, RemoteException {
        if (!this.isMetadataObjectOfInterest(root)) {
            throw new IllegalArgumentException("Internal logic error: Not an object of interest " + root.toString() + " .");
        }
        if (!(logicalObject instanceof RootFolderLogicalObject)) {
            throw new IllegalArgumentException("The object supplied should only be of type RootFolderLogicalObject and not " + logicalObject.toString() + " .");
        }
        if (config == null) {
            config = new Config();
        }
        config.setVisible(ConfigGeneralPanel.KEYWORDS, false);
        config.setVisible(ConfigGeneralPanel.CONTEXT, false);
        config.setVisible(ConfigGeneralPanel.RESPONSIBILITIES, false);
        OurCallback cb = new OurCallback(logicalObject, root);
        config.setCallback(ConfigContentMappingPanel.SAVE_SETTINGS_AND_CLOSE, cb);
        ArrayList<SmartWsDescriptionWizardTab> list = new ArrayList<SmartWsDescriptionWizardTab>();
        GeneralPropertyTab generalTab = new GeneralPropertyTab(root, 1, config);
        generalTab.setMetadataObjectDisplayType(logicalObject.getTypeInterface().getDisplayType());
        generalTab.setIconForType(logicalObject.getTypeInterface().getIcon(1));
        list.add(generalTab);
        list.add(new FolderContentMappingTabPanel((SoftwareComponent)root, 1, config));
        return list;
    }

    @Override
    public Factory getFactory() {
        return this._type.getFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllObjects(String reposID) throws MdException, RemoteException {
        ArrayList<LogicalObjectInterface> list = new ArrayList<LogicalObjectInterface>();
        MdObjectStore myStore = this._type.getFactory().getMdFactory().createObjectStore();
        try {
            SoftwareComponent sc = UtilMetadata.locateSoftwareComponent(UtilMetadata.getFoundationRepositoryID(), myStore);
            try {
                list.add(this.createItemFromMetadataObject((Root)sc));
            }
            catch (LogicalTypeException e) {
                throw new MdException((Throwable)e);
            }
        }
        finally {
            myStore.dispose();
        }
        return list;
    }

    @Override
    public Action[] getActions(LogicalObjectInterface logicalObject, Root root, Config config) {
        return this.EMPTY_ACTION_ARRAY;
    }

    @Override
    public Action[] getActions(LogicalObjectInterface[] logicalObjects, Root[] roots, Config config) {
        return this.EMPTY_ACTION_ARRAY;
    }

    private boolean isMetadataObjectOfInterest(Root root) throws RemoteException {
        SoftwareComponent sc = (SoftwareComponent)root;
        return sc.getPublicType().equalsIgnoreCase("RootFolder");
    }

    private class OurCallback
    extends Config.Callback {
        private Root _sc;
        private LogicalObjectInterface _rflo;

        OurCallback(LogicalObjectInterface lo, Root sc) {
            this._rflo = lo;
            this._sc = sc;
        }

        @Override
        public void callback(Object object) throws LogicalTypeException, RemoteException {
            this._rflo.refresh(this._sc);
            try {
                UtilMetadataRemote.flushBIPTree();
            }
            catch (Exception e) {
                RootFolderObjectFactory.this._type.getFactory().error(e, null);
                UtilGui.displayExceptionError(e);
            }
        }
    }
}

