/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.RB;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;

public final class FolderContentMappingModel {
    public static final int BACKING_NONE = 0;
    public static final int BACKING_FILE = 1;
    public static final int BACKING_DAV = 2;
    private Root _root;
    private MdObjectStore _objectStore;
    private SoftwareComponent _BIPService;
    private SoftwareComponent _RootBIPService;
    private Document _contentDocument;
    private TextStore _textStore;
    private int _backingType;
    private String _filePath;
    private String _davURL;
    private String _userId;
    private String _password;
    private String _nameToUseWhenSearchingForDocumentAndTextStoreObjects;
    private boolean _treeBased;
    private FolderContentMappingModel[] _modelsOfRootAndTopLevelFolders;
    private static boolean RUN_DEAD_CODE = false;

    public FolderContentMappingModel(Tree tree) throws RemoteException {
        this._root = tree;
        this._nameToUseWhenSearchingForDocumentAndTextStoreObjects = tree.getName();
        this._objectStore = (MdObjectStore)tree.getObjectStore();
        this._treeBased = true;
    }

    public FolderContentMappingModel(SoftwareComponent softwareComponent) throws RemoteException {
        this._root = softwareComponent;
        this._nameToUseWhenSearchingForDocumentAndTextStoreObjects = "Report Repository Content Mapping";
        this._objectStore = (MdObjectStore)softwareComponent.getObjectStore();
        this._treeBased = false;
    }

    public void setUserId(String userId) {
        this._userId = userId.trim();
    }

    public String getUserId() {
        return this._userId;
    }

    public void setPassword(String password) {
        this._password = password.trim();
    }

    public String getPassword() {
        return this._password;
    }

    public Root getMetadataObject() {
        return this._root;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadMetadata() throws MdException, RemoteException {
        String storedText;
        boolean davtype;
        this.getContentProviderDocument();
        if (this._contentDocument == null) {
            this._backingType = 0;
            return;
        }
        String uriType = this._contentDocument.getURIType();
        String uri = this._contentDocument.getURI();
        if (uriType.length() > 0) {
            if (uriType.equalsIgnoreCase("DAV")) {
                davtype = true;
            } else {
                if (!uriType.equalsIgnoreCase("File")) {
                    String text = Message.format((ResourceBundle)RB.getResources(), (String)"FCMM.BadURIType.ex.msg.fmt.txt", (Object)this._root.getName(), (Object)uriType);
                    throw new MdException(text);
                }
                davtype = false;
            }
        } else {
            davtype = FolderContentMappingModel.isValidDAVPath(uri);
        }
        if (!davtype) {
            this._backingType = 1;
            this._filePath = uri;
            return;
        }
        this._backingType = 2;
        this._davURL = uri;
        this._userId = "";
        this._password = "";
        this._textStore = this.getAuthTextStore(this._contentDocument);
        if (this._textStore == null) return;
        String storedTextEncoded = this._textStore.getStoredText();
        if (storedTextEncoded.length() == 0) {
            return;
        }
        try {
            storedText = SasPasswordString.isEncoded((String)storedTextEncoded) ? SasPasswordString.decode((String)storedTextEncoded) : this._textStore.getObjectStore().getFactory().getUtil().safeDecrypt(storedTextEncoded);
        }
        catch (SasPasswordEncodingException e) {
            String text = Message.format((ResourceBundle)RB.getResources(), (String)"FCMM.BadCred.ex.msg.fmt.txt", (Object)this._nameToUseWhenSearchingForDocumentAndTextStoreObjects, (Object)e.getMessage());
            throw new MdException(text);
        }
        int length = storedText.length();
        if (length == 0) {
            return;
        }
        int delimiterPos = storedText.indexOf(10);
        if (delimiterPos == -1) {
            this._userId = storedText;
            return;
        }
        if (delimiterPos == 0) {
            if (length <= 1) return;
            this._password = storedText.substring(1);
            return;
        }
        this._userId = storedText.substring(0, delimiterPos);
        if (delimiterPos >= length - 1) return;
        this._password = storedText.substring(delimiterPos + 1);
    }

    public void updateJomaObjects() throws MdException, RemoteException {
        String storedTextEncoded;
        if (this._treeBased) {
            this._nameToUseWhenSearchingForDocumentAndTextStoreObjects = this._root.getName();
        }
        if (this._backingType == 0) {
            if (this._contentDocument != null) {
                if (this._textStore != null) {
                    this._textStore.delete();
                }
                this._contentDocument.delete();
                this._contentDocument = null;
            }
            return;
        }
        if (this._treeBased) {
            if (this._contentDocument == null) {
                this._contentDocument = (Document)UtilMetadata.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)this._root, this._root.getName(), "Document");
                this._contentDocument.getObjects().add((Object)this._root);
            } else {
                this._contentDocument.setName(this._root.getName());
            }
        } else if (this._contentDocument == null) {
            this._contentDocument = (Document)UtilMetadata.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)this._root, this._nameToUseWhenSearchingForDocumentAndTextStoreObjects, "Document");
            this._contentDocument.getObjects().add((Object)this._root);
        }
        this._contentDocument.setTextRole("ReportRepositoryContentMapping");
        if (this._backingType == 1) {
            this._contentDocument.setURI(this._filePath);
            this._contentDocument.setURIType("File");
            if (this._textStore != null) {
                this._textStore.delete();
            }
            return;
        }
        this._contentDocument.setURI(this._davURL);
        this._contentDocument.setURIType("DAV");
        if (this._userId.length() == 0) {
            if (this._textStore != null) {
                this._textStore.delete();
            }
            return;
        }
        if (this._textStore == null) {
            this._textStore = (TextStore)UtilMetadata.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)this._contentDocument, this._contentDocument.getName(), "TextStore");
            this._textStore.setTextType("PlainText");
        } else {
            this._textStore.setName(this._contentDocument.getName());
        }
        String storedText = this._password.length() > 0 ? this._userId + "\n" + this._password : this._userId;
        try {
            storedTextEncoded = SasPasswordString.encode((String)"sas002", (String)storedText);
        }
        catch (SasPasswordEncodingException e) {
            throw new MdException((Throwable)e);
        }
        this._textStore.setStoredText(storedTextEncoded);
        AssociationList noteList = this._contentDocument.getNotes();
        noteList.clear();
        noteList.add(this._textStore);
    }

    private TextStore getAuthTextStore(Document doc) throws MdException, RemoteException {
        String nameToMatch = doc.getName();
        for (TextStore textStore : doc.getNotes()) {
            String tsName = textStore.getName();
            if (!nameToMatch.equals(tsName)) continue;
            return textStore;
        }
        return null;
    }

    private static boolean isValidDAVPath(String davURL) {
        return (davURL = davURL.toLowerCase()).startsWith("http:") || davURL.startsWith("https:");
    }

    private SoftwareComponent getBipService() throws MdException, RemoteException {
        if (this._BIPService == null) {
            if (this._treeBased) {
                String reposId = UtilMetadata.makeRepositoryFQIDFromRoot(this._root);
                this._BIPService = UtilMetadata.locateSoftwareComponent(reposId, this._objectStore);
            } else {
                this._BIPService = (SoftwareComponent)this._root;
            }
        }
        return this._BIPService;
    }

    private SoftwareComponent getRootBipService() throws MdException, RemoteException {
        if (this._RootBIPService == null) {
            String reposId = UtilMetadata.getFoundationRepositoryID();
            this._RootBIPService = UtilMetadata.locateSoftwareComponent(reposId, this._objectStore);
        }
        return this._RootBIPService;
    }

    private void getContentProviderDocument() throws MdException, RemoteException {
        if (this._treeBased) {
            this._contentDocument = this.getContentProviderDocument(ContentStorageMode.CHILD);
            if (this._contentDocument == null) {
                this._contentDocument = this.getContentProviderDocument(ContentStorageMode.SIBLING);
            }
        } else {
            this._contentDocument = this.getContentProviderDocument(ContentStorageMode.BIPSERVICE);
        }
    }

    private Document getContentProviderDocument(ContentStorageMode mode) throws MdException, RemoteException {
        AssociationList docList;
        if (mode == ContentStorageMode.SIBLING) {
            SoftwareComponent bipService = this.getBipService();
            docList = bipService.getDocuments();
        } else {
            docList = this._root.getDocuments(true);
        }
        String nameToMatch = this._nameToUseWhenSearchingForDocumentAndTextStoreObjects;
        for (Document doc : docList) {
            if (!doc.getName().equals(nameToMatch)) continue;
            return doc;
        }
        return null;
    }

    void deleteContentMappingIfPresent() throws MdException, RemoteException {
        if (this._contentDocument != null) {
            TextStore ts = this.getAuthTextStore(this._contentDocument);
            if (ts != null) {
                ts.delete();
            }
            this._contentDocument.delete();
            this._contentDocument = null;
        }
    }

    public String getDavURL() {
        return this._davURL;
    }

    public void setDavURL(String davURL) {
        this._davURL = davURL;
    }

    public String getFilePath() {
        return this._filePath;
    }

    public void setFilePath(String filePath) {
        this._filePath = filePath;
    }

    public int getBackingType() {
        return this._backingType;
    }

    public void setBackingType(int backingType) {
        this._backingType = backingType;
    }

    public boolean isServerRoot() {
        return !this._treeBased;
    }

    public FolderContentMappingModel[] getRootAndTopLevelModels() throws ServiceException, RemoteException, MdException {
        if (this._modelsOfRootAndTopLevelFolders == null) {
            MetadataServerInterface msi = Factory.getInstance().getMetadataServerInterface();
            RootFolderInterface rfi = msi.getRootFolder();
            if (rfi == null) {
                throw new MdException("Couldn't get FolderInterface from MetadataServerInterface's getRootFolder.");
            }
            List folders = rfi.getSubfolders();
            int numberOfFolders = folders.size();
            this._modelsOfRootAndTopLevelFolders = new FolderContentMappingModel[numberOfFolders + 1];
            this._modelsOfRootAndTopLevelFolders[0] = new FolderContentMappingModel((SoftwareComponent)rfi.getRepositoryEntity());
            this._modelsOfRootAndTopLevelFolders[0].loadMetadata();
            for (int i = 1; i <= numberOfFolders; ++i) {
                Tree tree = (Tree)((FolderInterface)folders.get(i - 1)).getRepositoryEntity();
                this._modelsOfRootAndTopLevelFolders[i] = new FolderContentMappingModel(tree);
                this._modelsOfRootAndTopLevelFolders[i].loadMetadata();
            }
        }
        return this._modelsOfRootAndTopLevelFolders;
    }

    public static boolean isContentMapped(Tree tree) throws MdException, RemoteException {
        FolderContentMappingModel fcmm = new FolderContentMappingModel(tree);
        fcmm.loadMetadata();
        if (fcmm.getBackingType() != 0) {
            return true;
        }
        SoftwareComponent bipService = fcmm.getRootBipService();
        FolderContentMappingModel fcmmSC = new FolderContentMappingModel(bipService);
        fcmmSC.loadMetadata();
        return fcmmSC.getBackingType() != 0;
    }

    static {
        if (RUN_DEAD_CODE) {
            new ContentStorageMode(null);
        }
    }

    static class ContentStorageMode {
        public static final ContentStorageMode SIBLING = new ContentStorageMode("SIBLING (old)");
        public static final ContentStorageMode CHILD = new ContentStorageMode("CHILD (new)");
        public static final ContentStorageMode BIPSERVICE = new ContentStorageMode("BIPSERVICE");
        private String myValue;

        private ContentStorageMode(String value) {
            this.myValue = value;
        }

        public String toString() {
            return this.myValue;
        }
    }
}

