/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical;

import com.sas.metadata.logical.BaseLogicalObject;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.visuals.BIPTreeElementGeneralPropertyTab;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.ConfigGeneralPanel;
import com.sas.metadata.logical.visuals.GeneralPropertyTab;
import com.sas.metadata.logical.visuals.NonFolderMemberGeneralPropertyTab;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.workspace.WAPropertyTab;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;

public class BaseObjectFactory
implements ObjectFactoryInterface {
    protected static final Action[] EMPTY_ACTION_ARRAY = new Action[0];
    protected TypeInterface _type;
    protected Factory _factory;

    public BaseObjectFactory(TypeInterface type) {
        this(type, Factory.getInstance());
    }

    public BaseObjectFactory(TypeInterface type, Factory factory) {
        this._type = type;
        this._factory = factory;
    }

    @Override
    public LogicalObjectInterface createItemFromMetadataObject(Root root) throws RemoteException {
        return new BaseLogicalObject(root, this._type, this._factory);
    }

    @Override
    public Action[] getActions(LogicalObjectInterface logicalObject, Root root, Config config) throws RemoteException {
        return EMPTY_ACTION_ARRAY;
    }

    @Override
    public Action[] getActions(LogicalObjectInterface[] logicalObjects, Root[] roots, Config config) throws RemoteException {
        return EMPTY_ACTION_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends LogicalObjectInterface> getAllObjects(String reposID) throws MdException, RemoteException {
        if (reposID == null) {
            return new ArrayList();
        }
        String options = "<XMLSelect search=\"*[@PublicType='" + this._type.getPublicType() + "']\"/>";
        ArrayList<LogicalObjectInterface> list = new ArrayList<LogicalObjectInterface>();
        MdObjectStore myStore = this.getFactory().getMdFactory().createObjectStore();
        try {
            MdOMIUtil omiUtil = this.getFactory().getOMIUtil();
            List objects = omiUtil.getMetadataObjectsSubset((MdStore)myStore, reposID, this._type.getMetadataType(), 388, options);
            for (Root root : objects) {
                list.add(this.createItemFromMetadataObject(root));
            }
        }
        finally {
            myStore.dispose();
        }
        return list;
    }

    @Override
    public Factory getFactory() {
        return this._factory;
    }

    @Override
    public List<? extends WAPropertyTab> getPropertyTabs(LogicalObjectInterface logicalObject, Root root, Config config) throws MdException, RemoteException {
        GeneralPropertyTab propertyTab;
        if (!this.isObjectOfInterest(root)) {
            throw new IllegalArgumentException("Unable to display properties.  Reason: Not a public object type or invalid public object type.");
        }
        ArrayList<BIPTreeElementGeneralPropertyTab> list = new ArrayList<BIPTreeElementGeneralPropertyTab>(1);
        if (config == null) {
            config = new Config();
        }
        try {
            String publicType = logicalObject.getTypeInterface().getPublicType();
            propertyTab = this._factory.isTypeContainedByFolder(publicType) ? this.getGeneralPropertyTab(root, config) : this.getNonFolderMemberGeneralPropertyTab(root, config);
        }
        catch (ServiceException e) {
            throw new MdException((Throwable)e);
        }
        catch (LogicalTypeException e) {
            throw new MdException((Throwable)e);
        }
        list.add((BIPTreeElementGeneralPropertyTab)propertyTab);
        return list;
    }

    protected BIPTreeElementGeneralPropertyTab getGeneralPropertyTab(Root root, Config config) throws MdException, RemoteException {
        AssociationList al = root.getTrees();
        Tree tree = al.size() > 0 ? (Tree)al.get(0) : null;
        BIPTreeElementGeneralPropertyTab generalTab = new BIPTreeElementGeneralPropertyTab(root, tree, 1, this._type, config);
        return generalTab;
    }

    protected NonFolderMemberGeneralPropertyTab getNonFolderMemberGeneralPropertyTab(Root root, Config config) throws MdException, RemoteException, ServiceException {
        config.setEnabled(ConfigGeneralPanel.NAME, false);
        if (SASFoldersUtil.isContainedByVirtualFolder((String)this._type.getPublicType(), (ServerInterface)this._factory.getMetadataServerInterface())) {
            config.setVisible(ConfigGeneralPanel.CONTEXT, true);
        } else {
            config.setVisible(ConfigGeneralPanel.CONTEXT, false);
        }
        NonFolderMemberGeneralPropertyTab generalTab = new NonFolderMemberGeneralPropertyTab(root, 1, this._type, config);
        return generalTab;
    }

    protected boolean isObjectOfInterest(Root root) throws RemoteException {
        if (!(root instanceof PrimaryType)) {
            return false;
        }
        PrimaryType pt = (PrimaryType)root;
        return pt.getPublicType().equalsIgnoreCase(this._type.getPublicType());
    }
}

