/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.MemberInterface;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.RB;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.ProjectUtil;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class BaseLogicalObject
extends LogicalObject
implements MemberInterface {
    protected Root _root;

    public BaseLogicalObject(Root root, TypeInterface ti, Factory factory) throws RemoteException {
        super(root, ti, factory);
        this._root = root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(OperationUserInteractionInterface deleteInterface) throws LogicalTypeException, RemoteException {
        if (!this.isDeleteAllowed()) {
            throw new UnsupportedOperationException("Logic error - this object does not support deleting.");
        }
        String progressText = this.getProgressMessageForDelete();
        deleteInterface.updateProgress(progressText);
        MdObjectStore store = null;
        Root metadataObject = null;
        try {
            MdFactory metadataFactory = this.getFactory().getMdFactory();
            store = Workspace.getMdFactory().createObjectStore(null, "BaseLogicalObject:delete:" + this.getID());
            metadataObject = (Root)store.getFactory().createComplexMetadataObject(store, this.getName(), this.getTypeInterface().getMetadataType(), this.getID());
            metadataFactory.deleteMetadataObject((CMetadata)metadataObject);
            boolean bl = true;
            return bl;
        }
        catch (MdException e) {
            if (deleteInterface.continueOperationWithPrompting()) {
                String folderName = "";
                try {
                    BrowseMetadataInterface browse = this.getBrowseObject();
                    folderName = this.getFolderLocation(browse);
                }
                catch (Exception browse) {
                    // empty catch block
                }
                String messageText = null;
                messageText = folderName.length() == 0 ? UtilMisc.getMessage(RB.getStringResource("COM.DelExcpOccrdNoFolder.fmt.txt"), this._ti.getDisplayType(), this.getName(), UtilMisc.getExceptionMessageText((Exception)((Object)e))) : UtilMisc.getMessage(RB.getStringResource("COM.DelExcpOccrd.fmt.txt"), this._ti.getDisplayType(), this.getName(), folderName, UtilMisc.getExceptionMessageText((Exception)((Object)e)));
                int choice = deleteInterface.displayMessage(RB.getStringResource("COM.DelDlgTitle.txt"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting(deleteInterface, choice);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (store != null) {
                store.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(String sName, OperationUserInteractionInterface opUI) throws LogicalTypeException {
        if (!this.isRenameAllowed()) {
            throw new UnsupportedOperationException("Logic error - this object does not support renaming");
        }
        if (sName.equals(this.getName())) {
            return;
        }
        boolean duplicateCheckNeeded = !sName.equalsIgnoreCase(this.getName());
        try {
            if (duplicateCheckNeeded) {
                ChildServerInterface childServer = UtilPlatformServices.getUserContext().getAuthServer().newChild(true);
                try {
                    FolderInterface parentFolder;
                    String infoSvcsKey = this.getID() + "/" + this.getTypeInterface().getMetadataType();
                    MetadataInterface mi = childServer.fetch(infoSvcsKey, true);
                    List parents = mi.getParents();
                    if (parents != null && parents.size() == 1 && (parentFolder = (FolderInterface)parents.get(0)) != null && parentFolder.hasDuplicate(sName, this.getTypeInterface().getPublicType())) {
                        LogicalTypeException loe = new LogicalTypeException(UtilMisc.getMessage(RB.getStringResource("BLO.DuplicateObjectFound.fmt.txt"), this.getTypeInterface().getDisplayType(), sName));
                        throw loe;
                    }
                }
                finally {
                    childServer.rollback();
                    childServer = null;
                }
            }
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "BaseLogicalObject:rename:" + this.getID());
            try {
                Root metadataObject = (Root)store.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, this.getTypeInterface().getMetadataType(), this.getID(), null, null, "", 8);
                metadataObject.setName(sName);
                metadataObject.updateMetadataAll();
                this.refresh(metadataObject);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Writing");
            }
            finally {
                store.dispose();
            }
        }
        catch (ServiceException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    @Override
    public boolean checkOut(Root projectRepository, OperationUserInteractionInterface oui) throws LogicalTypeException {
        try {
            if (!this.ischeckOutAllowed()) {
                throw new UnsupportedOperationException("Logic error - this object does not support check-out");
            }
            ArrayList<CMetadata> objects = new ArrayList<CMetadata>(1);
            objects.add(this._factory.getMdFactory().createSimpleMetadataObject(this.getName(), this._ti.getMetadataType(), this._fqid));
            try {
                if (oui != null) {
                    oui.updateProgress(UtilMisc.getMessage(RB.getStringResource("COM.UpdProgCheckOut.fmt.txt"), this.getName()));
                }
                ProjectUtil.checkOut(objects, (CMetadata)projectRepository);
                return true;
            }
            catch (MdException ex) {
                throw new LogicalTypeException((Exception)((Object)ex));
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
    }

    protected String getFolderLocation(BrowseMetadataInterface browseObject) {
        BrowseMetadataInterface parentFolder = null;
        List parents = browseObject.getParents();
        int pathSeparator = 47;
        if (parents == null || parents.size() <= 0) {
            if (browseObject.isAFolder()) {
                return "/";
            }
            return "";
        }
        parentFolder = (BrowseMetadataInterface)parents.get(0);
        StringBuffer path = new StringBuffer();
        while (parentFolder != null) {
            path.insert(0, '/' + parentFolder.getName());
            List parentList = parentFolder.getParents();
            if (parentList != null && parentList.size() > 0) {
                parentFolder = (BrowseMetadataInterface)parentList.get(0);
                continue;
            }
            parentFolder = null;
        }
        return path.toString();
    }

    protected BrowseMetadataInterface getBrowseObject() throws MdException, RemoteException {
        BrowseMetadataInterface returnValue = null;
        StringBuffer sbTemplate = new StringBuffer();
        sbTemplate.append("<Templates>");
        ArrayList<String> associations = new ArrayList<String>();
        associations.add("Trees");
        String objectXML = Workspace.getWorkspace().getMdObjectFactory().getOMIUtil().createGetXMLString(this._ti.getMetadataType(), this.getID(), null, associations);
        sbTemplate.append(objectXML);
        sbTemplate.append("<Tree Name=\"\"><ParentTree/><SoftwareComponents/></Tree>");
        sbTemplate.append("</Templates>");
        String template = sbTemplate.toString();
        int mdFlags = -2080350180;
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            Filter filter = new Filter();
            filter.setExplicitSearchString("", objectXML);
            filter.setOMRTemplate(template);
            filter.setOMRFlags(mdFlags);
            String sKey = this.getID() + "/" + this._ti.getMetadataType();
            returnValue = server.browseFetch(sKey, (FilterInterface)filter);
        }
        catch (ServiceException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        return returnValue;
    }
}

