/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.deployjni.winregistry;

import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.Utilities;
import com.sas.tools.deployjni.winregistry.WinRegAPIDef;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WinRegAPI {
    public static final int HKEY_CLASSES_ROOT = 1;
    public static final int HKEY_CURRENT_CONFIG = 2;
    public static final int HKEY_CURRENT_USER = 4;
    public static final int HKEY_LOCAL_MACHINE = 8;
    public static final int HKEY_USERS = 16;
    public static final int REG_BINARY = 100;
    public static final int REG_DWORD = 101;
    public static final int REG_DWORD_LITTLE_ENDIAN = 102;
    public static final int REG_DWORD_BIG_ENDIAN = 103;
    public static final int REG_EXPAND_SZ = 104;
    public static final int REG_LINK = 105;
    public static final int REG_MULTI_SZ = 106;
    public static final int REG_NONE = 107;
    public static final int REG_RESOURCE_LIST = 108;
    public static final int REG_SZ = 109;
    public static final String ROOT_ID = "registry";
    protected static final DocumentBuilder builder;
    protected static Logger log;
    public static HashMap<String, String> libNames;

    public static String getWinRegValue32(int key, String subKey, String valueName) {
        String sValue = "";
        if (Utilities.getOS() == 1) {
            sValue = WinRegAPIDef.RegQueryValue32(key, subKey, valueName);
        }
        return sValue;
    }

    public static int getWinRegDwordValue(int key, String subKey, String valueName) {
        int value = 0;
        if (Utilities.getOS() == 1) {
            value = WinRegAPIDef.RegQueryDwordValue(key, subKey, valueName);
        }
        return value;
    }

    public static int getWinRegDwordValue32(int key, String subKey, String valueName) {
        int value = 0;
        if (Utilities.getOS() == 1) {
            value = WinRegAPIDef.RegQueryDwordValue32(key, subKey, valueName);
        }
        return value;
    }

    public static String getWinRegMultiStrValue(String suffix, int key, String subKey, String valueName) {
        String value = null;
        if (suffix == "win") {
            value = WinRegAPIDef.RegQueryMultiValue(key, subKey, valueName, false);
        } else if (suffix == "wx6" || suffix == "w64") {
            value = WinRegAPIDef.RegQueryMultiValue(key, subKey, valueName, true);
        }
        return value;
    }

    public static String getWinRegValueWow64(int key, String subKey, String valueName) {
        String sValue = "";
        if (Utilities.getOS() == 1) {
            sValue = WinRegAPIDef.RegQueryValueExWow64(key, subKey, valueName);
        }
        return sValue;
    }

    public static String getWindowsRegistryValue(int key, String subKey, String valueName) {
        String sValue = "";
        if (Utilities.getOS() == 1) {
            sValue = WinRegAPIDef.RegQueryValueEx(key, subKey, valueName);
        }
        return sValue;
    }

    public static boolean isWindowsRegistryKey32(int key, String subKey) {
        if (Utilities.getOS() == 1) {
            boolean retval = WinRegAPIDef.RegKeyExists32(key, subKey);
            return retval;
        }
        return false;
    }

    public static boolean isWindowsRegistryKey64(int key, String subKey) {
        if (Utilities.getOS() == 1) {
            boolean retval = WinRegAPIDef.RegKeyExists64(key, subKey);
            return retval;
        }
        return false;
    }

    public static boolean SetRegValue(int key, String subKey, String valueName, String value, int type) throws Exception {
        if (subKey == null || valueName == null || value == null) {
            throw new Exception("Parameters to SetRegValue must not be null");
        }
        if (Utilities.getOS() == 1) {
            boolean retval = WinRegAPIDef.SetRegValue(key, subKey, valueName, value, type);
            return retval;
        }
        return false;
    }

    public static long getWinRegType32(int key, String subKey, String valueName) {
        if (Utilities.getOS() == 1) {
            long retval = WinRegAPIDef.RegQueryType32(key, subKey, valueName);
            return retval;
        }
        return 0L;
    }

    public static long getWinRegType64(int key, String subKey, String valueName) {
        if (Utilities.getOS() == 1) {
            long retval = WinRegAPIDef.RegQueryType64(key, subKey, valueName);
            return retval;
        }
        return 0L;
    }

    public static boolean SetRegValueWow64(int key, String subKey, String valueName, String value, int type) throws Exception {
        if (subKey == null || valueName == null || value == null) {
            throw new Exception("Parameters to SetRegValue must not be null");
        }
        if (Utilities.getOS() == 1) {
            boolean retval = WinRegAPIDef.SetRegValueWow64(key, subKey, valueName, value, type);
            return retval;
        }
        return false;
    }

    public static boolean SetRegValue32(int key, String subKey, String valueName, String value, int type) throws Exception {
        if (subKey == null || valueName == null || value == null) {
            throw new Exception("Parameters to SetRegValue must not be null");
        }
        if (Utilities.getOS() == 1) {
            boolean retval = WinRegAPIDef.SetRegValue32(key, subKey, valueName, value, type);
            return retval;
        }
        return false;
    }

    public static boolean SetRegDwordValue(int key, String subKey, String valueName, int value, int type) throws Exception {
        if (subKey == null || valueName == null) {
            throw new Exception("Parameters to SetRegValue must not be null");
        }
        if (Utilities.getOS() == 1) {
            return WinRegAPIDef.SetRegDwordValue(key, subKey, valueName, value, type);
        }
        return false;
    }

    public static boolean SetRegDwordValue32(int key, String subKey, String valueName, int value, int type) throws Exception {
        if (subKey == null || valueName == null) {
            throw new Exception("Parameters to SetRegValue must not be null");
        }
        if (Utilities.getOS() == 1) {
            return WinRegAPIDef.SetRegDwordValue32(key, subKey, valueName, value, type);
        }
        return false;
    }

    public static boolean DelRegKeyValue(int key, String subKey, String valueName) {
        if (Utilities.getOS() == 1) {
            boolean retval = WinRegAPIDef.DelRegkeyValue(key, subKey, valueName, false);
            return retval;
        }
        return false;
    }

    public static boolean DelRegKeyValue(int key, String subKey, String valueName, boolean check64) {
        boolean retval = false;
        if (Utilities.getOS() == 1) {
            retval = check64 ? WinRegAPI.DelRegKeyValue64(key, subKey, valueName) : WinRegAPI.DelRegKeyValue(key, subKey, valueName);
        }
        return retval;
    }

    public static boolean DelRegKeyValue64(int key, String subKey, String valueName) {
        if (Utilities.getOS() == 1) {
            boolean retval = WinRegAPIDef.DelRegkeyValue(key, subKey, valueName, true);
            return retval;
        }
        return false;
    }

    public static Document exportKey32(int key, String subKey) throws Exception {
        if (Utilities.getOS() == 1) {
            return WinRegAPI.exportKey(key, subKey, false);
        }
        return null;
    }

    public static Document exportKey64(int key, String subKey) throws Exception {
        if (Utilities.getOS() == 1) {
            return WinRegAPI.exportKey(key, subKey, true);
        }
        return null;
    }

    public static String[] childrenForKey(int key, String subKey, boolean check64) {
        String[] children = null;
        if (Utilities.getOS() == 1) {
            children = check64 ? WinRegAPIDef.childrenForKey64(key, subKey) : WinRegAPIDef.childrenForKey32(key, subKey);
        }
        return children;
    }

    public static String[] childrenForKey32(int key, String subKey) {
        if (Utilities.getOS() == 1) {
            return WinRegAPIDef.childrenForKey32(key, subKey);
        }
        return null;
    }

    public static String[] childrenForKey64(int key, String subKey) {
        if (Utilities.getOS() == 1) {
            return WinRegAPIDef.childrenForKey64(key, subKey);
        }
        return null;
    }

    public static Document exportKey(int key, String subKey, boolean is64Bit) throws Exception {
        if (Utilities.getOS() == 1) {
            Document doc = builder.newDocument();
            Element root = doc.createElement(ROOT_ID);
            doc.appendChild(root);
            WinRegAPI.backupChildren(doc, root, key, subKey, is64Bit);
            return doc;
        }
        return null;
    }

    public static void backupChildren(Document doc, Element root, int key, String subKey, boolean is64Bit) {
        if (Utilities.getOS() != 1) {
            return;
        }
        String[] values = is64Bit ? WinRegAPIDef.valuesForKey64(key, subKey) : WinRegAPIDef.valuesForKey32(key, subKey);
        for (int i = values.length - 1; i >= 0; --i) {
            String value;
            String name = values[i];
            Element entry = doc.createElement("entry");
            entry.setAttribute("name", name);
            if (is64Bit) {
                entry.setAttribute("type", String.valueOf(WinRegAPIDef.RegQueryType64(key, subKey, name)));
                value = WinRegAPIDef.RegQueryValueEx(key, subKey, name);
                entry.setAttribute("value", value);
            } else {
                entry.setAttribute("type", String.valueOf(WinRegAPIDef.RegQueryType32(key, subKey, name)));
                value = WinRegAPIDef.RegQueryValue32(key, subKey, name);
                entry.setAttribute("value", value);
            }
            root.appendChild(entry);
        }
        String[] children = is64Bit ? WinRegAPIDef.childrenForKey64(key, subKey) : WinRegAPIDef.childrenForKey32(key, subKey);
        for (int i = children.length - 1; i >= 0; --i) {
            String name = children[i];
            Element childNode = doc.createElement("subkey");
            root.appendChild(childNode);
            childNode.setAttribute("name", name);
            WinRegAPI.backupChildren(doc, childNode, key, subKey + "\\" + name, is64Bit);
        }
    }

    public static boolean DelRegKeyWow6432(int key, String subKey) {
        if (Utilities.getOS() == 1) {
            boolean retval = false;
            retval = JNIUtils.getJniLibKey() == "win" ? WinRegAPIDef.DelRegKey32BitOS(key, subKey) : WinRegAPIDef.DelRegKeyWOW32Bit(key, subKey);
            return retval;
        }
        return false;
    }

    public static boolean DelRegKey(int key, String subKey) {
        if (Utilities.getOS() == 1) {
            boolean retval = false;
            retval = JNIUtils.getWindowsPlatform() == "win" ? WinRegAPIDef.DelRegKey32BitOS(key, subKey) : WinRegAPIDef.DelRegKeyWOW64Bit(key, subKey);
            return retval;
        }
        return false;
    }

    public static boolean DelRegKey(int key, String subKey, boolean check64) {
        if (Utilities.getOS() == 1) {
            boolean retval = false;
            retval = !check64 ? WinRegAPIDef.DelRegKey32BitOS(key, subKey) : WinRegAPIDef.DelRegKeyWOW64Bit(key, subKey);
            return retval;
        }
        return false;
    }

    public static boolean DelRegTree(int key, String subKey) {
        if (Utilities.getOS() == 1) {
            boolean retval = WinRegAPIDef.DelRegTree(key, subKey);
            return retval;
        }
        return false;
    }

    public static boolean DelRegTree(int key, String subKey, boolean check64) {
        boolean retval = false;
        if (Utilities.getOS() == 1) {
            int i;
            String[] children = null;
            children = WinRegAPI.valuesForKey(key, subKey, check64);
            for (i = 0; children != null && i < children.length; ++i) {
                retval = WinRegAPI.DelRegKeyValue(key, subKey, children[i], check64);
            }
            children = WinRegAPI.childrenForKey(key, subKey, check64);
            for (i = 0; children != null && i < children.length; ++i) {
                retval = WinRegAPI.DelRegTree(key, subKey + "\\" + children[i], check64);
            }
            WinRegAPI.DelRegKey(key, subKey, check64);
        }
        return retval;
    }

    public static String[] valuesForKey(int key, String subKey, boolean check64) {
        String[] children = null;
        if (Utilities.getOS() == 1) {
            children = check64 ? WinRegAPIDef.valuesForKey64(key, subKey) : WinRegAPIDef.valuesForKey32(key, subKey);
        }
        return children;
    }

    public static boolean CreateRegKey(int key, String subKey) {
        if (Utilities.getOS() == 1) {
            boolean retval = WinRegAPIDef.CreateRegKey(key, subKey);
            return retval;
        }
        return false;
    }

    public static boolean CreateRegKeyWow64(int key, String subKey) {
        if (Utilities.getOS() == 1) {
            boolean retval = WinRegAPIDef.CreateRegKeyWow64(key, subKey);
            return retval;
        }
        return false;
    }

    public static boolean CreateRegKey32(int key, String subKey) {
        if (Utilities.getOS() == 1) {
            boolean retval = WinRegAPIDef.CreateRegKey32(key, subKey);
            return retval;
        }
        return false;
    }

    static {
        log = (Logger)LogManager.getLogger(WinRegAPI.class);
        libNames = new HashMap();
        libNames.put("win", "libWinRegW32.dll");
        libNames.put("w64", "libWinRegW64.dll");
        libNames.put("wx6", "libWinRegWX6.dll");
        DocumentBuilder tempBuilder = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setCoalescing(true);
            try {
                tempBuilder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                ex.printStackTrace();
                tempBuilder = null;
            }
        }
        finally {
            builder = tempBuilder;
        }
    }
}

