/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.deployjni.shortcut;

import com.sas.tools.deployjni.SSNResource;

public class ShortcutException
extends Exception {
    private static SSNResource resources = new SSNResource(ShortcutException.class);
    public static final int parameterError = 1;
    public static final int failedSystemApi = 2;
    public static final int shortcutDoesntExist = 3;
    public static final int comInitFailed = 4;
    public static final int shellLinkFailed = 5;
    public static final int queryInterfaceFailed = 6;
    public static final int cannotSaveLink = 7;
    private int errorType;
    private String string1;
    private String string2;
    private int errCode;

    public ShortcutException(int errorType, String p1) {
        this.errorType = errorType;
        this.string1 = p1;
        this.string2 = null;
        this.errCode = 0;
    }

    public ShortcutException(int errorType, String p1, int errCode) {
        this.errorType = errorType;
        this.string1 = p1;
        this.string2 = null;
        this.errCode = errCode;
    }

    public ShortcutException(int errorType, String p1, String p2, int errCode) {
        this.errorType = errorType;
        this.string1 = p1;
        this.string2 = p2;
        this.errCode = errCode;
    }

    public ShortcutException(int errorType, String p1, String p2) {
        this.errorType = errorType;
        this.string1 = p1;
        this.string2 = p2;
        this.errCode = 0;
    }

    public ShortcutException(int errorType, int status) {
        this.errorType = errorType;
        this.string1 = null;
        this.string2 = null;
        this.errCode = status;
    }

    @Override
    public String toString() {
        if (this.errorType == 1) {
            return resources.messageString("JNIShortcutException.parmError.txt", this.string1);
        }
        if (this.errorType == 2) {
            if (this.string2 != null) {
                return resources.messageString("JNIShortcutException.apiError2.txt", this.string1, this.errCode, this.string2);
            }
            return resources.messageString("JNIShortcutException.apiError1.txt", this.string1, this.errCode);
        }
        if (this.errorType == 3) {
            return resources.messageString("JNIShortcutException.noShortcut.txt", this.string1, this.string2);
        }
        if (this.errorType == 4) {
            return resources.messageString("JNIShortcutException.comInitFailed.txt", this.errCode);
        }
        if (this.errorType == 5) {
            return resources.messageString("JNIShortcutException.shellLinkFailed.txt", this.errCode);
        }
        if (this.errorType == 6) {
            return resources.messageString("JNIShortcutException.queryInterfaceFailed.txt", this.errCode);
        }
        if (this.errorType == 7) {
            return resources.messageString("JNIShortcutException.cannotSaveLink.txt", this.string1, this.errCode);
        }
        return resources.messageString("JNIShortcutException.unexpectedError.txt", this.errCode);
    }

    public int getErrorType() {
        return this.errorType;
    }

    public String getParm1() {
        return this.string1;
    }

    public String getParm2() {
        return this.string2;
    }

    public int getErrCode() {
        return this.errCode;
    }
}

