/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.deployjni.disk;

import com.sas.tools.deployjni.Utilities;
import com.sas.tools.deployjni.disk.DiskInfoAPIDef;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class DiskInfoAPI {
    public static String JNI_LIBRARY_PATH = System.getProperty("user.dir");
    public static HashMap<String, String> libNames = new HashMap();

    public static long getFreeDiskSpace(String path) {
        File file = new File(path);
        long space = file.getUsableSpace();
        return space;
    }

    public static long getTotalDiskSpace(String path) {
        File file = new File(path);
        long space = file.getTotalSpace();
        return space;
    }

    public static int GetOctalFileMode(String filepath) {
        String retval = Integer.toOctalString(DiskInfoAPI.GetFileMode(filepath));
        int length = retval.length();
        if (length > 9) {
            retval = retval.substring(length - 9, length);
        }
        return Integer.parseInt(retval);
    }

    public static int SetOctalFileMode(String filepath, int mode) throws Exception {
        if (!new File(filepath).exists()) {
            throw new Exception("Missing file " + filepath + " when try to set  mode to " + mode);
        }
        String fileMode = String.valueOf(mode);
        return DiskInfoAPI.SetFileMode(filepath, Integer.valueOf(fileMode, 8));
    }

    public static int GetFileOwner(String filepath) {
        int retval = -1;
        int osInfo = Utilities.getOS();
        File filename = new File(filepath);
        if (osInfo != 1 && filename.exists()) {
            try {
                Map<String, Object> mapFileAttrs = Files.readAttributes(filename.toPath(), "unix:uid", new LinkOption[0]);
                retval = (Integer)mapFileAttrs.get("uid");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return retval;
    }

    public static int GetFileGroup(String filepath) {
        int retval = -1;
        int osInfo = Utilities.getOS();
        File filename = new File(filepath);
        if (osInfo != 1 && filename.exists()) {
            try {
                Map<String, Object> mapFileAttrs = Files.readAttributes(filename.toPath(), "unix:gid", new LinkOption[0]);
                retval = (Integer)mapFileAttrs.get("gid");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return retval;
    }

    public static int SetFileOwnerGroup(String filepath, int owner, int group) {
        int retval = 0;
        int osInfo = Utilities.getOS();
        File filename = new File(filepath);
        if (osInfo != 1 && filename.exists()) {
            try {
                Files.setAttribute(filename.toPath(), "unix:uid", owner, new LinkOption[0]);
                Files.setAttribute(filename.toPath(), "unix:gid", group, new LinkOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return retval;
    }

    public static int GetFileMode(String filepath) {
        int return_value = 0;
        int osInfo = Utilities.getOS();
        File filename = new File(filepath);
        if (osInfo != 1) {
            if (filename.exists()) {
                try {
                    Map<String, Object> mapFileAttrs = Files.readAttributes(filename.toPath(), "unix:mode", new LinkOption[0]);
                    return_value = (Integer)mapFileAttrs.get("mode");
                    return_value &= 0x1FF;
                }
                catch (IOException e) {
                    return_value = -1;
                }
            } else {
                return_value = -1;
            }
        }
        return return_value;
    }

    public static int SetFileMode(String filepath, int mode) {
        int return_value = 0;
        int osInfo = Utilities.getOS();
        File filename = new File(filepath);
        if (osInfo != 1 && filename.exists()) {
            try {
                Files.setAttribute(filename.toPath(), "unix:mode", mode, new LinkOption[0]);
            }
            catch (IOException e) {
                return_value = -1;
            }
        }
        return return_value;
    }

    public static String GetWinFileVersion(File file) {
        return DiskInfoAPI.GetWinFileVersion(file.getAbsolutePath());
    }

    public static String GetWinFileVersion(String filepath) {
        String retval = null;
        int osInfo = Utilities.getOS();
        if (osInfo == 1) {
            retval = DiskInfoAPIDef.GetWinFileVersion(filepath);
        }
        return retval;
    }

    public static int compareFiles(File file1, File file2) throws Exception {
        if (file1.getName().toLowerCase().endsWith(".jar") || file2.getName().toLowerCase().endsWith(".jar")) {
            return DiskInfoAPI.compareFileVersions(file1, file2);
        }
        if (DiskInfoAPI.GetWinFileVersion(file1) == null && DiskInfoAPI.GetWinFileVersion(file2) == null) {
            long file2Modified;
            long file1Modified = file1.lastModified();
            if (file1Modified > (file2Modified = file2.lastModified())) {
                return -1;
            }
            if (file2Modified > file1Modified) {
                return 1;
            }
            return 0;
        }
        return DiskInfoAPI.compareFileVersions(file1, file2);
    }

    public static int compareFileVersions(File file1, File file2) throws Exception {
        String file1Version = null;
        String file2Version = null;
        if (file1.getName().toLowerCase().endsWith(".jar") || file2.getName().toLowerCase().endsWith(".jar")) {
            file1Version = DiskInfoAPI.getJarFileVersion(file1);
            file2Version = DiskInfoAPI.getJarFileVersion(file2);
        } else {
            file1Version = DiskInfoAPI.GetWinFileVersion(file1);
            file2Version = DiskInfoAPI.GetWinFileVersion(file2);
        }
        return DiskInfoAPI.compareFileVersionStrings(file1Version, file2Version);
    }

    public static String getFileVersion(File file) throws Exception {
        if (file.getName().toLowerCase().endsWith(".jar")) {
            return DiskInfoAPI.getJarFileVersion(file);
        }
        return DiskInfoAPI.GetWinFileVersion(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJarFileVersion(File file) throws Exception {
        String string = file.getAbsolutePath().intern();
        synchronized (string) {
            String version = null;
            JarFile jar = new JarFile(file);
            if (jar != null) {
                Attributes attributes;
                Manifest manifest = jar.getManifest();
                jar.close();
                if (manifest != null && (attributes = manifest.getMainAttributes()) != null) {
                    version = attributes.getValue("Implementation-Version");
                }
            }
            return version;
        }
    }

    public static int compareFileVersionToString(File file1, String file2Version) throws Exception {
        String file1Version = null;
        file1Version = file1.getName().toLowerCase().endsWith(".jar") ? DiskInfoAPI.getJarFileVersion(file1) : DiskInfoAPI.GetWinFileVersion(file1);
        return DiskInfoAPI.compareFileVersionStrings(file1Version, file2Version);
    }

    public static boolean isStringBlank(String string) {
        return string == null || string.length() == 0;
    }

    public static int compareFileVersionStrings(String file1Version, String file2Version) {
        int smallestLength = 0;
        if (DiskInfoAPI.isStringBlank(file1Version) && DiskInfoAPI.isStringBlank(file2Version)) {
            return 0;
        }
        if (DiskInfoAPI.isStringBlank(file1Version) && !DiskInfoAPI.isStringBlank(file2Version)) {
            return 1;
        }
        if (DiskInfoAPI.isStringBlank(file2Version) && !DiskInfoAPI.isStringBlank(file1Version)) {
            return -1;
        }
        if (file1Version.equals(file2Version)) {
            return 0;
        }
        String[] file1VersionNumbers = file1Version.split("\\.");
        String[] file2VersionNumbers = file2Version.split("\\.");
        smallestLength = file1VersionNumbers.length;
        if (file1VersionNumbers.length != file2VersionNumbers.length) {
            smallestLength = file1VersionNumbers.length > file2VersionNumbers.length ? file2VersionNumbers.length : file1VersionNumbers.length;
        }
        for (int i = 0; i < smallestLength; ++i) {
            try {
                Integer file1VersionPart = new Integer(file1VersionNumbers[i]);
                Integer file2VersionPart = new Integer(file2VersionNumbers[i]);
                if (file1VersionPart > file2VersionPart) {
                    return -1;
                }
                if (file2VersionPart <= file1VersionPart) continue;
                return 1;
            }
            catch (NumberFormatException e) {
                if (file1VersionNumbers[i].compareTo(file2VersionNumbers[i]) > 0) {
                    return -1;
                }
                if (file1VersionNumbers[i].compareTo(file2VersionNumbers[i]) >= 0) continue;
                return 1;
            }
        }
        if (file1VersionNumbers.length > file2VersionNumbers.length) {
            return -1;
        }
        return 1;
    }

    static {
        libNames.put("win", "libFileInfoWinW32.dll");
        libNames.put("w64", "libFileInfoWinW64.dll");
        libNames.put("wx6", "libFileInfoWinWX6.dll");
    }
}

