/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.deployjni;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class SSNResource {
    protected static Hashtable m_bundleCache;
    protected boolean m_bResourceFileMissing = false;
    protected String m_strResourceFileName;
    protected ResourceBundle m_bundle;
    protected ClassLoader m_classLoader;

    public SSNResource(String strResourceFileName) {
        this.m_bundle = this._getBundle(strResourceFileName);
    }

    public SSNResource(String strResourceFileName, ClassLoader classLoader) {
        this.m_bundle = this._getBundle(strResourceFileName, classLoader);
    }

    public SSNResource(Class source) {
        String strClassName = source.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        this.m_bundle = this._getBundle(strPackageName + ".PropertyBundle");
    }

    protected ResourceBundle getCachedBundle(String key) {
        if (m_bundleCache == null) {
            m_bundleCache = new Hashtable();
        }
        return (ResourceBundle)m_bundleCache.get(key);
    }

    protected void cacheBundle(String key, ResourceBundle bundle) {
        m_bundleCache.put(key, bundle);
    }

    protected ResourceBundle _getBundle(String strBundlePath) {
        return this._getBundle(strBundlePath, null);
    }

    protected ResourceBundle _getBundle(String strBundlePath, ClassLoader classLoader) {
        ResourceBundle returnValue = this.getCachedBundle(strBundlePath);
        if (returnValue != null) {
            return returnValue;
        }
        Locale locale = null;
        if (System.getProperty("language") != null) {
            locale = new Locale(System.getProperty("language"));
        }
        if (locale == null) {
            locale = Locale.US;
        }
        try {
            returnValue = classLoader != null ? ResourceBundle.getBundle(strBundlePath, locale, classLoader) : ResourceBundle.getBundle(strBundlePath, locale);
        }
        catch (Throwable e) {
            System.out.println("e:  " + e);
            try {
                returnValue = classLoader != null ? PropertyResourceBundle.getBundle(strBundlePath, locale, classLoader) : PropertyResourceBundle.getBundle(strBundlePath, locale);
            }
            catch (Throwable e2) {
                this.m_bResourceFileMissing = true;
                System.err.println(e2.getMessage());
                return null;
            }
        }
        this.cacheBundle(strBundlePath, returnValue);
        this.m_strResourceFileName = strBundlePath;
        return returnValue;
    }

    public void clearBundleCache() {
        m_bundleCache.clear();
    }

    public String getString(String key) {
        String retValue;
        block6: {
            retValue = "";
            if (this.m_bundle == null) {
                try {
                    throw new Throwable();
                }
                catch (Throwable t) {
                    System.err.println("Missing resource #" + key);
                    break block6;
                }
            }
            if (!this.m_bResourceFileMissing) {
                try {
                    retValue = this.m_bundle.getString(key);
                }
                catch (Throwable t) {
                    retValue = "Missing resource " + key;
                    System.err.println(retValue + ". Have you copied your resources?");
                    System.err.println("Missing resource is called from the following:");
                    System.err.println(retValue);
                    t.printStackTrace();
                }
            }
        }
        return retValue;
    }

    public String getRawString(String key) {
        String retValue = null;
        if (this.m_bundle != null && !this.m_bResourceFileMissing) {
            try {
                retValue = this.m_bundle.getString(key);
                retValue = retValue.trim();
            }
            catch (Throwable t) {
                System.err.println("Missing resource #" + key);
            }
        }
        return retValue;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int notFoundReturnValue) {
        try {
            String strValue = this.m_bundle.getString(key);
            return new Integer(strValue);
        }
        catch (Throwable t) {
            System.err.println("Missing resource #" + key);
            return notFoundReturnValue;
        }
    }

    public ImageIcon getImageIcon(String sResourceName) {
        if (sResourceName == null) {
            return null;
        }
        ImageIcon image = null;
        String sImagePath = this.getString("ImageLocation.notrans") + this.getString(sResourceName);
        if (m_bundleCache == null) {
            m_bundleCache = new Hashtable();
        } else {
            image = (ImageIcon)m_bundleCache.get(sImagePath);
            if (image != null) {
                return image;
            }
        }
        try {
            URL url = ClassLoader.getSystemResource(sImagePath);
            image = new ImageIcon(url);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            String sDefaultPath = this.getString("ImageLocation.notrans") + this.getString("Common.Default.Image");
            try {
                URL urlDefault = this.m_classLoader.getResource(sDefaultPath);
                image = new ImageIcon(urlDefault);
            }
            catch (Exception e2) {
                System.err.println(e2.getMessage());
                e2.printStackTrace();
            }
        }
        if (image != null) {
            m_bundleCache.put(sImagePath, image);
        }
        return image;
    }

    public String messageString(String key) {
        String pattern = this.getString(key);
        return pattern;
    }

    public String messageString(String key, Object parm1) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3, Object parm4) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3, Object parm4, Object parm5) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString(), parm5.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3, Object parm4, Object parm5, Object parm6) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString(), parm5.toString(), parm6.toString()};
        return MessageFormat.format(pattern, args);
    }

    public Enumeration getKeys() {
        return this.m_bundle.getKeys();
    }
}

