/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.PrivilegedSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.server.RMISocketFactory;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;

public class RMIUtil {
    private static Hashtable ht_hostNormalized = new Hashtable();
    private static Hashtable ht_IPAddress = new Hashtable();
    private static PrivilegedSocketFactory s_psf;
    private static SimpleDateFormat s_secondsFormatter;
    private static SimpleDateFormat s_minutesFormatter;
    private static SimpleDateFormat s_timeFormatter;
    private static SimpleDateFormat s_dateFormatter;
    private static long S_SECOND;
    private static long S_MINUTE;
    private static long S_HOUR;
    static InetAddress s_iaddr;

    public static String getLocalHost() {
        try {
            return RMIUtil.hostNormalize("localhost");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public static String getHostIPAddress(String host) throws RemoteException {
        String IPAddress = (String)ht_IPAddress.get(host);
        if (IPAddress == null) {
            IPAddress = RMIUtil.lowLevelIPAddress(host);
            ht_IPAddress.put(host, IPAddress);
        }
        return IPAddress;
    }

    public static synchronized String getLocalHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String lowLevelIPAddress(final String host) {
        try {
            if ("localhost".equals(host) || "127.0.0.1".equals(host)) {
                return InetAddress.getLocalHost().getHostAddress();
            }
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return InetAddress.getByName(host).getHostAddress();
                }
            });
        }
        catch (PrivilegedActionException e) {
            e.getException().printStackTrace();
            return null;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String lowLevelIPName(final String hostAddr) {
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return InetAddress.getByName(hostAddr).getHostName();
                }
            });
        }
        catch (PrivilegedActionException e) {
            e.getException().printStackTrace();
            return null;
        }
    }

    private static String localhost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String hostNormalize(String host) throws RemoteException {
        String IPAddress = "";
        String hostNorm = (String)ht_hostNormalized.get(host);
        if (hostNorm == null) {
            hostNorm = "localhost".equals(host) || "127.0.0.1".equals(host) ? RMIUtil.localhost() : host;
            hostNorm = hostNorm.toUpperCase();
            ht_hostNormalized.put(host, hostNorm);
        }
        return hostNorm;
    }

    public static void reset() {
        ht_IPAddress = new Hashtable();
        ht_hostNormalized = new Hashtable();
    }

    public static synchronized PrivilegedSocketFactory trapSocket() throws IOException {
        if (s_psf != null) {
            return s_psf;
        }
        try {
            return (PrivilegedSocketFactory)((Object)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    s_psf = new PrivilegedSocketFactory(RMIUtil.getInetAddress());
                    RMISocketFactory.setSocketFactory((RMISocketFactory)((Object)s_psf));
                    return s_psf;
                }
            }));
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    public static synchronized Object rmilookup(final String key) throws RemoteException, MalformedURLException, NotBoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException, MalformedURLException, NotBoundException {
                    return Naming.lookup(key);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception e2 = e.getException();
            if (e2 instanceof RemoteException) {
                throw (RemoteException)e2;
            }
            if (e2 instanceof MalformedURLException) {
                throw (MalformedURLException)e2;
            }
            throw (NotBoundException)e2;
        }
    }

    public static String currentTimeStamp() {
        return RMIUtil.timeFormat(System.currentTimeMillis());
    }

    public static String dateFormat(long dateValue) {
        return s_dateFormatter.format(new Date(dateValue));
    }

    public static String timeFormat(long dateValue) {
        SimpleDateFormat formatter = null;
        if (dateValue < S_MINUTE) {
            formatter = s_secondsFormatter;
        } else if (dateValue < S_HOUR) {
            formatter = s_minutesFormatter;
        } else {
            formatter = s_timeFormatter;
            formatter.getTimeZone().setRawOffset(0);
        }
        return formatter.format(new Date(dateValue));
    }

    public static void setInetAddress(InetAddress hostAddress) {
        s_iaddr = hostAddress;
    }

    public static void setInetAddress(final String hostName) throws IOException {
        try {
            s_iaddr = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return InetAddress.getByName(hostName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    public static InetAddress getInetAddress() {
        if (s_iaddr == null) {
            try {
                s_iaddr = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return InetAddress.getLocalHost();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                e.getException().printStackTrace();
            }
        }
        return s_iaddr;
    }

    static synchronized String getPrivilegedLocalHost() {
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    return InetAddress.getLocalHost().getHostName();
                }
            });
        }
        catch (PrivilegedActionException e) {
            return "localhost";
        }
    }

    static {
        s_secondsFormatter = new SimpleDateFormat("s.SSS");
        s_minutesFormatter = new SimpleDateFormat("m:ss");
        s_timeFormatter = new SimpleDateFormat("HH:mm:ss");
        s_dateFormatter = new SimpleDateFormat("dd MMM HH:mm:ss");
        S_SECOND = 1000L;
        S_MINUTE = 60L * S_SECOND;
        S_HOUR = 60L * S_MINUTE;
    }
}

