/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.rmi.transport.proxy.RMIMasterSocketFactory;

public class PrivilegedSocketFactory
extends RMIMasterSocketFactory {
    InetAddress iaddr;

    public PrivilegedSocketFactory() {
        this(null);
    }

    public PrivilegedSocketFactory(InetAddress iaddr) {
        this.iaddr = iaddr;
    }

    public Socket createSocket(final String host, final int port) throws IOException {
        try {
            return (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    PrivilegedSocketFactory.this.p("Socket(" + host + "," + port + ")");
                    return new Socket(host, port);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    public ServerSocket createServerSocket(final int port) throws IOException {
        try {
            return (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    PrivilegedSocketFactory.this.p("ServerSocket(" + port + ",50," + (PrivilegedSocketFactory.this.iaddr == null ? "null" : PrivilegedSocketFactory.this.iaddr.getHostAddress()) + ")");
                    return new ServerSocket(port, 50, PrivilegedSocketFactory.this.iaddr);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private void p(String s) {
    }
}

