/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.StringTokenizer;
import sun.misc.Launcher;

public class MWSClassLoader
extends URLClassLoader {
    private static URLStreamHandlerFactory factory;
    static boolean bPrintClasses;
    private static URLStreamHandler fileHandler;

    public static void printClasses(boolean b) {
        bPrintClasses = b;
    }

    public static boolean isDynamicClass(Class testClass) {
        return MWSClassLoader.class.equals((Object)testClass.getClassLoader());
    }

    public URL[] getParentURLs() {
        int i;
        ClassLoader loader;
        int num = 0;
        for (loader = this.getParent(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            num += ((URLClassLoader)loader).getURLs().length;
        }
        URL[] boot = Launcher.getBootstrapClassPath().getURLs();
        URL[] urls = new URL[num += boot.length];
        num = 0;
        for (loader = this.getParent(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            URL[] u = ((URLClassLoader)loader).getURLs();
            for (i = 0; i < u.length; ++i) {
                urls[num++] = u[i];
            }
        }
        for (i = 0; i < boot.length; ++i) {
            urls[num++] = boot[i];
        }
        return urls;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = super.loadClass(name, resolve);
        return c;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> c = null;
        c = super.findClass(name);
        return c;
    }

    static URL[] getFileURLs() {
        File[] dirs;
        String s = System.getProperty("mws.class.path");
        String p = System.getProperty("mws.util.path");
        int urlCount = 0;
        int urlIdx = 0;
        int count = 0;
        int pCount = 0;
        StringTokenizer st = null;
        StringTokenizer stP = null;
        if (s != null) {
            st = new StringTokenizer(s, File.pathSeparator);
            count = st.countTokens();
        }
        if (p != null) {
            stP = new StringTokenizer(p, File.pathSeparator);
            pCount = stP.countTokens();
        }
        if (count > 0 || pCount > 0) {
            String[] fileNames;
            int i;
            dirs = new File[count + pCount];
            for (i = 0; i < pCount; ++i) {
                dirs[i] = new File(stP.nextToken());
                if (dirs[i].exists()) {
                    if (!dirs[i].isDirectory()) continue;
                    fileNames = dirs[i].list();
                    urlCount += fileNames.length;
                    continue;
                }
                System.out.println("MWSClassLoader: given MWS util classpath " + dirs[i].getAbsolutePath() + " does not exist.");
            }
            for (i = pCount; i < count + pCount; ++i) {
                dirs[i] = new File(st.nextToken());
                if (dirs[i].exists()) {
                    if (!dirs[i].isDirectory()) continue;
                    fileNames = dirs[i].list();
                    urlCount += fileNames.length;
                    continue;
                }
                System.out.println("MWSClassLoader: given MWS classpath " + dirs[i].getAbsolutePath() + " does not exist.");
            }
        } else {
            dirs = new File[]{};
        }
        URL[] urls = new URL[urlCount];
        for (int i = 0; i < dirs.length; ++i) {
            File file = dirs[i];
            if (!dirs[i].exists()) continue;
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String path = file.getAbsolutePath();
            if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith("/") && file.isDirectory()) {
                path = path + "/";
            }
            if (fileHandler == null) {
                fileHandler = factory.createURLStreamHandler("file");
            }
            String[] fileNames = dirs[i].list();
            for (int j = 0; j < fileNames.length; ++j) {
                String urlPath = path + fileNames[j];
                File f = new File(urlPath);
                if (f.isDirectory()) {
                    urlPath = urlPath + "/";
                }
                try {
                    urls[urlIdx++] = new URL("file", "", -1, urlPath, fileHandler);
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new InternalError();
                }
            }
        }
        return urls;
    }

    public MWSClassLoader(boolean log) {
        super(MWSClassLoader.getFileURLs());
        String utilsPath;
        MWSClassLoader.printClasses(log);
        String classPath = System.getProperty("mws.class.path");
        if (classPath == null) {
            System.out.println("MWSClassLoader classpath is not set.");
        }
        if ((utilsPath = System.getProperty("mws.util.path")) == null) {
            System.out.println("MWSClassLoader util path is not set.");
        }
        if (classPath != null) {
            System.out.println("Using a new class loader for classpath: " + classPath);
            if (utilsPath != null) {
                System.out.println("Util path changed: " + utilsPath);
            }
        }
        if (bPrintClasses) {
            int i;
            System.out.println("New class loader is " + this);
            System.out.println("parent is " + this.getParent());
            URL[] urls = this.getURLs();
            for (i = 0; i < urls.length; ++i) {
                System.out.println("MWS URL: " + urls[i]);
            }
            urls = ((URLClassLoader)this.getParent()).getURLs();
            for (i = 0; i < urls.length; ++i) {
                System.out.println("classpath URL: " + urls[i]);
            }
            urls = ((URLClassLoader)this.getParent().getParent()).getURLs();
            for (i = 0; i < urls.length; ++i) {
                System.out.println("extension URL: " + urls[i]);
            }
        }
    }

    static {
        bPrintClasses = false;
        factory = new Factory();
    }

    private static class Factory
    implements URLStreamHandlerFactory {
        private static String PREFIX = "sun.net.www.protocol";

        private Factory() {
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            String name = PREFIX + "." + protocol + ".Handler";
            try {
                Class<?> c = Class.forName(name);
                return (URLStreamHandler)c.newInstance();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            throw new InternalError("could not load " + protocol + "system protocol handler");
        }
    }
}

